# -*- coding: iso8859-2 -*-

"""
Skript zobraz msto adjustovanch rezidu v kontingenn tabulce znamnkov 
schma.

Vstupem skriptu je tabulka z procedury Crosstabs, kter obsahuje adjustovan
rezidua, oekvan a pozorovan etnosti. Vstupem je tabulka, ve kter jsou
msto adjustovanch rezidu znamnka, a to podle tohoto schmatu
je-li |z| < 1.96, je pepsno na "o"
je-li 1.96 =< |z| < 2.58, je pepsno na "+", resp. "-"
je-li 2.58 =< |z| < 3.29, je pepsno na "++", resp. "--"
je-li |z| >= 3.29, je pepsno na "+++", resp. "---"

V ppad malho potu oekvanch pozorovn lze vyut k vpotu znamnkovho
schmatu binomick test. Pomoc binomickho testu se pro kadou bunku (i,j)
otestuje nulov hypotza, e pozorovan etnosti n_ij maj binomick rozdlen
Bi(n_i+,p), kde p je rovno E_ij/E_i+ (tj. oekvan etnosti pro bunku (i,j) dleno
oekvan etnosti pro i-t dek). Na zklad signifikanc (sig) testu se vytvo
znamnka, a to podle schmatu
je-li sig >= 0.05, je znamnko "o"
je-li 0.01 < sig < 0.05, je znamnko "+", resp. "-"
je-li 0.001 =< sig < 0.01, je znamnko "++", resp. "--"
je-li sig < 0.001, je znamnko "+++", resp. "---".

Skript nejdve najde oznaenou tabulku. Jsou-li statistiky v dcch, zpivotuje 
tabulku tak, aby statistiky byly v dcch na nejvy rovni. Pak nalezne 
podtabulku obsahujc adjustovan rezidua a postupn ji prochz a pepisuje 
rezidua na znamnka.  Pi zpracovn je pislun tabulka zaven, po ukonen
zpracovn se znovu oteve.

Skript lze pout na vce vybranch tabulek.

Nov je mon adjustace pomoc Holmovy metody. Vbr se d vodnm dialogem.
V kombinaci s Holmovou metodou nelze skript pout pro tabulky se zapnutou funkc
Split file - Compare groups.

Holmova sekvenn metoda testuje nejvt reziduu (v absolutn hodnot) na poadovan
hladin dleno potem vech rezidu. Nelze-li zamtnout nulovou hypotzu (tj. reziduum
je men ne pslun kritick hodnota), pak nelze zamtnout nulovou hypotzu ani
u ostatnch rezidu. Zamtne-li se nulov hypotza u nejvtho rezidua, postupuje se
k druhmu nejvtmu reziduu, kter se testuje na poadovan hladin dleno poet vech
rezidu - 1. Dle se postupuje analogicky prvnmu kroku. V ppad shody rezidu se
tato testuj na nejmen hladin pslun tmto rezidum. Tato metoda je popsan nap.
v knize ehk, ehkov (1986): Analza kategorizovanch dat v sociologii. 

"""
__author__  = 'Eliska Kalinova  ekalinova@acrea.cz a Katarna Vlkov kvlckova@acrea.cz'
__version__ = '9.0'
__date__ = '30.4.2015'

from tkinter import *
import sys
import SpssClient
from math import sqrt
from math import pow

class Dialog:
   """ Trida pro zobrazeni uvodniho dialogu. """
   def start(self):
      ### Parametry okna
      windowWidth=270
      windowHeight=300
      bgColor='#f0f0f0'     
      ### Parametry objekt
      ###### Ohranien
      masterRelief=GROOVE
      framewidth=200     
      ###### Fonty
      titleFont = "Arial 14 bold"
      titleFontColor='#23238E'
      frameFont = "Arial 10 bold"
      frameFontColor='#cc0000' 
      objectFont = "Arial 8"
      objectFontColor='#000000'
      ###### Odsazen
      outerPadX=10
      outerPadY=10
      innerPadX=10
      innerPadY=10
      ###### Barvy
      masterColor='#f0f0f0'
      subColor='#f0f0f0'        
      
      ### Okno vodnho dialogu
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( windowWidth, windowHeight, (w-windowWidth)/2, (h-windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit ) #funkce pi zaven kkem     
      ### Rm titulku
      fTitle = LabelFrame(self.okno)
      fTitle.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      info= Label(fTitle , text=u'Znamnkov schma', bg=subColor, font = titleFont ,fg=titleFontColor)
      info.pack(side=LEFT)
      fTitle.pack(anchor=NW, expand=1, fill=X, padx=outerPadX, pady=0)
      ### Rm OptionButton
      self.Holm = IntVar()
      self.Holm.set(0)
      fOptionButton = LabelFrame(self.okno,text=u'Pout Holmovu metodu')
      fOptionButton.config(relief=masterRelief,padx=innerPadX,pady=innerPadY,bg=subColor,font=frameFont,fg=frameFontColor,width=framewidth)
      OptionButton1=Radiobutton(fOptionButton, text=u'ne', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.Holm, value=0)
      OptionButton1.select()
      OptionButton1.pack(anchor=W)
      OptionButton2=Radiobutton(fOptionButton, text=u'ano', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.Holm, value=1)
      OptionButton2.pack(anchor=W)
      fOptionButton.pack(anchor=W, padx=outerPadX, pady=outerPadY)
      ###Rm pro binomick test
            ### Rm OptionButton
      self.Binom = IntVar()
      self.Binom.set(0)
      fOptionButton3 = LabelFrame(self.okno,text=u'Pout Binomick test')
      fOptionButton3.config(relief=masterRelief,padx=innerPadX,pady=innerPadY,bg=subColor,font=frameFont,fg=frameFontColor,width=framewidth)
      OptionButton4=Radiobutton(fOptionButton3, text=u'ne', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.Binom, value=0)
      OptionButton4.pack(anchor=W)
      OptionButton5=Radiobutton(fOptionButton3, text=u'ano', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.Binom, value=1)
      OptionButton5.select()
      OptionButton5.pack(anchor=W)      
      fOptionButton3.pack(anchor=W, padx=outerPadX, pady=outerPadY)   
      ### Rm NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      fNavButton.pack(anchor = SW, fill=X, expand=1, pady=0, padx=0)   
      ### Tlatka   
      Button(fNavButton, text="OK", command=self.callOkButton, width = 8).pack(side=LEFT, padx=5, pady=5)
      Button(fNavButton, text="Storno", command=self.callCancelButton, width = 8).pack(side=LEFT, padx=5, pady=5)
      ### Copyright
      cop = Label(fNavButton , text= u'Copyright ACREA CR', bg=subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)
      
      self.okno.mainloop()

   ### Funkce tlatka OK vetn naten slovnku
   def callOkButton(self): 
      """ Povoleni pokracovani skriptu. """          
##      self.okno.quit()
      self.okno.destroy() 

   ### Funkce tlatka Cancel          
   def callCancelButton(self):
      """ Zruseni pokracovani skriptu. """
##      self.okno.quit()
      sys.exit()
 
class Warning:
   """ Trida pro zobrazeni chyboveho hlaseni. """   
   # Parametry okna
   windowWidth=270
   windowHeight=90
   bgColor='#f0f0f0'
   # Parametry objekt
   ### fonty
   objectFont = "Arial 8"
   objectFontColor='#000000'
   ### odsazen
   outerPadX=10
   outerPadY=10
   ### barvy
   masterColor='#f0f0f0'
   subColor='#f0f0f0'
   # Text chybovho hlen
   hlaska = u"Nevhodn tabulka."

   def start(self): 
      """ Zobrazeni dialogu s popisem chyby. """
      # Okno s popisem chyby pi natn slovnku
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( self.windowWidth, self.windowHeight, (w-self.windowWidth)/2, (h-self.windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=self.bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit) #funkce pi zaven kkem 
      # Text chybovho hlen
      hlaseni = Label(self.okno, font=self.objectFont, text=self.hlaska) 
      hlaseni.pack(padx=self.outerPadX, pady=self.outerPadY)
      # Rm NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=self.subColor)
      fNavButton.pack(anchor=SW, fill=X, expand=1, pady=0, padx=0)
      # Tlatko OK
      Button(fNavButton, text="OK", command=self.callOkButton, width=8).pack(side=LEFT, padx=5, pady=5)             
      # Copyright
      cop= Label(fNavButton , text= u'Copyright ACREA CR', bg=self.subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)  
                  
      self.okno.mainloop()
      
   # Funkce tlatka OK 
   def callOkButton(self):
      """ Potvrzeni dialogu. """          
      self.okno.quit()           

def vypocet_signifikance_norm(x):
   """ Provadi vypocet signifikance pro standardni normalni rozdeleni. """
   a1 = 0.0705230784
   a2 = 0.0422820123
   a3 = 0.0092705272
   a4 = 0.0001520143
   a5 = 0.0002765672
   a6 = 0.0000430638
   if abs(x) <= 14.14:
      Z = sqrt(2)/2 * abs(x)
   else:
      Z = 10
   return((1+Z*(a1+Z*(a2+Z*(a3+Z*(a4+Z*(a5+Z*(a6)))))))**(-16))*0.5

def SignScheme(objPivotTable,Holm,Binom):
   """ Prepsani adjustovanych rezidui na znamenkove schema. """
   start = 0
   startObserved = 0
   startExpected = 0
   endExpected = 0
   objOutputItem.SetVisible(False)
   objPivotTable.SetUpdateScreen(False) 
   # Nalezen podtabulky obsahujc adjustovan rezidua
   objSpssLabels = objPivotTable.RowLabelArray()
   i = 0
   while i < objSpssLabels.GetNumRows():
      if objSpssLabels.GetValueAt(i,1) == "Adjusted Residual":
         start = i # Index, od kterho zan podtabulka s adjustovanmi rezidui
         objSpssLabels.SetValueAt(i,1,"Sign scheme") 
         i = objSpssLabels.GetNumRows()  
      else:
         i = i + 1
   i = 0     
   while i < objSpssLabels.GetNumRows():
      if objSpssLabels.GetValueAt(i,1) == "Expected Count":
         startExpected = i 
         j=i+1
         while j < objSpssLabels.GetNumRows():
            if objSpssLabels.GetValueAt(j,1) != "Expected Count":
               endExpected = j-1
               j = objSpssLabels.GetNumRows()
            else:
               j=j+1
         i = objSpssLabels.GetNumRows()
      else:
         i = i + 1
   i = 0     
   while i < objSpssLabels.GetNumRows():
      if objSpssLabels.GetValueAt(i,1) == "Count":
         startObserved = i 
         i = objSpssLabels.GetNumRows()  
      else:
         i = i + 1     
   if Holm == 0:  # Bez adjustace.
      # Prchod podtabulkou obsahujc adjustovan rezidua
      znamenka = []
      objDataCells = objPivotTable.DataCellArray()
      objPivotTable.ClearSelection()
      for i in range(start,objDataCells.GetNumRows()):
         for j in range(objDataCells.GetNumColumns()-1):
            try:
               ExpectedCN = objDataCells.GetUnformattedValueAt(i-start+startExpected,j)
               ExpectedC = float(ExpectedCN)  # Konverze stringu na floating point
               if (ExpectedC < 5)&(Binom ==1):
                  ExpectedTN = objDataCells.GetUnformattedValueAt(i-start+startExpected,objDataCells.GetNumColumns()-1)
                  ExpectedT = float(ExpectedTN)  # Konverze stringu na floating point
                  pi=ExpectedC/ExpectedT
                  ObservedCN = objDataCells.GetUnformattedValueAt(i-start+startObserved,j)
                  ObservedC = int(float(ObservedCN))
                  ObservedTN = objDataCells.GetUnformattedValueAt(i-start+startObserved,objDataCells.GetNumColumns()-1)
                  ObservedT = int(float(ObservedTN))
                  pval=binomtest(ObservedC,ObservedT,pi,typ="one sided")
                  if pval > 0.05:
                     objDataCells.SetValueAt(i,j,"o*")
                     znamenka.append("o*")
                  elif pval > 0.01:
                     if (ObservedC-ExpectedC) > 0:
                        objDataCells.SetValueAt(i,j,"+*")
                        znamenka.append("+*")
                     else:
                        objDataCells.SetValueAt(i,j,"-*")
                        znamenka.append("-*")
                  elif pval > 0.001:
                     if (ObservedC-ExpectedC) > 0:
                        objDataCells.SetValueAt(i,j,"++*")
                        znamenka.append("++*")
                     else:
                        objDataCells.SetValueAt(i,j,"--*")
                        znamenka.append("--*")      
                  else:
                     if (ObservedC-ExpectedC) > 0:
                        objDataCells.SetValueAt(i,j,"+++*")
                        znamenka.append("+++*")
                     else:
                        objDataCells.SetValueAt(i,j,"---*")
                        znamenka.append("---*")
                  poznamka = u"* Binomial test was used."
                  objPivotTable.SetCaptionText(poznamka)     
               else:
                  s = objDataCells.GetUnformattedValueAt(i,j)
                  z = float(s)  # Konverze stringu na floating point
                  if abs(z) < 1.96:
                     objDataCells.SetValueAt(i,j,"o")
                     znamenka.append("o")
                  elif abs(z) < 2.58:
                     if z > 0:
                        objDataCells.SetValueAt(i,j,"+")
                        znamenka.append("+")
                     else:
                        objDataCells.SetValueAt(i,j,"-")
                        znamenka.append("-")
                  elif abs(z) < 3.29:
                     if z > 0:
                        objDataCells.SetValueAt(i,j,"++")
                        znamenka.append("++")
                     else:
                        objDataCells.SetValueAt(i,j,"--")
                        znamenka.append("--")      
                  else:
                     if z > 0:
                        objDataCells.SetValueAt(i,j,"+++")
                        znamenka.append("+++")
                     else:
                        objDataCells.SetValueAt(i,j,"---")
                        znamenka.append("---")
            except:
               pass
      # Zvren formtovn 
      for i in range(start,objDataCells.GetNumRows()):
         for j in range(objDataCells.GetNumColumns()):
            try:
               z = objDataCells.GetValueAt(i,j)
               objDataCells.SetTextSizeAt(i,j,11)
               objDataCells.SetTextStyleAt(i,j,SpssClient.SpssTextStyleTypes.SpssTSBold)
               objDataCells.SetHAlignAt(i,j,SpssClient.SpssHAlignTypes.SpssHAlCenter)            
               if z == "+" or z == "++" or z == "+++" or z == "+*" or z == "++*" or z == "+++*":
                  objDataCells.SetTextColorAt(i,j,255)
               if z == "-" or z == "--" or z == "---" or z == "-*" or z == "--*" or z == "---*":
                  objDataCells.SetTextColorAt(i,j,32768)             
            except:
               pass   
   else:
      # Naten rezidu a aplikace Holmovy sekvenn metody.
      rezidua = []#Tabulka obsahuje p-hodnotu, reziduum, alebo rozdiel medzi oakvanmi a pozorovanmi etnosti, pvodn poradie, phodnotu po Holmovej metode a znamienkov schma, barvu znamenka
      objDataCells = objPivotTable.DataCellArray()
      objPivotTable.ClearSelection()
      for i in range(start,objDataCells.GetNumRows()):
         for j in range(objDataCells.GetNumColumns()):
            try:
               ExpectedCN = objDataCells.GetUnformattedValueAt(i-start+startExpected,j)
               ExpectedC = float(ExpectedCN)  # Konverze stringu na floating point
               if (ExpectedC < 5)&(Binom == 1):
                  ExpectedTN = objDataCells.GetUnformattedValueAt(i-start+startExpected,objDataCells.GetNumColumns()-1)
                  ExpectedT = float(ExpectedTN) 
                  pi=ExpectedC/ExpectedT
                  ObservedCN = objDataCells.GetUnformattedValueAt(i-start+startObserved,j)
                  ObservedC = int(float(ObservedCN))
                  ObservedTN = objDataCells.GetUnformattedValueAt(i-start+startObserved,objDataCells.GetNumColumns()-1)
                  ObservedT = int(float(ObservedTN))
                  pval=binomtest(ObservedC,ObservedT,pi,typ="two sided")
                  rezidua.append([pval,ObservedC-ExpectedC,len(rezidua)])
               else:
                  z = float(objDataCells.GetUnformattedValueAt(i,j))
                  rezidua.append([2*vypocet_signifikance_norm(abs(z)),z,len(rezidua)])
            except:
               pass
      rezidua.sort(reverse=False) # Seazen sestupn dle absolutn hodnoty rezidua, co je ekvivalentn vzestupnho azen dle signifikanc.
      jmenovatel = []#hodnota menovatela
      jmenovatel.append(len(rezidua))
      for i in range(1,len(rezidua)):
         if rezidua[i][0] == rezidua[i-1][0]:
            jmenovatel.append(jmenovatel[i-1])
         else:   
            jmenovatel.append(len(rezidua)-i)   
      ### Porovnn s hladinou 0.05.
      i = 0
      while i < len(rezidua):
         if rezidua[i][0] >= 0.05/jmenovatel[i]:
            rezidua[i].append(0.05/jmenovatel[i])#pripisujeme zmenenu signif.
            rezidua[i].append("o")
            rezidua[i].append(0)
            for j in range(i+1,len(rezidua)):
               rezidua[j].append(0.05/jmenovatel[j])
               rezidua[j].append("o")
               rezidua[j].append(0)
            i = len(rezidua)
         else:
            i += 1
      ### Porovnn s hladinou 0.01.
      i = 0
      while i < len(rezidua):               
         if rezidua[i][0] >= (0.01/jmenovatel[i]) and rezidua[i][0] < (0.05/jmenovatel[i]):
            j = i
            while j < len(rezidua):
               rezidua[j].append(0.01/jmenovatel[j])
               if rezidua[j][1] > 0:
                  rezidua[j].append("+")
                  rezidua[j].append(255)            
               else:
                  rezidua[j].append("-")
                  rezidua[j].append(32768)
               j = j+1
               if j < len(rezidua) and rezidua[j][0] >= (0.05/jmenovatel[j]):
                  j = len(rezidua)
            i = len(rezidua)                  
         else:
            i += 1
      ### Porovnn s hladinou 0.001.            
      i = 0
      while i < len(rezidua):               
         if rezidua[i][0] >= (0.001/jmenovatel[i]) and rezidua[i][0] < (0.01/jmenovatel[i]):
            j = i
            while j < len(rezidua):
               rezidua[j].append(0.001/jmenovatel[j])
               if rezidua[j][1] > 0:                  
                  rezidua[j].append("++")
                  rezidua[j].append(255)            
               else:
                  rezidua[j].append("--")
                  rezidua[j].append(32768)
               j = j+1
               if j < len(rezidua) and reziduprinta[j][0] >= (0.01/jmenovatel[j]):
                  j = len(rezidua)
            i = len(rezidua)
         else:
            i += 1
      ### Zbytek po porovnn s hladinou 0.001.
      i = 0
      while i < len(rezidua):               
         if rezidua[i][0] < (0.001/jmenovatel[i]):
            rezidua[i].append(0.001/jmenovatel[i])                             
            if rezidua[i][1] > 0:
               rezidua[i].append("+++")
               rezidua[i].append(255)            
            else:
               rezidua[i].append("---")
               rezidua[i].append(32768)
            i = i+1
         else:
            i = len(rezidua)                           
      rezidua.sort(key=lambda x:x[2]) # Nvrat k pvodnmu azen.
      # Pedn znamnek do tabulky.
      k = 0
      for i in range(start,objDataCells.GetNumRows()):
         for j in range(objDataCells.GetNumColumns()-1):
            ExpectedCN = objDataCells.GetUnformattedValueAt(i-start+startExpected,j)
            ExpectedC = float(ExpectedCN)
            if (ExpectedC < 5)&(Binom == 1):
               rezidua[k][-2] = rezidua[k][-2] + "*"
               poznamka = u"* Binomial test was used."
               objPivotTable.SetCaptionText(poznamka)
               objDataCells.SetValueAt(i,j,rezidua[k][-2])
               objDataCells.SetTextSizeAt(i,j,11)
               objDataCells.SetTextStyleAt(i,j,SpssClient.SpssTextStyleTypes.SpssTSBold)
               objDataCells.SetHAlignAt(i,j,SpssClient.SpssHAlignTypes.SpssHAlCenter)
               objDataCells.SetTextColorAt(i,j,rezidua[k][-1])
               k = k + 1
            else:
               if objDataCells.GetValueAt(i,j) != "":
                  objDataCells.SetValueAt(i,j,rezidua[k][-2])      
                  objDataCells.SetTextSizeAt(i,j,11)
                  objDataCells.SetTextStyleAt(i,j,SpssClient.SpssTextStyleTypes.SpssTSBold)
                  objDataCells.SetHAlignAt(i,j,SpssClient.SpssHAlignTypes.SpssHAlCenter)
                  objDataCells.SetTextColorAt(i,j,rezidua[k][-1])
                  k = k + 1
               
   #objPivotTable.SetCaptionText("Znamnkov schma bylo vytvoeno pomoc Holmovy sekvenn metody.")      
   objPivotTable.SetUpdateScreen(True)
   objOutputItem.SetVisible(True)
         
def pivote(objPivotTable):
   """ Pivotace tabulky. """
   # Pivotace tabulky - statistiky do nejvy rovn v dcch     
   objPivotManager = objPivotTable.PivotManager()
   for i in range(objPivotManager.GetNumRowDimensions()):
      objRowDim = objPivotManager.GetRowDimension(i)
      if objRowDim.GetDimensionName() == "Statistics":
         objRowDim.MoveToRow(objPivotManager.GetNumRowDimensions())
         objRowDim.HideLabel()
         break            


def komb(k,n):
   """Vpoet kombinanho sla"""
   f1=1
   f2=1
   if n==0:
      return 1
   else:
      if k==0:
         return 1
      else:
         if k < (n-k):
            for i in range(n-k+1,n+1):
               f1 = float(f1*i)
            for i in range(1,k+1):
               f2 = float(f2*i)
         else:
            for i in range(k+1,n+1):
               f1 = float(f1*i)
            for i in range(1,n-k+1):
               f2 = float(f2*i)
         return(f1/f2)

def pbinom(k,n,p):
   """vpoet distribunej funkcie binomickho rozdelenia"""
   sum1 = 0
   sum2 = 0
   phod=0
   if (k<0)|(n<0):
      return(phod)
   else:
      for i in range(0,int(k)):
         sum2=sum2+komb(i,n)*pow(p,i)*pow(1-p,n-i)
      sum1 = sum2 + komb(k,n)*pow(p,k)*pow(1-p,n-k)
      m = n*p
      if k < m:
         phod = sum1
      else:
         phod = 1 - sum2
      return(phod)   

def binomtest(k,n,p,typ):
   """Pota binomick test"""
   phod = 0
   if typ=="two sided":
      d = komb(k,n)*pow(p,k)*pow(1-p,n-k)
      m= n*p
      if k < m:
         y = 0
         for i in range(int(round(m)),n+1):
            y = y + (komb(i,n)*pow(p,i)*pow(1-p,n-i) <= d)
         phod = pbinom(k,n,p)+ pbinom(n-y+1,n,p)
      else:
         if k == n*p:
            phod=1
         else:
            y = 0
            for i in range(0,int(round(m))+1):
               y = y + (komb(i,n)*pow(p,i)*pow(1-p,n-i) <= d)
            phod = pbinom(y-1,n,p) + pbinom(k,n,p)
   else:
      phod = pbinom(k,n,p)
   return(phod)
               

def test(objPivotTable):
   """ Test pritomnosti adjustovanych rezidui a zapnuti funkce Split file. """
   foundExpected=0#Indiktor, zda tabulka obsahuje oekvan etnosti: 0=ne, 1= ano.
   foundObserved=0#Indiktor, zda tabulka obsahuje etnosti: 0=ne, 1=ano.
   found = 0 # Indiktor, zda tabulka obsahuje adjustovan rezidua: 0 = ne, 1 = ano.
   split = 0 # Indiktor, zda nen zapnuta funkce Split file - Compare groups: 0 = ne, 1 = ano.
   objPivotTable.SetUpdateScreen(False)
   objPivotManager = objPivotTable.PivotManager()
   if objPivotManager.GetNumLayerDimensions() > 0:
      objLayerDim = objPivotManager.GetLayerDimension(0)
      objRowLabels = objPivotTable.RowLabelArray()
      chyba_tabulka = Warning()
      chyba_tabulka.windowWidth = 260
      chyba_tabulka.windowHeight = 95
      chyba_tabulka.hlaska = u"Tabulka neobsahuje adjustovan rezidua nebo \noekvan nebo pozorovan etnosti." 
      chyba_tabulka.start()
      if objRowLabels.GetNumColumns() > 3:
         split = 1
   else:
      objSpssLabels = objPivotTable.RowLabelArray()
      for i in range(objSpssLabels.GetNumRows()):
         for j in range(objSpssLabels.GetNumColumns()):
            if objSpssLabels.GetValueAt(i,j) == "Expected Count":
               foundExpected = 1
            if objSpssLabels.GetValueAt(i,j) == "Count":
               foundObserved = 1
            if objSpssLabels.GetValueAt(i,j) == "Adjusted Residual":
               found = 1  # Nalezana adjustovan rezidua
               break   
      if objSpssLabels.GetNumColumns() > 5:
         split = 1
      
      if found == 1:#*
         if foundExpected == 0:
            objPivotTable.SetUpdateScreen(True)
            if foundObserved==0:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 260
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Tabulka neobsahuje oekvan a pozorovan etnosti." 
               chyba_tabulka.start()
            else:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 260
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Tabulka neobsahuje oekvan etnosti." 
               chyba_tabulka.start()
         else:
            if foundObserved == 0:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 260
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Tabulka neobsahuje pozorovan etnosti."
               chyba_tabulka.start()
            else:
               uvod = Dialog()
               uvod.start()
               Holm = uvod.Holm.get()
               Binom =uvod.Binom.get()

               pivote(objPivotTable)
               objPivotTable.SetUpdateScreen(True)
               if split == 1 and Holm == 1:
                  print("Holm")
                  objPivotTable.SetUpdateScreen(True)
                  chyba_tabulka = Warning()
                  chyba_tabulka.windowWidth = 260
                  chyba_tabulka.windowHeight = 95
                  chyba_tabulka.hlaska = u"Nelze zpracovat tabulku vytvoenou s pouitm \nfunkce Split file - Compare groups." 
                  chyba_tabulka.start()
               else:
                  SignScheme(objPivotTable,Holm,Binom)
      else:
         objPivotTable.SetUpdateScreen(True)
         if foundExpected == 0:
            if foundObserved==0:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 260
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Tabulka neobsahuje adjustovan rezidua a \noekvan a pozorovan etnosti." 
               chyba_tabulka.start()
            else:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 230
               chyba_tabulka.windowHeight = 80
               chyba_tabulka.hlaska = u"Tabulka neobsahuje adjustovan rezidua a oekvan etnosti." 
               chyba_tabulka.start()
         else:
            if foundObserved==0:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 260
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Tabulka neobsahuje adjustovan rezidua a pozorovan etnosti." 
               chyba_tabulka.start()
            else:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 230
               chyba_tabulka.windowHeight = 80
               chyba_tabulka.hlaska = u"Tabulka neobsahuje adjustovan rezidua." 
               chyba_tabulka.start()       

try:

   SpssClient.StartClient()
   pocet = 0

   # Naten vstupovho okna a jeho obsahu
   objOutputDoc = SpssClient.GetDesignatedOutputDoc()
   objOutputItems = objOutputDoc.GetOutputItems()

   # Nalezen oznaen kontingenn tabulky
   for index in range(objOutputItems.Size()):
      objOutputItem = objOutputItems.GetItemAt(index)
      if objOutputItem.IsSelected() \
         and objOutputItem.GetSubType() == "Crosstabulation" :
            objPivotTable = objOutputItem.GetSpecificType()
            pocet = pocet + 1
            test(objPivotTable)
            objPivotTable.Autofit()
   if pocet == 0:
      chyba_tabulka = Warning()
      chyba_tabulka.windowWidth = 210
      chyba_tabulka.windowHeight = 80
      chyba_tabulka.hlaska = u"Nebyla vybrna kontingenn tabulka." 
      chyba_tabulka.start()
except:
   pass
finally:
   SpssClient.StopClient()
