# -*- coding: iso8859-2 -*-

"""
Skript zobraz msto adjustovanch rezidu v kontingenn tabulce znamnkov 
schma.

Vstupem skriptu je tabulka z procedury Crosstabs, kter obsahuje adjustovan
rezidua. Vstupem je tabulka, ve kter jsou msto adjustovanch rezidu 
znamnka, a to podle tohoto schmatu
je-li |z| < 1.96, je pepsno na "o"
je-li 1.96 =< |z| < 2.58, je pepsno na "+", resp. "-"
je-li 2.58 =< |z| < 3.29, je pepsno na "++", resp. "--"
je-li |z| >= 3.29, je pepsno na "+++", resp. "---"

Skript nejdve najde oznaenou tabulku. Jsou-li statistiky v dcch, zpivotuje 
tabulku tak, aby statistiky byly v dcch na nejvy rovni. Pak nalezne 
podtabulku obsahujc adjustovan rezidua a postupn ji prochz a pepisuje 
rezidua na znamnka. Jsou-li adjustovan rezidua ve vrstvch, tabulka se 
nepivotuje, pouze se adjustovan rezidua pepou na znamnka. Pi zpracovn 
je pislun tabulka zaven, po ukonen zpracovn se znovu oteve.

Skript lze pout na vce vybranch tabulek.

Nov je mon adjustace pomoc Holmovy metody. Vbr se d vodnm dialogem.
V kombinaci s Holmovou metodou nelze skript pout pro tabulky se zapnutou funkc
Split file - Compare groups.

Holmova sekvenn metoda testuje nejvt reziduu (v absolutn hodnot) na poadovan
hladin dleno potem vech rezidu. Nelze-li zamtnout nulovou hypotzu (tj. reziduum
je men ne pslun kritick hodnota), pak nelze zamtnout nulovou hypotzu ani
u ostatnch rezidu. Zamtne-li se nulov hypotza u nejvtho rezidua, postupuje se
k druhmu nejvtmu reziduu, kter se testuje na poadovan hladin dleno poet vech
rezidu - 1. Dle se postupuje analogicky prvnmu kroku. V ppad shody rezidu se
tato testuj na nejmen hladin pslun tmto rezidum. Tato metoda je popsan nap.
v knize ehk, ehkov (1986): Analza kategorizovanch dat v sociologii. 
"""
__author__  = 'Eliska Kalinova  ekalinova@acrea.cz'
__version__ = '8.0'
__date__ = '28.7.2011'

from tkinter import *
import sys
import SpssClient
from math import sqrt

class Dialog:
   """ Trida pro zobrazeni uvodniho dialogu. """
   def start(self):
      ### Parametry okna
      windowWidth=270
      windowHeight=180
      bgColor='#f0f0f0'     
      ### Parametry objekt
      ###### Ohranien
      masterRelief=GROOVE
      framewidth=200     
      ###### Fonty
      titleFont = "Arial 14 bold"
      titleFontColor='#23238E'
      frameFont = "Arial 10 bold"
      frameFontColor='#cc0000' 
      objectFont = "Arial 8"
      objectFontColor='#000000'
      ###### Odsazen
      outerPadX=10
      outerPadY=10
      innerPadX=10
      innerPadY=10
      ###### Barvy
      masterColor='#f0f0f0'
      subColor='#f0f0f0'        
      
      ### Okno vodnho dialogu
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( windowWidth, windowHeight, (w-windowWidth)/2, (h-windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit ) #funkce pi zaven kkem     
      ### Rm titulku
      fTitle = LabelFrame(self.okno)
      fTitle.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      info= Label(fTitle , text=u'Znamnkov schma', bg=subColor, font = titleFont ,fg=titleFontColor)
      info.pack(side=LEFT)
      fTitle.pack(anchor=NW, expand=1, fill=X, padx=outerPadX, pady=0)
      ### Rm OptionButton
      self.Holm = IntVar()
      self.Holm.set(0)
      fOptionButton = LabelFrame(self.okno,text=u'Pout Holmovu metodu')
      fOptionButton.config(relief=masterRelief,padx=innerPadX,pady=innerPadY,bg=subColor,font=frameFont,fg=frameFontColor,width=framewidth)
      OptionButton1=Radiobutton(fOptionButton, text=u'ne', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.Holm, value=0)
      OptionButton1.select()
      OptionButton1.pack(anchor=W)
      OptionButton2=Radiobutton(fOptionButton, text=u'ano', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.Holm, value=1)
      OptionButton2.pack(anchor=W)      
      fOptionButton.pack(anchor=W, padx=outerPadX, pady=outerPadY)    
      ### Rm NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      fNavButton.pack(anchor = SW, fill=X, expand=1, pady=0, padx=0)   
      ### Tlatka   
      Button(fNavButton, text="OK", command=self.callOkButton, width = 8).pack(side=LEFT, padx=5, pady=5)
      Button(fNavButton, text="Storno", command=self.callCancelButton, width = 8).pack(side=LEFT, padx=5, pady=5)
      ### Copyright
      cop = Label(fNavButton , text= u'Copyright ACREA CR', bg=subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)
      
      self.okno.mainloop()

   ### Funkce tlatka OK vetn naten slovnku
   def callOkButton(self): 
      """ Povoleni pokracovani skriptu. """          
##      self.okno.quit()
      self.okno.destroy() 

   ### Funkce tlatka Cancel          
   def callCancelButton(self):
      """ Zruseni pokracovani skriptu. """
##      self.okno.quit()
      sys.exit()
 
class Warning:
   """ Trida pro zobrazeni chyboveho hlaseni. """   
   # Parametry okna
   windowWidth=270
   windowHeight=90
   bgColor='#f0f0f0'
   # Parametry objekt
   ### fonty
   objectFont = "Arial 8"
   objectFontColor='#000000'
   ### odsazen
   outerPadX=10
   outerPadY=10
   ### barvy
   masterColor='#f0f0f0'
   subColor='#f0f0f0'
   # Text chybovho hlen
   hlaska = u"Nevhodn tabulka."

   def start(self): 
      """ Zobrazeni dialogu s popisem chyby. """
      # Okno s popisem chyby pi natn slovnku
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( self.windowWidth, self.windowHeight, (w-self.windowWidth)/2, (h-self.windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=self.bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit) #funkce pi zaven kkem 
      # Text chybovho hlen
      hlaseni = Label(self.okno, font=self.objectFont, text=self.hlaska) 
      hlaseni.pack(padx=self.outerPadX, pady=self.outerPadY)
      # Rm NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=self.subColor)
      fNavButton.pack(anchor=SW, fill=X, expand=1, pady=0, padx=0)
      # Tlatko OK
      Button(fNavButton, text="OK", command=self.callOkButton, width=8).pack(side=LEFT, padx=5, pady=5)             
      # Copyright
      cop= Label(fNavButton , text= u'Copyright ACREA CR', bg=self.subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)  
                  
      self.okno.mainloop()
      
   # Funkce tlatka OK 
   def callOkButton(self):
      """ Potvrzeni dialogu. """          
      self.okno.quit()           

def vypocet_signifikance_norm(x):
   """ Provadi vypocet signifikance pro standardni normalni rozdeleni. """
   a1 = 0.0705230784
   a2 = 0.0422820123
   a3 = 0.0092705272
   a4 = 0.0001520143
   a5 = 0.0002765672
   a6 = 0.0000430638
   if abs(x) <= 14.14:
      Z = sqrt(2)/2 * abs(x)
   else:
      Z = 10
   return((1+Z*(a1+Z*(a2+Z*(a3+Z*(a4+Z*(a5+Z*(a6)))))))**(-16))*0.5

def SignScheme(objPivotTable):
   """ Prepsani adjustovanych rezidui na znamenkove schema. """
   start = 0
   objPivotTable.SetUpdateScreen(False) 
   # Nalezen podtabulky obsahujc adjustovan rezidua
   objSpssLabels = objPivotTable.RowLabelArray()
   i = 0
   while i < objSpssLabels.GetNumRows():
      if objSpssLabels.GetValueAt(i,1) == "Adjusted Residual":
         start = i # Index, od kterho zan podtabulka s adjustovanmi rezidui
         objSpssLabels.SetValueAt(i,1,"Sign Scheme") 
         i = objSpssLabels.GetNumRows()  
      else:
         i = i + 1     

   if Holm == 0:  # Bez adjustace.
      # Prchod podtabulkou obsahujc adjustovan rezidua
      znamenka = []
      objDataCells = objPivotTable.DataCellArray()
      objPivotTable.ClearSelection()
      for i in range(start,objDataCells.GetNumRows()):
         for j in range(objDataCells.GetNumColumns()):
            try:
               s = objDataCells.GetUnformattedValueAt(i,j)
               z = float(s)  # Konverze stringu na floating point
               if abs(z) < 1.96:
                  objDataCells.SetValueAt(i,j,"o")
                  znamenka.append("o")
               elif abs(z) < 2.58:
                  if z > 0:
                     objDataCells.SetValueAt(i,j,"+")
                     znamenka.append("+")
                  else:
                     objDataCells.SetValueAt(i,j,"-")
                     znamenka.append("-")
               elif abs(z) < 3.29:
                  if z > 0:
                     objDataCells.SetValueAt(i,j,"++")
                     znamenka.append("++")
                  else:
                     objDataCells.SetValueAt(i,j,"--")
                     znamenka.append("--")      
               else: 
                  if z > 0:
                     objDataCells.SetValueAt(i,j,"+++")
                     znamenka.append("+++")
                  else:
                     objDataCells.SetValueAt(i,j,"---")
                     znamenka.append("---")
            except:
               pass
      # Zvren formtovn 
      for i in range(start,objDataCells.GetNumRows()):
         for j in range(objDataCells.GetNumColumns()):
            try:
               z = objDataCells.GetValueAt(i,j)
               objDataCells.SetTextSizeAt(i,j,11)
               objDataCells.SetTextStyleAt(i,j,SpssClient.SpssTextStyleTypes.SpssTSBold)
               objDataCells.SetHAlignAt(i,j,SpssClient.SpssHAlignTypes.SpssHAlCenter)            
               if z == "+" or z == "++" or z == "+++":
                  objDataCells.SetTextColorAt(i,j,255)
               if z == "-" or z == "--" or z == "---":
                  objDataCells.SetTextColorAt(i,j,32768)             
            except:
               pass   
   else:
      # Naten rezidu a aplikace Holmovy sekvenn metody.
      rezidua = []   # Tento list bude obsahovat absolutn hodnotu rezidua, reziduum, pvodn poad rezidua v tabulce, signifikanci, hladinu testu, znamnko, barvu znamnka.
      objDataCells = objPivotTable.DataCellArray()
      objPivotTable.ClearSelection()
      for i in range(start,objDataCells.GetNumRows()):
         for j in range(objDataCells.GetNumColumns()):
            try:
               z = float(objDataCells.GetUnformattedValueAt(i,j))
               rezidua.append([abs(z),z,len(rezidua)])
            except:
               pass
      rezidua.sort(reverse=True) # Seazen sestupn dle absolutn hodnoty rezidua, co je ekvivalentn vzestupnho azen dle signifikanc.
      jmenovatel = []
      jmenovatel.append(len(rezidua))
      for i in range(1,len(rezidua)):
         if rezidua[i][0] == rezidua[i-1][0]:
            jmenovatel.append(jmenovatel[i-1])
         else:   
            jmenovatel.append(len(rezidua)-i)
      ### Porovnn s hladinou 0.05.
      i = 0
      while i < len(rezidua):
         rezidua[i].append(2*vypocet_signifikance_norm(rezidua[i][0]))
         if rezidua[i][-1] >= 0.05/jmenovatel[i]:
            rezidua[i].append(0.05/jmenovatel[i])
            rezidua[i].append("o")
            rezidua[i].append(0)
            for j in range(i+1,len(rezidua)):
               rezidua[j].append(2*vypocet_signifikance_norm(rezidua[j][0]))
               rezidua[j].append(0.05/jmenovatel[j])
               rezidua[j].append("o")
               rezidua[j].append(0)
            i = len(rezidua)
         else:
            i += 1
      ### Porovnn s hladinou 0.01.
      i = 0
      while i < len(rezidua):               
         if rezidua[i][3] >= (0.01/jmenovatel[i]) and rezidua[i][3] < (0.05/jmenovatel[i]):
            j = i
            while j < len(rezidua):
               rezidua[j].append(0.01/jmenovatel[j])
               if rezidua[j][1] > 0:
                  rezidua[j].append("+")
                  rezidua[j].append(255)            
               else:
                  rezidua[j].append("-")
                  rezidua[j].append(32768)
               j = j+1
               if j < len(rezidua) and rezidua[j][3] >= (0.05/jmenovatel[j]):
                  j = len(rezidua)
            i = len(rezidua)                  
         else:
            i += 1
      ### Porovnn s hladinou 0.001.            
      i = 0
      while i < len(rezidua):               
         if rezidua[i][3] >= (0.001/jmenovatel[i]) and rezidua[i][3] < (0.01/jmenovatel[i]):
            j = i
            while j < len(rezidua):
               rezidua[j].append(0.001/jmenovatel[j])
               if rezidua[j][1] > 0:                  
                  rezidua[j].append("++")
                  rezidua[j].append(255)            
               else:
                  rezidua[j].append("--")
                  rezidua[j].append(32768)
               j = j+1
               if j < len(rezidua) and rezidua[j][3] >= (0.01/jmenovatel[j]):
                  j = len(rezidua)
            i = len(rezidua)
         else:
            i += 1
      ### Zbytek po porovnn s hladinou 0.001.
      i = 0
      while i < len(rezidua):               
         if rezidua[i][3] < (0.001/jmenovatel[i]):
            rezidua[i].append(0.001/jmenovatel[i])                             
            if rezidua[i][1] > 0:
               rezidua[i].append("+++")
               rezidua[i].append(255)            
            else:
               rezidua[i].append("---")
               rezidua[i].append(32768)
            i = i+1
         else:
            i = len(rezidua)                           
      rezidua.sort(key=lambda x:x[2]) # Nvrat k pvodnmu azen.
      # Pedn znamnek do tabulky.
      k = 0
      for i in range(start,objDataCells.GetNumRows()):
         for j in range(objDataCells.GetNumColumns()):
            if objDataCells.GetValueAt(i,j) != "":
               objDataCells.SetValueAt(i,j,rezidua[k][-2])      
               objDataCells.SetTextSizeAt(i,j,11)
               objDataCells.SetTextStyleAt(i,j,SpssClient.SpssTextStyleTypes.SpssTSBold)
               objDataCells.SetHAlignAt(i,j,SpssClient.SpssHAlignTypes.SpssHAlCenter)
               objDataCells.SetTextColorAt(i,j,rezidua[k][-1])
               k = k + 1
               
   #objPivotTable.SetCaptionText("Znamnkov schma bylo vytvoeno pomoc Holmovy sekvenn metody.")      
   objPivotTable.SetUpdateScreen(True)           
         
def pivote(objPivotTable):
   """ Pivotace tabulky. """
   # Pivotace tabulky - statistiky do nejvy rovn v dcch     
   objPivotManager = objPivotTable.PivotManager()
   for i in range(objPivotManager.GetNumRowDimensions()):
      objRowDim = objPivotManager.GetRowDimension(i)
      if objRowDim.GetDimensionName() == "Statistics":
         objRowDim.MoveToRow(objPivotManager.GetNumRowDimensions())
         objRowDim.HideLabel()
         break            

def test(objPivotTable):
   """ Test pritomnosti adjustovanych rezidui a zapnuti funkce Split file. """
   found = 0 # Indiktor, zda tabulka obsahuje adjustovan rezidua: 0 = ne, 1 = ano.
   split = 0 # Indiktor, zda nen zapnuta funkce Split file - Compare groups: 0 = ne, 1 = ano.
   objPivotTable.SetUpdateScreen(False)  
   # Nalezen podtabulky obsahujc adjustovan rezidua:
   # ve vrstvch         
   objPivotManager = objPivotTable.PivotManager()
   if objPivotManager.GetNumLayerDimensions() > 0:
      objLayerDim = objPivotManager.GetLayerDimension(0)
      objRowLabels = objPivotTable.RowLabelArray()
      if objRowLabels.GetNumColumns() > 3:
         split = 1
      if objLayerDim.GetCategoryValueAt(0) == "Adjusted Residual" and (split == 0 or Holm == 0):
         objLayerLabels = objPivotTable.LayerLabelArray()
         objLayerLabels.SetValueAt(0,0,"Sign Scheme")
         found = 1  # Nalezana adjustovan rezidua
         start = 0  # Adjustovan rezidua zanaj na indexu 0
   # v dcch
   else:
      objSpssLabels = objPivotTable.RowLabelArray()
      for i in range(objSpssLabels.GetNumRows()):
         for j in range(objSpssLabels.GetNumColumns()):
            if objSpssLabels.GetValueAt(i,j) == "Adjusted Residual":
               found = 1  # Nalezana adjustovan rezidua
               pivote(objPivotTable)
               break   
      if objSpssLabels.GetNumColumns() > 5:
         split = 1
   if split == 1 and Holm == 1:
      objPivotTable.SetUpdateScreen(True)
      chyba_tabulka = Warning()
      chyba_tabulka.windowWidth = 260
      chyba_tabulka.windowHeight = 95
      chyba_tabulka.hlaska = u"Nelze zpracovat tabulku vytvoenou s pouitm \nfunkce Split file - Compare groups." 
      chyba_tabulka.start()
   else:
      if found == 1:
         objPivotTable.SetUpdateScreen(True) 
         SignScheme(objPivotTable)
      else:
         objPivotTable.SetUpdateScreen(True)
         chyba_tabulka = Warning()
         chyba_tabulka.windowWidth = 230
         chyba_tabulka.windowHeight = 80
         chyba_tabulka.hlaska = u"Tabulka neobsahuje adjustovan rezidua." 
         chyba_tabulka.start()       

try:
   uvod = Dialog()
   uvod.start()
   Holm = uvod.Holm.get()

   SpssClient.StartClient()
   pocet = 0

   # Naten vstupovho okna a jeho obsahu
   objOutputDoc = SpssClient.GetDesignatedOutputDoc()
   objOutputItems = objOutputDoc.GetOutputItems()

   # Nalezen oznaen kontingenn tabulky
   for index in range(objOutputItems.Size()):
      objOutputItem = objOutputItems.GetItemAt(index)
      if objOutputItem.IsSelected() \
         and objOutputItem.GetSubType() == "Crosstabulation" :
            objOutputItem.SetVisible(False)
            objPivotTable = objOutputItem.GetSpecificType()
            pocet = pocet + 1
            test(objPivotTable)
            objPivotTable.Autofit()
            objOutputItem.SetVisible(True)

   if pocet == 0:
      chyba_tabulka = Warning()
      chyba_tabulka.windowWidth = 210
      chyba_tabulka.windowHeight = 80
      chyba_tabulka.hlaska = u"Nebyla vybrna kontingenn tabulka." 
      chyba_tabulka.start()
except:
   pass
finally:
   SpssClient.StopClient()
