# -*- coding: iso8859-2 -*-

"""
POPIS SKRIPTU: skript vypot z rezidu adjustovan rezidua a na zklad nich zobraz znamnkov shma, 
tj. vechna adjustovan rezidua z,  
kde  abs(z) >= 3.29 nahrad +++ resp. ---
kde  abs(z) >= 2.58 nahrad ++ resp. --
kde  abs(z) >= 1.96 nahrad + resp. -
PEDPOKLADY POUIT: ped sputnm skriptu je nutn vybrat tabulku s rezidui, 
kter je soust testu dobr shody (vstup procedury Chi-Square), na kterou se m skript spustit.
"""
__author__  = 'Lubomira Cervova  lcervova@acrea.cz'
__version__ = '1.0'
__date__ = '11.4.2008'

import SpssClient
import sys
from tkinter import *

# Pprava chybovho hlen
class Warning:
   def __init__(self, okno):
      # Parametry objekt

      # fonty
      objectFont = "Arial 8"
      objectFontColor='#000000'

      # odsazen
      outerPadX=10
      outerPadY=10

      #barvy
      masterColor='#f0f0f0'
      subColor='#f0f0f0'

      hlaseni = Label(okno, font=objectFont, text=u"Nebyla vybrna vhodn pivotn tabulka.\nVyberte tabulku z procedury Chi-Square obsahujc rezidua.")     
      hlaseni.pack(padx=outerPadX, pady=outerPadY)

      #Rm NavButton
      fNavButton = LabelFrame(okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      fNavButton.pack(anchor = SW, fill=X, expand=1, pady=0, padx=0)

      def callOkButton():
          SpssClient.StopClient()
          okno.quit()
          exit()
    
      Button(fNavButton, text="OK", command=callOkButton, width = 8).pack(side=LEFT, padx=5, pady=5)

      cop= Label(fNavButton , text= u'Copyright ACREA CR', bg=subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT) 

try:
   SpssClient.StartClient()

   # Piazen aktivnho vstupovho okna a jeho obsahu
   objOutputDoc = SpssClient.GetDesignatedOutputDoc()
   objOutputItems = objOutputDoc.GetOutputItems()

   # Pomocn promnn - indiktor zda byla vybrna vhodn pivotn tabulka
   selected = 0

   # Nalezen oznaen pivotn tabulky
   for index in range(objOutputItems.Size()):
      objOutputItem = objOutputItems.GetItemAt(index)
      if objOutputItem.GetType() == SpssClient.OutputItemType.PIVOT \
         and objOutputItem.IsCurrentItem() \
            and objOutputItem.GetProcedureName() == "NPar Tests" \
               and objOutputItem.GetSubType() == "Chi Square Frequencies": 
                     objPivotTable = objOutputItem.GetSpecificType()
                     selected = 1
                     break

   # Pokud je nalezena oznaen pivotn tabulka z procedury Chi-Square 
   if selected == 1:
      # Vypnut okamitho provdn zmn
      objPivotTable.SetUpdateScreen(False)

      # Piazen objekt pivotn tabulky
      objDataCells = objPivotTable.DataCellArray()
      objColLabels = objPivotTable.ColumnLabelArray()
      objRowLabels = objPivotTable.RowLabelArray()

      # Poet dk tabulky
      lngNumRows = objDataCells.GetNumRows()
      lngNumColums = objDataCells.GetNumColumns()

      # Posun o index v ppad, e bylo zadno rozmz kategori a tud m tabulka o 1 sloupec vc   
      index = 0
      if lngNumColums == 4:
         index = 1

      # Pejmenuje popis sloupce
      if objColLabels.GetValueAt(2*index + 1,index + 2)== "Residual": 
         objColLabels.SetValueAt(2*index + 1,index + 2,"Sign Scheme")
      else:
         # Zobrazen dialogovho okna 
         # parametry okna
         windowWidth=310
         windowHeight=90
         bgColor='#f0f0f0'
     
         okno = Tk()
         w=okno.winfo_screenwidth()
         h=okno.winfo_screenheight()
         okno.geometry("%dx%d+%d+%d" % ( windowWidth, windowHeight, (w-windowWidth)/2, (h-windowHeight)/2 ) ) #okno uprosted obrazovky
         okno.title('ACREA CR')
         okno.config(bg=bgColor)
         okno.resizable(0,0)
         okno.protocol('WM_DELETE_WINDOW', sys.exit ) #funkce pi zaven kkem
         Warning(okno)
         okno.mainloop()   
         sys.exit()   

      # Celkov poet platnch pozorovn N
      Format = objDataCells.GetNumericFormatAt(lngNumRows - 1,index + 0)
      objDataCells.SetNumericFormatAt(lngNumRows - 1,index + 0,"#.#")
      N = float(objDataCells.GetUnformattedValueAt(lngNumRows - 1,index + 0))
      objDataCells.SetNumericFormatAt(lngNumRows - 1,index + 0,Format)
     
      # Pomocn promnn pro barven (pole nejprve sam nuly)
      a=[0]*(lngNumRows-1)

      # Cyklus pro jednotliv buky: vpoet testov statistiky Z, zpis znamnka
      for i in range(0,lngNumRows - 1):
         # Vpoet adjustovanch rezidu
         #numDecimals_1 = objDataCells.GetHDecDigitsAt(i,index + 1)  # kopruje poty desetinnch mst a formty (pro pozdj vrcen)
         #numDecimals_2 = objDataCells.GetHDecDigitsAt(i,index + 2)
         #Format_1 = objDataCells.GetNumericFormatAt(i,index + 1)
         #Format_2 = objDataCells.GetNumericFormatAt(i,index + 2)
         #objDataCells.SetNumericFormatAt(i,index + 1,"#.#")    # upravuje formt v buce pro funkci float
         #objDataCells.SetNumericFormatAt(i,index + 2,"#.#")
         #objDataCells.SetHDecDigitsAt(i,index + 1,16)	# upravuje poty desetinnch mst v bukch tak, aby pi natn nedolo k zaokrouhlen, pozdji se vrac zpt
         #objDataCells.SetHDecDigitsAt(i,index + 2,16) 

         # Pozn.: Pi nkterch typech nastaven zstvaj jako oddlovae rky, pomoc funkce replace v takovm ppad pevdm na teky
         R = float(objDataCells.GetUnformattedValueAt(i,index + 2))		# itatel
         O = (float(objDataCells.GetUnformattedValueAt(i,index + 1))*(1-float(objDataCells.GetUnformattedValueAt(i,index + 1))/N))**(0.5)	# jmenovatel
         Z =R/O   # adjustovan reziduum
       
         #objDataCells.SetNumericFormatAt(i,index + 1,Format_1)      # vrac zpt formty (nelze vrtit zkoprovnm pvodnch)
         #objDataCells.SetNumericFormatAt(i,index + 2,Format_2)
         #objDataCells.SetHDecDigitsAt(i,index + 1,numDecimals_1)	   # vrac zpt desetinn msta
         #objDataCells.SetHDecDigitsAt(i,index + 2,numDecimals_2)
              
         # Zape do buky znamnko
         if (Z <= -3.2905267314918945):
            objDataCells.SetValueAt(i,index + 2,"---")
         if ((Z > -3.2905267314918945) and (Z <= -2.5758293035489004)):
            objDataCells.SetValueAt(i,index + 2,"--")
         if ((Z > -2.5758293035489004) and (Z <= -1.959963984540054)):
            objDataCells.SetValueAt(i,index + 2,"-")
         if ((Z > -1.959963984540054) and (Z < 1.959963984540054)):
            objDataCells.SetValueAt(i,index + 2,"o")
         if ((Z >= 1.959963984540054) and (Z < 2.5758293035489004)):
            objDataCells.SetValueAt(i,index + 2,"+")
         if ((Z >= 2.5758293035489004) and (Z < 3.2905267314918945)):
            objDataCells.SetValueAt(i,index + 2,"++")
         if (Z >= 3.2905267314918945):
            objDataCells.SetValueAt(i,index + 2,"+++")

         # Vpoet pomocn promnn pro barven
         if (Z <= -1.959963984540054):
            a[i]=-1
         if (Z >= 1.959963984540054):
            a[i]=1

      # Zvren formtovn 
      for i in range(0,lngNumRows - 1):
         objDataCells.SetTextSizeAt(i,index+2,11)
         objDataCells.SetTextStyleAt(i,index+2,SpssClient.SpssTextStyleTypes.SpssTSBold)
         objDataCells.SetHAlignAt(i,index+2,SpssClient.SpssHAlignTypes.SpssHAlCenter)            
         if a[i] == 1:
            objDataCells.SetTextColorAt(i,index+2,255)
         if a[i] == -1:
            objDataCells.SetTextColorAt(i,index+2,32768)             
                    
      # Zapnut okamitho provdn zmen
      objPivotTable.Autofit()
      objPivotTable.SetUpdateScreen(True)

   else:
      # Zobrazen dialogovho okna 
      # parametry okna
      windowWidth=310
      windowHeight=90
      bgColor='#f0f0f0'
     
      okno = Tk()
      w=okno.winfo_screenwidth()
      h=okno.winfo_screenheight()
      okno.geometry("%dx%d+%d+%d" % ( windowWidth, windowHeight, (w-windowWidth)/2, (h-windowHeight)/2 ) ) #okno uprosted obrazovky
      okno.title('ACREA CR')
      okno.config(bg=bgColor)
      okno.resizable(0,0)
      okno.protocol('WM_DELETE_WINDOW', sys.exit ) #funkce pi zaven kkem
      Warning(okno)
      okno.mainloop()
except:
   pass
finally:
   SpssClient.StopClient()
  
