# -*- coding: cp1250 -*-

"""****************************************************************************
*                                PAIRED T TEST                                *
*******************************************************************************
* Skript zpracuje tabulku "Paired Samples Test" podle uzivatelovych voleb     *
* v dialogu. Spusteni skriptu: Utilities\Run Script....                       *
****************************************************************************"""

__author__  = u"Jindrich Muller jmuller@spss.cz"
__version__ = u"1.5"
__date__    = u"25.9.2009"

try:
   from tkinter import *
   import sys
   import SpssClient
   import tkinter.messagebox as tkMessageBox

###############################################################################

##   def fncU2F(fsVal):
##      """*******************************************************************
##      * Osetrena transformace unicode -> float.                            *
##      *******************************************************************"""
##      try:
##         fsVal = fsVal.replace(",",".")
##         return ( (True,float(fsVal)) )
##      except:
##         return ( (False,-9999) )

###############################################################################

   class clsTable:
      """***************************************************************
      * Trida jako kontejner dat SPSS-tabulky.                         *
      ***************************************************************"""
      def __init__(self):
         pass

   class clsDialog:
      """*******************************************************************
      * Trida definujici hlavni dialog.                                    *
      *******************************************************************"""
      def __init__(self):
         """**************************************************************
         * Inicializace dialogu.                                         *
         **************************************************************"""
#        Barvy, fonty
         self.msTitleFont = "Arial 14 bold"
         self.msTitleFontColor="#23238E"   
         self.msFrameFont = "Arial 9 bold" 
         self.msBGEntry = "#ffffff"        
         self.msDlgBGColor = "#f0f0f0"
         self.msFrmFGColor = "#cc0000"
#        Nastaveni zakladniho okna
         self.wndDialog = Tk()                       
         self.wndDialog.config(width=330, height=560)
         self.wndDialog.attributes("-topmost",True)  
         self.wndDialog.geometry("+%d+%d" % ((self.wndDialog.winfo_screenwidth()-330)/2,(self.wndDialog.winfo_screenheight()-560)/2))
         self.wndDialog.title(u"ACREA CR")
         self.wndDialog.option_add("*Font", "Arial 9")
         self.wndDialog.config(bg=self.msDlgBGColor, padx=5, pady=5)
         self.wndDialog.resizable(width=False, height=False)
         self.wndDialog.protocol("WM_DELETE_WINDOW", sys.exit)
#        Tk-promenne
         self.tkiRbtVyberTab = IntVar()      
         self.tkiRbtSetridit = IntVar()      
         self.tkiRbtDleSig = IntVar()        
         self.tkiRbtDleRoz = IntVar()        
         self.tkbChbZnamSchema = BooleanVar()
         self.tkbChbKorKoef = BooleanVar()   
         self.tkbChbPrelozit = BooleanVar()  
         self.tkbChbObarvit = BooleanVar()   
         self.tkbChbNotace = BooleanVar()    
#        Datove atributy dialogu
         self.miPrBarWidthMax = 300 # Maximalni sirka ProgressBaru
#        Konstrukce a spusteni dialogu
         self.mtdRunDlg()

      def mtdRunDlg(self):
         """**************************************************************
         * Metoda konstrukce graficke casti dialogu                      *
         **************************************************************"""
#        Nadpis dialogu
         self.frmNadpis = Frame(self.wndDialog,
                                bg=self.msDlgBGColor)
         self.frmNadpis.pack(fill=BOTH, expand=True)
         if ( True ):
            lblNadpis = Label(self.frmNadpis,
                              text="Prov T-test", font=self.msTitleFont, fg=self.msTitleFontColor,
                              bg=self.msDlgBGColor)
            lblNadpis.pack(side=LEFT)
         self.frmNadpisVycp = Frame(self.wndDialog,
                                    height=6, bg=self.msDlgBGColor)
         self.frmNadpisVycp.pack()
#        Ram dialogove casti
         self.frmDialog = Frame(self.wndDialog,
                                bg=self.msDlgBGColor)
         self.frmDialog.pack(fill=BOTH, expand=True)
         if ( True ):
#           Vyber tabulek
            self.lbfVyberTab = LabelFrame(self.frmDialog,
                                          text=u" Vbr tabulek ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                          font=self.msFrameFont, padx=5, pady=5)
            self.lbfVyberTab.pack(fill=BOTH, expand=True)
            if ( True ):
               self.tkiRbtVyberTab.set(1)
#              Oznacene tabulky Paired Samples Test
               self.rbtOznaceneTab = Radiobutton(self.lbfVyberTab,
                                                 text=u'Oznaen tabulky "Paired Samples Test"', variable=self.tkiRbtVyberTab,
                                                 value=1, bg=self.msDlgBGColor)
               self.rbtOznaceneTab.pack(anchor=N+W)
#              Vsechny tabulky Paired Samples Test ve vystupovem okne
               self.rbtVsechnyTab = Radiobutton(self.lbfVyberTab,
                                                text=u'Vechny tabulky "Paired Samples Test" ve vstupu', variable=self.tkiRbtVyberTab,
                                                value=2, bg=self.msDlgBGColor)
               self.rbtVsechnyTab.pack(anchor=N+W)
#           Zobrazit
            self.lbfZobrazit = LabelFrame(self.frmDialog,
                                          text=u" Zobrazit ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                          font=self.msFrameFont, padx=5, pady=5)
            self.lbfZobrazit.pack(fill=BOTH, expand=True)
            if ( True ):
               self.tkbChbZnamSchema.set(True)
#              Znamenkove schema
               self.chbZnamSchema = Checkbutton(self.lbfZobrazit,
                                                text=u"Znamnkov schma", variable=self.tkbChbZnamSchema,
                                                onvalue=True, offvalue=False, bg=self.msDlgBGColor)
               self.chbZnamSchema.pack(anchor=N+W)
               self.tkbChbKorKoef.set(False)
#              Korelacni koeficient
               self.chbKorKoef = Checkbutton(self.lbfZobrazit,
                                             text=u"Korelan koeficient*", variable=self.tkbChbKorKoef,
                                             onvalue=True, offvalue=False, bg=self.msDlgBGColor)
               self.chbKorKoef.pack(anchor=N+W)
#              Vycpavka
               self.frmKorKoefPoznVycp = Frame(self.lbfZobrazit,
                                                  width=15, bg=self.msDlgBGColor)
               self.frmKorKoefPoznVycp.pack(side=LEFT)
#              Poznamka
               self.msgKorKoefPozn = Message(self.lbfZobrazit,
                                             text=u'*Tato volba pedpokld ve vstupovm okn ped tabulkou "Paired Samples Test" tabulku "Paired Samples Correlations"',
                                             width=300, bg=self.msDlgBGColor)
               self.msgKorKoefPozn.pack(side=LEFT)
#           Setridit
            self.lbfSetridit = LabelFrame(self.frmDialog,
                                          text=u" Setdit ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                          font=self.msFrameFont, padx=5, pady=5)
            self.lbfSetridit.pack(fill=BOTH, expand=True)
            if ( True ):
#              Ram pro "Dle signifikance"
               self.frmDleSig = Frame(self.lbfSetridit,
                                      bg=self.msDlgBGColor)
               self.frmDleSig.pack(side=LEFT, fill=BOTH, expand=True)
               if ( True ):
                  self.tkiRbtSetridit.set(1)
#                 Dle signifikance
                  self.rbtDleSig = Radiobutton(self.frmDleSig,
                                               text=u"Dle signifikance", variable=self.tkiRbtSetridit,
                                               value=1, bg=self.msDlgBGColor, command=self.mtdDleSigAkt)
                  self.rbtDleSig.pack(anchor=N+W)
#                 Vycpavka
                  self.frmDleSigVycp = Frame(self.frmDleSig,
                                             width=20, bg=self.msDlgBGColor)
                  self.frmDleSigVycp.pack(side=LEFT)
#                 Ram pro radiobuttony "vzestupne" a "sestupne"
                  self.frmDleSigVzestSest = Frame(self.frmDleSig,
                                                  bg=self.msDlgBGColor)
                  self.frmDleSigVzestSest.pack(side=LEFT)
                  self.tkiRbtDleSig.set(1)
                  if ( True ):
#                    vzestupne (dle signifikance )
                     self.rbtDleSigVzest = Radiobutton(self.frmDleSigVzestSest,
                                                       text=u"vzestupn", variable=self.tkiRbtDleSig,
                                                       value=1, bg=self.msDlgBGColor)
                     self.rbtDleSigVzest.pack(anchor=N+W)
#                    sestupne (dle signifikance )
                     self.rbtDleSigSest = Radiobutton(self.frmDleSigVzestSest,
                                                       text=u"sestupn", variable=self.tkiRbtDleSig,
                                                       value=2, bg=self.msDlgBGColor)
                     self.rbtDleSigSest.pack(anchor=N+W)
#              Ram pro "Dle rozdilu prumeru"
               self.frmDleRoz = Frame(self.lbfSetridit,
                                      bg=self.msDlgBGColor)
               self.frmDleRoz.pack(side=LEFT, fill=BOTH, expand=True)
               if ( True ):
#                 Dle rozdilu prumeru
                  self.rbtDleRoz = Radiobutton(self.frmDleRoz,
                                               text=u"Dle prmru rozdl", variable=self.tkiRbtSetridit,
                                               value=2, bg=self.msDlgBGColor, command=self.mtdDleRozAkt)
                  self.rbtDleRoz.pack(anchor=N+W)
#                 Vycpavka
                  self.frmDleRozVycp = Frame(self.frmDleRoz,
                                             width=20, bg=self.msDlgBGColor)
                  self.frmDleRozVycp.pack(side=LEFT)
#                 Ram pro radiobuttony "vzestupne" a "sestupne"
                  self.frmDleRozVzestSest = Frame(self.frmDleRoz,
                                                  bg=self.msDlgBGColor)
                  self.frmDleRozVzestSest.pack(side=LEFT)
                  self.tkiRbtDleRoz.set(1)
                  if ( True ):
#                    vzestupne (dle signifikance )
                     self.rbtDleRozVzest = Radiobutton(self.frmDleRozVzestSest,
                                                       text=u"vzestupn", variable=self.tkiRbtDleRoz, value=1,
                                                       state="disable", bg=self.msDlgBGColor)
                     self.rbtDleRozVzest.pack(anchor=N+W)
#                    sestupne (dle signifikance )
                     self.rbtDleRozSest = Radiobutton(self.frmDleRozVzestSest,
                                                       text=u"sestupn", variable=self.tkiRbtDleRoz, value=2,
                                                       state="disable", bg=self.msDlgBGColor)
                     self.rbtDleRozSest.pack(anchor=N+W)
#           Moznosti
            self.lbfMoznosti = LabelFrame(self.frmDialog,
                                          text=u" Monosti ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                          font=self.msFrameFont, padx=5, pady=5)
            self.lbfMoznosti.pack(fill=BOTH, expand=True)
            if ( True ):
               self.tkbChbPrelozit.set(True)
#              Prelozit nazvy v tabulce
               self.chbPrelozit = Checkbutton(self.lbfMoznosti,
                                              text=u"Peloit nzvy v tabulce", variable=self.tkbChbPrelozit,
                                              onvalue=True, offvalue=False, bg=self.msDlgBGColor)
               self.chbPrelozit.pack(anchor=N+W)
               self.tkbChbObarvit.set(True)
#              Obarvit dle dosazene hladiny testu
               self.chbObarvit = Checkbutton(self.lbfMoznosti,
                                             text=u"Obarvit dle dosaen hladiny testu", variable=self.tkbChbObarvit,
                                             onvalue=True, offvalue=False, bg=self.msDlgBGColor)
               self.chbObarvit.pack(anchor=N+W)
               self.tkbChbNotace.set(False)
#              Obarvit dle dosazene hladiny testu
               self.chbNotace = Checkbutton(self.lbfMoznosti,
                                            text=u"Nepouvat vdeckou notaci sel", variable=self.tkbChbNotace,
                                            onvalue=True, offvalue=False, bg=self.msDlgBGColor)
               self.chbNotace.pack(anchor=N+W)
#        ProgressBar
         self.lbfProgressBar = LabelFrame(self.wndDialog,
                                          text=u" Progrese ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                          font=self.msFrameFont, padx=5, pady=5)
         self.lbfProgressBar.pack(fill=BOTH, expand=True)
         if ( True ):
#           Obal ProgressBaru
            self.frmPrBarKraj = Frame(self.lbfProgressBar,
                                      bg=self.msDlgBGColor, width=300, height=10, bd=2, relief=RIDGE)
            self.frmPrBarKraj.pack(fill=X, expand=True)
            if ( True ):
#              ProgressBar
               self.frmProgressBar = Frame(self.frmPrBarKraj,
                                           bg=self.msFrmFGColor, height=6, relief=FLAT)
               self.frmProgressBar.pack(side=LEFT)
#        Ram tlacitek
         self.frmButtons = Frame(self.wndDialog,
                                 bg=self.msDlgBGColor)
         self.frmButtons.pack(fill=BOTH, expand=True)
         if ( True ):
#           Tlacitko OK
            self.btnOK = Button(self.frmButtons,
                                text=u"OK", width=8, command=self.mtdOK, padx=0, pady=0)
            self.btnOK.pack(side=LEFT, padx=5, pady=5)
#           Tlacitko Storno
            self.btnStorno = Button(self.frmButtons,
                                    text=u"Storno", width=8, command=self.mtdStorno, padx=0, pady=0)
            self.btnStorno.pack(side=LEFT, padx=5, pady=5)
#           Copyright
            self.lblCopyright = Label(self.frmButtons,
                                      text=u'Copyright ACREA CR', bg=self.msDlgBGColor, font="Arial 8 italic",
                                      fg='#000000')
            self.lblCopyright.pack(side=RIGHT)
#        Spusteni dialogu
         self.wndDialog.mainloop()

      def mtdOK(self):
         """**************************************************************
         * Metoda tlacitka OK.                                           *
         **************************************************************"""
#        Znepristupneni dialogu
         self.mtdFreezeDlg()
#        Vykonani dialogu
         self.mtdExecute()

      def mtdStorno(self):
         """**************************************************************
         * Metoda tlacitka Storno. Ukonceni dialogu.                     *
         **************************************************************"""
         self.mtdDlgTermination()

      def mtdFreezeDlg(self):
         """**************************************************************
         * Metoda znepristupni ovladaci prvky dialogu.                   *
         **************************************************************"""
         self.rbtOznaceneTab.config(state="disable")
         self.rbtVsechnyTab.config(state="disable")
         self.chbZnamSchema.config(state="disable")
         self.chbKorKoef.config(state="disable")
         self.msgKorKoefPozn.config(fg="#808080")
         self.rbtDleSig.config(state="disable")
         self.rbtDleSigVzest.config(state="disable")
         self.rbtDleSigSest.config(state="disable")
         self.rbtDleRoz.config(state="disable")
         self.rbtDleRozVzest.config(state="disable")
         self.rbtDleRozSest.config(state="disable")
         self.chbPrelozit.config(state="disable")
         self.chbObarvit.config(state="disable")
         self.chbNotace.config(state="disable")
         self.btnOK.config(state="disable")
         self.btnStorno.config(state="disable")
         self.wndDialog.update()

      def mtdDlgTermination(self):
         """**************************************************************
         * Metoda ukonci dialog.                                         *
         **************************************************************"""
         try:
            SpssClient.StopClient()
         except:
            pass
         self.wndDialog.quit()
         self.wndDialog.destroy()

      def mtdDleSigAkt(self):
         """**************************************************************
         * Metoda aktivace RadioButtonu "Dle signifikance".              *
         **************************************************************"""
         self.rbtDleSigVzest.config(state="normal")
         self.rbtDleSigSest.config(state="normal")
         self.rbtDleRozVzest.config(state="disable")
         self.rbtDleRozSest.config(state="disable")

      def mtdDleRozAkt(self):
         """**************************************************************
         * Metoda aktivace RadioButtonu "Dle signifikance".              *
         **************************************************************"""
         self.rbtDleSigVzest.config(state="disable")
         self.rbtDleSigSest.config(state="disable")
         self.rbtDleRozVzest.config(state="normal")
         self.rbtDleRozSest.config(state="normal")

      def mtdProgress(self,fiIterator,fnDenom):
         """**************************************************************
         * Metoda ridici delku ProgressBaru.                             *
         **************************************************************"""
         self.frmProgressBar.config(width=int(round(self.miPrBarWidthMax*fiIterator/fnDenom)))
         self.frmProgressBar.update()

      def mtdReadAndSort(self,fiIndx):
         """**************************************************************
         * Metoda nacte data z pivotni tabulky a setridi je podle        *
         * volby uzivatele v dialogu.                                    *
         **************************************************************"""
#        Pomocne promenne
         moTab.mlCells = []                                    # Seznam hodnot bunek tabulky
         flRow = []                                            # Seznam hodnot bunek v danem radku
         moTab.mlColLab = []                                   # Seznam nazvu sloupcu
         moTab.moDataCells = self.moPivotTable.DataCellArray() # Objekt reprezentujici bunky tabulky
         moTab.mnNumRows = moTab.moDataCells.GetNumRows()      # Pocet radku tabulky
         moTab.mnNumCols = moTab.moDataCells.GetNumColumns()   # Pocet sloupcu tabulky
#        Zakladni kontrola a nacteni dat
         if ( moTab.mnNumCols != 9 ):
            self.mtdShowError()
            return ( False )
         else:
#           Nacitani Sig., Mean, SEMean, Lower, Upper
            for i in range(moTab.mnNumRows):
#              Nacitani Sig., Mean, resp. Mean, Sig.
               if ( self.tkiRbtSetridit.get() == 1 ):
#                 Zda setridit dle signifikance
                  fxVal = moTab.moDataCells.GetUnformattedValueAt(i,8)
                  fxVal = float(fxVal)
##                  fxVal = fncU2F(fxVal)
##                  if ( fxVal[0] ):
##                  flRow.append(fxVal[1])                    # Signifikance
                  flRow.append(fxVal)                    # Signifikance
##                  else:
##                     self.mtdShowError()
##                     return ( False )
                  fxVal = moTab.moDataCells.GetUnformattedValueAt(i,0)
                  fxVal = float(fxVal)
##                  fxVal = fncU2F(fxVal)
##                  if ( fxVal[0] ):
##                     flRow.append(fxVal[1])                    # Mean
                  flRow.append(fxVal)                    # Mean
##                  else:
##                     self.mtdShowError()
##                     return ( False )
               else:
#                 Zda setridit dle rozdilu prumeru
                  fxVal = moTab.moDataCells.GetUnformattedValueAt(i,0)
                  fxVal = float(fxVal)
##                  fxVal = fncU2F(fxVal)
##                  if ( fxVal[0] ):
##                     flRow.append(fxVal[1])                    # Mean
                  flRow.append(fxVal)                    # Mean
##                  else:
##                     self.mtdShowError()
##                     return ( False )
                  fxVal = moTab.moDataCells.GetUnformattedValueAt(i,8)
                  fxVal = float(fxVal)
##                  fxVal = fncU2F(fxVal)
##                  if ( fxVal[0] ):
##                     flRow.append(fxVal[1])                    # Signifikance
                  flRow.append(fxVal)                    # Signifikance
##                  else:
##                     self.mtdShowError()
##                     return ( False )
#              Nacitani SEMean, Lower, Upper
               for j in range(2,5):
                  fxVal = moTab.moDataCells.GetValueAt(i,j)
                  flRow.append(fxVal)                          # SEMean, Lower, Upper
#              Pridani celeho radku do seznamu hodnot bunek pro Sig., Mean, SEMean, Lower, Upper
               moTab.mlCells.append(flRow)
               flRow = []
#           Nacteni korelacnich koeficientu z tabulky "Paired Samples Correlations"
            if ( self.tkbChbKorKoef.get() ):
               ftKK = self.mtdKorKoef(fiIndx)
               if ( ftKK[0] ):
#                 Nacitani korelacnich koeficientu a jejich sig.
                  for i in range(moTab.mnNumRows):
                     moTab.mlCells[i].append(ftKK[1][i])       # Korelacni koeficient
                     moTab.mlCells[i].append(ftKK[2][i])       # Signifikance korelacniho koeficientu
               else:
                  tkMessageBox.showerror(u"Chyba",u'Ve vstupu je tabulka "Paired Samples Correlations", kter nen v defaultnm formtu. Skript neme provst poadovan zobrazen korelanho koeficientu a pesko aktuln zpracovvanou tabulku "Paired Samples Test".')
                  return ( False )
            else:
               for i in range(moTab.mnNumRows):
                  moTab.mlCells[i].append(-9999)               # Pomocne hodnoty
                  moTab.mlCells[i].append(-9999)               # Pomocne hodnoty
#           Pripojeni znamenkoveho schematu
            if ( self.tkbChbZnamSchema.get() or self.tkbChbObarvit.get() ):
               if ( self.tkiRbtSetridit.get() == 1 ):
                  for i in range(moTab.mnNumRows):
#                    Pripojeni retezce znamenkoveho schematu na zaklade hodnoty Sig. a Mean

                     self.mtTypZnam = self.mtdZnamSchema(moTab.mlCells[i][0],moTab.mlCells[i][1])
                     moTab.mlCells[i].append(self.mtTypZnam[0])
                     moTab.mlCells[i].append(self.mtTypZnam[1])
               else:
                  for i in range(moTab.mnNumRows):
#                    Pripojeni retezce znamenkoveho schematu na zaklade hodnoty Sig. a Mean
                     self.mtTypZnam = self.mtdZnamSchema(moTab.mlCells[i][1],moTab.mlCells[i][0])
                     moTab.mlCells[i].append(self.mtTypZnam[0])
                     moTab.mlCells[i].append(self.mtTypZnam[1])
            else:
               for i in range(moTab.mnNumRows):
                  moTab.mlCells[i].append(-9999)               # Pomocne hodnoty
                  moTab.mlCells[i].append(-9999)               # Pomocne hodnoty
#           Popisky radku na zaklade vyberu prekladu
            foRowLabs = self.moPivotTable.RowLabelArray()
            if ( self.tkbChbPrelozit.get() ):
               for i in range(moTab.mnNumRows):
#                 Prelozeny popisek radku
                  moTab.mlCells[i].append(u"Pr . "+str(i+1))
                  moTab.mlCells[i].append(foRowLabs.GetValueAt(i,2)) 
            else:
               for i in range(moTab.mnNumRows):
#                 Prelozeny popisek radku
                  moTab.mlCells[i].append(u"Pair "+str(i+1))
                  moTab.mlCells[i].append(foRowLabs.GetValueAt(i,2)) 
###           Setrideni
##            if ( self.tkiRbtSetridit.get() == 1 ):
###              Setridit dle signifikance
##               if ( self.tkiRbtDleSig.get() == 1 ):
###                 Vzestupne
##                  moTab.mlCells.sort(reverse=False)
##               else:
###                 Sestupne
##                  moTab.mlCells.sort(reverse=True)
##            else:
###              Setridit dle prumeru rozdilu
##               if ( self.tkiRbtDleRoz.get() == 1 ):
###                 Vzestupne
##                  moTab.mlCells.sort(reverse=False)
##               else:
###                 Sestupne
##                  moTab.mlCells.sort(reverse=True)
#           Pripadne prehozeni signifikance do prvniho sloupce
            if ( self.tkiRbtSetridit.get() == 2 ):
               for i in range(moTab.mnNumRows):
                  fnHelp = moTab.mlCells[i][0]
                  moTab.mlCells[i][0] = moTab.mlCells[i][1]
                  moTab.mlCells[i][1] = fnHelp
###           Prevod formatu cisla na unicode s desetinnou carkou
##            for i in range(moTab.mnNumRows):
##               moTab.mlCells[i][0] = unicode(moTab.mlCells[i][0]).replace(".",",")
##               moTab.mlCells[i][1] = unicode(moTab.mlCells[i][1]).replace(".",",")
         return ( True )

      def mtdShowError(self):
         """**************************************************************
         * Metoda zobrazi chybove hlaseni.                               *
         **************************************************************"""
         tkMessageBox.showerror(u"Chyba",u"Ve vstupu je tabulka, kter nen v defaultnm formtu. Skript ji nezpracuje.")

      def mtdZnamSchema(self,fnSig,fnMean):
         """**************************************************************
         * Metoda pro znamenkove schema.                                 *
         **************************************************************"""
         if ( fnSig > 0.05 ):
            return ( ("o",0) )
         elif ( 0.01 < fnSig <= 0.05 ):
            if ( fnMean > 0 ):
               return ( ("+",1) )
            else:
               return ( ("-",-1) )
         elif ( 0.001 < fnSig <= 0.01 ):
            if ( fnMean > 0 ):
               return ( ("++",2) )
            else:
               return ( ("--",-2) )
         else:
            if ( fnMean > 0 ):
               return ( ("+++",3) )
            else:
               return ( ("---",-3) )

      def mtdKorKoef(self,fiIndx):
         """**************************************************************
         * Metoda validace zobrazeni korelacniho koeficientu.            *
         **************************************************************"""
         try:
            foOutputItem = self.moOutputItems.GetItemAt(fiIndx-1)
            if ( foOutputItem.GetSubType() == "Paired Samples Correlations" ):
#              Zisk pivotni tabulky
               foPivotTable = foOutputItem.GetSpecificType()
#              Nacteni korelacnich koeficientu a jejich Sig.
               foDataCells = foPivotTable.DataCellArray()
               fnNumRows = foDataCells.GetNumRows()
               fnNumCols = foDataCells.GetNumColumns()
               if ( (fnNumRows!=moTab.mnNumRows) or (fnNumCols!=4) ):
                  return ( (False,[-9999],[-9999]) )
               else:
                  flKK = []
                  flSig = []
                  for i in range(fnNumRows):
                     fsKK = foDataCells.GetUnformattedValueAt(i,1)
                     fsSig = foDataCells.GetUnformattedValueAt(i,3)
                     flKK.append(fsKK)
                     flSig.append(fsSig)
                  return ( (True,flKK,flSig) )
            else:
               return ( (False,[-9999],[-9999]) )
         except:
            return ( (False,[-9999],[-9999]) )

      def mtdFillTable(self):
         """**************************************************************
         * Metoda vyplni aktualne zpracovavanou tabulku.                 *
         **************************************************************"""
#        Potrebne objekty
         foRowLabs = self.moPivotTable.RowLabelArray()            # Objekt popisku radku
         foColLabs = self.moPivotTable.ColumnLabelArray()         # Objekt popisku sloupcu   
#        Zruseni popisu Paired Differences 
##         self.moPivotTable.ClearSelection()
##         for j in range(5):
##            foColLabs.SelectLabelAt(1,j)
##         self.moPivotTable.Ungroup()        
###        Zruseni popisu xx% Confidence Interval of the Difference
##         spolehlivost = foColLabs.GetValueAt(2,3)[0:2]
##         self.moPivotTable.ClearSelection()
##         for j in range(3,5):
##            foColLabs.SelectLabelAt(1,j)
##         self.moPivotTable.Ungroup()         
###        Presunuti sloupce Sig. (2-tailed) na zacatek tabulky
##         self.moPivotTable.ClearSelection()
##         foColLabs.SelectLabelAt(3,7)
##         foColLabs.InsertBefore(3,0)
#        Presunuti sloupcu Mean a Sig. (2-tailed)
         for i in range(moTab.mnNumRows):
            moTab.moDataCells.SetValueAt(i,1,moTab.moDataCells.GetUnformattedValueAt(i,0))
            moTab.moDataCells.SetValueAt(i,0,moTab.moDataCells.GetUnformattedValueAt(i,8))
##            moTab.moDataCells.SetValueAt(i,1,str(float(moTab.moDataCells.GetUnformattedValueAt(i,0))))
##            moTab.moDataCells.SetValueAt(i,0,str(float(moTab.moDataCells.GetUnformattedValueAt(i,7))))
###        Presunuti sloupce Std. Deviation 
##         self.moPivotTable.ClearSelection()
##         foColLabs.SelectLabelAt(1,2)
##         foColLabs.InsertBefore(1,6)
#        Vkladani korelacnich koeficientu a jejich sig. do tabulky
         if ( self.tkbChbKorKoef.get() ):
            for i in range(moTab.mnNumRows):
               moTab.moDataCells.SetValueAt(i,5,moTab.mlCells[i][5])
               moTab.moDataCells.SetValueAt(i,6,moTab.mlCells[i][6])
#        Vkladani znamenkoveho schematu do tabulky a nastaveni jeho formatu
         if ( self.tkbChbZnamSchema.get() ):
            for i in range(moTab.mnNumRows):
               moTab.moDataCells.SetValueAt(i,7,moTab.mlCells[i][7])
               moTab.moDataCells.SetTextSizeAt(i,7,11)
               moTab.moDataCells.SetTextStyleAt(i,7,SpssClient.SpssTextStyleTypes.SpssTSBold)
               moTab.moDataCells.SetHAlignAt(i,7,SpssClient.SpssHAlignTypes.SpssHAlCenter)
               if ( moTab.mlCells[i][8] > 0 ):
                  moTab.moDataCells.SetTextColorAt(i,7,255)
               elif ( moTab.mlCells[i][8] < 0 ):
                  moTab.moDataCells.SetTextColorAt(i,7,32768)
#        Popisky sloupcu
         if ( self.tkbChbPrelozit.get() ):
##            foColLabs.SetValueAt(2,0,u"Sig. (oboustr.)")
##            foColLabs.SetValueAt(2,1,u"Prmr rozdl")
##            foColLabs.SetValueAt(2,2,u"Stand. chyba prmru rozdl")
##            foColLabs.SetValueAt(2,3,u"Doln mez")
##            foColLabs.SetValueAt(2,4,u"Horn mez")
            foColLabs.SetValueAt(3,0,u"Sig. (oboustr.)")
            foColLabs.SetValueAt(3,1,u"Prmr rozdl")
            foColLabs.SetValueAt(3,2,u"Stand. chyba prmru rozdl")
            foColLabs.SetValueAt(3,3,u"Doln mez")
            foColLabs.SetValueAt(3,4,u"Horn mez")            
            if ( self.tkbChbKorKoef.get() ):
##               foColLabs.SetValueAt(2,5,u"Korelan koeficient")
##               foColLabs.SetValueAt(2,6,u"Sig. korelanho koeficientu")
               foColLabs.SetValueAt(3,5,u"Korelan koeficient")
               foColLabs.SetValueAt(3,6,u"Sig. korelanho koeficientu")
            if ( self.tkbChbZnamSchema.get() ):
##               foColLabs.SetValueAt(2,7,u"Znamnkov schma")
               foColLabs.SetValueAt(3,7,u"Znamnkov schma")
         else:
            if ( self.tkbChbKorKoef.get() ):
##               foColLabs.SetValueAt(2,0,u"Sigs. (2-tailed)")
##               foColLabs.SetValueAt(2,1,u"Mean")
##               foColLabs.SetValueAt(2,5,u"Correlation Coefficient")
##               foColLabs.SetValueAt(2,6,u"Sig. of Corr. Coeff.")
               foColLabs.SetValueAt(3,0,u"Sigs. (2-tailed)")
               foColLabs.SetValueAt(3,1,u"Mean")
               foColLabs.SetValueAt(3,5,u"Correlation Coefficient")
               foColLabs.SetValueAt(3,6,u"Sig. of Corr. Coeff.")               
            if ( self.tkbChbZnamSchema.get() ):
##               foColLabs.SetValueAt(2,7,u"Sign Scheme")
               foColLabs.SetValueAt(3,7,u"Sign Scheme")
###          Pridani noveho popisku   
##         self.moPivotTable.ClearSelection()
##         for j in range(3,5):
##            foColLabs.SelectLabelAt(1,j)
##         self.moPivotTable.Group()                  
#        Popisky radku
         if ( self.tkbChbPrelozit.get() ):
            for i in range(moTab.mnNumRows):
               foRowLabs.SetValueAt(i,1,moTab.mlCells[i][9])
               foRowLabs.SetValueAt(i,2,moTab.mlCells[i][10])
#        Nadpis tabulky a zbytek z oblasti popisku sloupcu
##         spolehlivost = foColLabs.GetValueAt(1,3)[0:2]
         spolehlivost = foColLabs.GetValueAt(2,3)[0:2]
         if ( self.tkbChbPrelozit.get() ):
            self.moPivotTable.SetTitleText(u"Prov T-test shody stednch hodnot pro zvisl vbry")
            foColLabs.SetValueAt(1,0,u"Prov rozdly")
##            foColLabs.SetValueAt(1,3,spolehlivost+u"% interval spolehlivosti prmru rozdl")
            foColLabs.SetValueAt(2,3,spolehlivost+u"% interval spolehlivosti prmru rozdl")
         else:
##            foColLabs.SetValueAt(1,3,spolehlivost+u"% Confidence Interval of the Difference")            
            foColLabs.SetValueAt(2,3,spolehlivost+u"% Confidence Interval of the Difference") 
#        Nastaveni formatu cisel v tabulce
         if ( self.tkbChbNotace.get() ):
            for i in range(moTab.mnNumRows):
               for j in range(moTab.mnNumCols):                              
                  moTab.moDataCells.SetNumericFormatAtWithDecimal(i,j,u"#.#",3)
         else:
            if ( self.tkbChbKorKoef.get() ):
               for i in range(moTab.mnNumRows):
                  moTab.moDataCells.SetNumericFormatAtWithDecimal(i,5,u"#.#",3)
                  moTab.moDataCells.SetNumericFormatAtWithDecimal(i,6,u"#.#",3)                  
#        Obarveni tabulky
         if ( self.tkbChbObarvit.get() ):
            for i in range(moTab.mnNumRows):
               if ( abs(moTab.mlCells[i][8])==1 ):
                  for j in range(moTab.mnNumCols):
                     fiColor = int(round(128+255*256+128*256*256))
                     moTab.moDataCells.SetBackgroundColorAt(i,j,fiColor)
               elif ( abs(moTab.mlCells[i][8])==2 ):
                  for j in range(moTab.mnNumCols):
                     fiColor = int(round(255+255*256+128*256*256))
                     moTab.moDataCells.SetBackgroundColorAt(i,j,fiColor)
               elif ( abs(moTab.mlCells[i][8])==3 ):
                  for j in range(moTab.mnNumCols):
                     fiColor = int(round(255+196*256+196*256*256))
                     moTab.moDataCells.SetBackgroundColorAt(i,j,fiColor)
#        Pripadne schovani nepotrebnych sloupcu
         self.moPivotTable.Autofit()
##         self.moPivotTable.SetUpdateScreen(True)
         self.moOutputItem = self.moOutputItems.GetItemAt(self.indx)
         self.moPivotTable = self.moOutputItem.GetSpecificType()
         foColLabs = self.moPivotTable.ColumnLabelArray()
         foColLabs.HideLabelsWithDataAt(3,8)
         if ( not(self.tkbChbKorKoef.get()) ):
##            foColLabs.HideLabelsWithDataAt(2,5)
##            foColLabs.HideLabelsWithDataAt(2,6)
            foColLabs.HideLabelsWithDataAt(3,5)
            foColLabs.HideLabelsWithDataAt(3,6)
         if ( not(self.tkbChbZnamSchema.get()) ): 
##            foColLabs.HideLabelsWithDataAt(2,7)
            foColLabs.HideLabelsWithDataAt(3,7)
#        Setrideni radku
         foRowLabs = self.moPivotTable.RowLabelArray()
         foDataCells = self.moPivotTable.DataCellArray()
         if ( self.tkiRbtSetridit.get() == 1 ):
#           Setridit dle signifikance
            indSloupce = 0
         else:
#           Setridit dle prumeru rozdilu
            indSloupce = 1
         if ( ( self.tkiRbtSetridit.get() == 1 and self.tkiRbtDleSig.get() == 1 ) or ( self.tkiRbtSetridit.get() == 2 and self.tkiRbtDleRoz.get() == 1) ):
#           Vzestupne
            for i in range(moTab.mnNumRows):
               minimum = [float(foDataCells.GetUnformattedValueAt(i,indSloupce)),i]
               for j in range(i,moTab.mnNumRows):
                  if float(foDataCells.GetUnformattedValueAt(j,indSloupce)) < minimum[0]:
                     minimum = [float(foDataCells.GetUnformattedValueAt(j,indSloupce)),j]             
               if minimum[1] > i:
                  self.moPivotTable.ClearSelection()
                  foRowLabs.SelectLabelAt(minimum[1],1)
                  foRowLabs.InsertBefore(i,1)      
         else:
#           Sestupne
            for i in range(moTab.mnNumRows):
               maximum = [float(foDataCells.GetUnformattedValueAt(i,indSloupce)),i]
               for j in range(i,moTab.mnNumRows):
                  if float(foDataCells.GetUnformattedValueAt(j,indSloupce)) > maximum[0]:
                     maximum = [float(foDataCells.GetUnformattedValueAt(j,indSloupce)),j]
               if maximum[1] > i:      
                  self.moPivotTable.ClearSelection()
                  foRowLabs.SelectLabelAt(maximum[1],1)
                  foRowLabs.InsertBefore(i,1)
###        Zruseni popisu Paired Differences 
         self.moPivotTable.ClearSelection()
         for j in range(5):
            foColLabs.SelectLabelAt(1,j)
         self.moPivotTable.Ungroup()
###        Zruseni popisu Significance a skryti posledniho sloupce
         self.moPivotTable.ClearSelection()
         for j in range(7,9):
            foColLabs.SelectLabelAt(1,j)
         self.moPivotTable.Ungroup()
         
      def mtdExecute(self):
         """**************************************************************
         * Metoda spusti vlastni vykonavani skriptu.                     *
         **************************************************************"""
#        Napojeni na SpssClient
         SpssClient.StartClient()
         self.moOutputDoc = SpssClient.GetDesignatedOutputDoc()   # Vystup
         self.moOutputItems = self.moOutputDoc.GetOutputItems()   # Seznam polozek
         self.mnNumOutputItems = self.moOutputItems.Size()        # Pocet polozek
#        Pruchod vystupem po polozkach a kontrola
         for self.indx in range(self.mnNumOutputItems):
            self.moOutputItem = self.moOutputItems.GetItemAt(self.indx)
            if ( self.moOutputItem.GetSubType() == "Paired Samples Test" ):
               fiCont = self.tkiRbtVyberTab.get()
#              Overeni pripustnosti aktualne zpracovavane tabulky
               if ( (fiCont==2) or (fiCont==1 and self.moOutputItem.IsSelected()) ):
#                 Zisk tabulky a vypnuti okamziteho projevu zmen v tabulce
                  self.moPivotTable = self.moOutputItem.GetSpecificType()
                  self.moOutputItem.SetVisible(False)
                  self.moPivotTable.SetUpdateScreen(False)
#                 Nacteni, setrideni a vyplneni tabulky
                  if ( self.mtdReadAndSort(self.indx) ):
                     self.mtdFillTable()
#                 Zapnuti projevu zmen v tabulce
                  self.moPivotTable.SetUpdateScreen(True)
                  self.moOutputItem.SetVisible(True)
#           Update ProgressBaru
            self.mtdProgress(self.indx+1,self.mnNumOutputItems)
#        Ukonceni dialogu
         self.mtdDlgTermination()
###############################################################################

#  Spusteni dialogu
   moTab = clsTable()
   moDialog = clsDialog()

###############################################################################
   
except:
   tkMessageBox.showerror(u"Chyba",u"Dolo k neznm chyb. Skript bude ukonen.")
   try:
      SpssClient.StopClient()
      self.wndDialog.quit()
      self.wndDialog.destroy()
   except:
      pass
finally:
   SpssClient.StopClient()

###############################################################################
