# -*- coding: cp1250 -*-

"""*******************************************************************************
*                             TABLE COLOR SCRIPT                                 *
**********************************************************************************
* Skript podbarv oznaenou pivotn tabulku ve vstupovm okn IBM SPSS Statistics.
* Intenzita barvy vdy linern roste/kles v zvislosti na obarvovanch hodnotch.
*
* Sputn skriptu:
* - nejprve je nutn oznait pslunou tabulku ve vstupu, 
* - sputn ve verzi 24: Utilities\Run Script...
*
* Funkce a monosti nastaven skriptu:
* rozsahu obarvovan oblasti: (dky, sloupce)
* kritrium barven:
*     - dle hodnot v tabulce (na zklad minima a maxima dan oblasti tabulky)
*     - korelace (minimum=-1, mez=0, maximum=1)
*     - procenta (minimum=0%, mez=50%, maximum=100%)
*     - vlastn rozsah (z dat se nat minimum, maximum a dopot se mez jako
*       sted mezi minimem a maximem, lze vak run upravit)
* oblast tabulky: (cel tabulka/ kad dek samostatn/ kad sloupec samostatn)
*     - je k dispozici pouze pro kritrium barven dle hodnot v tabulce
* barevn kla:
*     - automaticky: od minima do dan meze se linern sniuje intenzita
*       modr barvy od RGB=(90,90,255) a do bl,
*       od dan meze do maxima linern roste intenzita erven barvy od bl
*       a do RGB=(255,90,90)
*     - vlastn kla: stejn jako pedchzejc, barvy odpovdajc minimu
*       a maximu lze nastavit uivatelem
*     - pouze jedna barva: intenzita barvy linern roste od minima (bl barva)
*       a do maxima (RGB=(255,90,90) nebo zadan barva
* diagonla:
*     - pro tvercov tabulky (napklad korelan matice) lze vynechat diagonlu
*       i nebarvit hodnoty nad diagonlou
* absolutn hodnoty:
*     - barven probh na zklad absolutn hodnoty sel v tabulce
* przdn pole:
*     - przdn pole lze povaovat za nuly (napklad kombinace dk a sloupc
*       v kontingenn tabulce, kter se v datech nevyskytuj)
*
* Poznmky:
* - Pokud je pro kritrium "korelace" oznaeno pouit absolutnch hodnot,
*   je k dispozici jako barevn kla pouze jedna barva.
* - Volba povaovat przdn pole za nuly nen k dispozici pro korelace.
* - Pi barven signifikanc je doporuen volba barevn kly "pouze jedna barva".
*******************************************************************************"""

__author__  = "Jindrich Muller, aktualizovala Lubomra ervov"
__version__ = "2.5"
__date__    = "29.8.2017"

if ( True ):
   import SpssClient
   from tkinter import *
   import sys
   import tkinter.colorchooser as tkColorChooser
   import tkinter.messagebox as tkMessageBox
   import colorsys
##################################################################################
   def fncRGB2HLS(msRGB):
      """*******************************************************************
      * Osetrena transformace RGB-kodu barvy do HLS-kodu.                  *
      *******************************************************************"""
      mlRGB = mlHLS = [0,0,0]
      try:
         msRGB = msRGB.split("#")[1]
         mlRGB[0]= float(int(msRGB[0:2],16))/255
         mlRGB[1]= float(int(msRGB[2:4],16))/255
         mlRGB[2]= float(int(msRGB[4:6],16))/255
         mlHLS = list(colorsys.rgb_to_hls(mlRGB[0],mlRGB[1],mlRGB[2]))
         return ( mlHLS )
      except:
         pass

   def fncHLS2SPSS(mlHLS):
      """*******************************************************************
      * Osetrena transformace HLS-kodu barvy do SPSS-kodu barvy.           *
      *******************************************************************"""
      try:
         mlRGB = list(colorsys.hls_to_rgb(mlHLS[0],mlHLS[1],mlHLS[2]))
         mnSPSSColor = int(round(mlRGB[0]*255) + round(mlRGB[1]*255)*256 + round(mlRGB[2]*255)*256*256)
         return ( mnSPSSColor )
      except:
         pass

   def fncU2F(msVal,i,j):
      """*******************************************************************
      * Osetrena transformace unicode -> float.                            *
      *******************************************************************"""
      try:
         # Nsledujc transformace ji nejsou teba, oeteno jinde pkazem GetUnformattedValueAt(i,j)
         # msVal = msVal.replace(",",".")       
         # msVal = msVal.replace("*","") 
         # msVal = msVal.replace("%","") 
         # msVal = msVal.replace(" ","") 
         return ( (float(msVal),True) )
      except:
         return ( (-9999,False) )

   def fncParComp(flTabSort):
      """*********************************************************************************
      * Vypocet pomocnych promennych obarvovaciho modelu pro barven dle hodnot v tabulce.                  *
      ************************************************************************************"""
#     Minimalni (alfa) a maximalni (omega) hodnota dane casti tabulky
      alfa =  flTabSort[0]
      omega = flTabSort[-1]
#     Sted mezi alfa a omega
      E = alfa + (omega-alfa)/2
      return ( (alfa,omega,E) )

   def fncSetBgColor(fnVal,i,j,Ex,K,R,S):
      """*******************************************************************
      * Obarveni bunky (i,j) podle hodnoty v ni obsazene (osetreno).       *
      *******************************************************************"""
      if ( fnVal < Ex ):
         moDataTab.mlHLSColorMin[1] = ( K[0]*fnVal + R[0] )/240.0
         fiSpssColor = fncHLS2SPSS(moDataTab.mlHLSColorMin)
         try:
            moDataTab.moDataCells.SetBackgroundColorAt(i,j,fiSpssColor)
         except:
            tkMessageBox.showerror(u"Chyba",u"Nelze obarvit pole tabulky na pozici ("+unicode(i+1)+","+unicode(j+1)+")")
      else:
         moDataTab.mlHLSColorMax[1] = ( K[1]*fnVal + R[1] )/240.0
         fiSpssColor = fncHLS2SPSS(moDataTab.mlHLSColorMax)
         try:
            moDataTab.moDataCells.SetBackgroundColorAt(i,j,fiSpssColor)
         except:
            tkMessageBox.showerror(u"Chyba",u"Nelze obarvit pole tabulky na pozici ("+unicode(i+1)+","+unicode(j+1)+")")

            
###############################################################################
   class clsDataTab:
      """***************************************************************
      * Trida jako kontejner dat SPSS-tabulky.                         *
      ***************************************************************"""
      def __init__(self):
         self.mlTab = []              # Seznam seznamu reprezentujici SPSS-tabulku
         self.mbTab = []              # Tabulka logickych hodnot (prazdna bunka = False)
         self.mlRow = []              # Seznam reprezentujici aktualne projizdeny radek SPSS-tabulky
         self.mbRow = []              # Radek logickych hodnot (prazdna bunka = False)
         self.mlTabSort = []          # Pomocny seznam setridenych hodnot tabulky podle velikosti

   class clsDialog:
      """*****************************************************************
      * Trida definujici grafickou a funkcni cast hlavniho dialogu.      *
      *****************************************************************"""
      def __init__(self):
         """**************************************************************
         * Inicializace a spusteni dialogu.                              *
         **************************************************************"""
#        Nastaveni zakladniho okna
         self.dlgDialog = Tk()
         self.dlgDialog.attributes("-topmost",True)
         self.dlgDialog.geometry("+%d+%d" % ((self.dlgDialog.winfo_screenwidth()-321)/2,(self.dlgDialog.winfo_screenheight()-545)/2))
         self.dlgDialog.title(u"ACREA CR")
         self.dlgDialog.option_add("*Font", "Arial 9")
         self.dlgDialog.config(bg="#f0f0f0", padx=10, pady=10)
         self.dlgDialog.resizable(width=False, height=False)
         self.dlgDialog.protocol("WM_DELETE_WINDOW", sys.exit)
#        Tk-promenne
         self.tksVlastniRozsahMax = StringVar()
         self.tksVlastniRozsahMin = StringVar()
         self.tksVlastniRozsahMez = StringVar()         
         self.tkiRbtKriterium = IntVar()       
         self.tkiRbtOblast = IntVar()          
         self.tkiRbtBarvy = IntVar()           
         self.tkbChbAbsHod = BooleanVar()
         self.tkbChbPrazdnaPole = BooleanVar()
         self.tkbChbSuperDiag = BooleanVar()   
         self.tkbChbJumpDiag = BooleanVar()    
#        Atributy
         self.msTitleFont = "Arial 14 bold"
         self.msTitleFontColor="#23238E"   
         self.msFrameFont = "Arial 9 bold" 
         self.msBGEntry = "#ffffff"        
         self.msDlgBGColor = "#f0f0f0"     
         self.msFrmFGColor = "#cc0000"     
         self.mnLightnessMax = 240         
         self.msOneColor = "#ff5a5a"    
         self.msColorMin = "#5a5aff"        
         self.msColorMax = "#ff5a5a"        
         self.miPrBarWidthMax = 293
         self.miIterator = 0
         self.mbKriterium = 0
         self.mbAbsHod = False
         self.mbPrazdnaPole = False
         self.mbJumpDiag = False  
         self.mbSuperDiag = False 
         self.mbRowsEq = False
         self.mbColsEq = False
#        Spusteni dialogu
         self.dlgDialog.after(10,self.mtdScanAndControl)
         self.mtdRunDlg()

      def mtdScanAndControl(self):
         """**************************************************************
         * Metoda rizeni nacteni a kontroly dat z tabulky.               *
         **************************************************************"""
         self.mtdFreezeDlg()
         if ( self.mtdTabScan() ):
            self.mtdSetDlgValues()
            self.mtdDefreezeDlg() 
         else:
            self.mtdDlgTermination()

      def mtdSetDlgValues(self):
         """**************************************************************
         * Metoda prednastavi nactene hodnoty v dialogu.                 *
         **************************************************************"""
#        Hodnoty v dialogu
         self.spnRowsFrom.config(state="normal")
         self.spnRowsFrom.insert(0,str(1))
         self.spnRowsFrom.config(from_=1, to=moDataTab.mnNumRows)
         self.spnRowsTo.config(state="normal")
         self.spnRowsTo.config(from_=1, to=moDataTab.mnNumRows)
         self.spnRowsTo.delete(first=0, last=1)
         self.spnRowsTo.insert(0,str(moDataTab.mnNumRows))
         self.spnColsFrom.config(state="normal")
         self.spnColsFrom.insert(0,str(1))
         self.spnColsFrom.config(from_=1, to=moDataTab.mnNumCols)
         self.spnColsTo.config(state="normal")
         self.spnColsTo.config(from_=1, to=moDataTab.mnNumCols)
         self.spnColsTo.delete(first=0, last=1)
         self.spnColsTo.insert(0,str(moDataTab.mnNumCols))
         self.tksVlastniRozsahMin.set(str(moDataTab.mnValMin))
         self.tksVlastniRozsahMax.set(str(moDataTab.mnValMax))
         self.tksVlastniRozsahMez.set(str((moDataTab.mnValMin+moDataTab.mnValMax)/2))
         self.lbfNacitObarv.config(text=u" Naten probhlo spn ")
         self.lbfNacitObarv.update()

      def mtdTabScan(self):
         """**************************************************************
         * Metoda pocatecniho prozkoumani tabulky.                       *
         **************************************************************"""
         SpssClient.StartClient()
         moOutputDoc = SpssClient.GetDesignatedOutputDoc()
         moOutputItem = moOutputDoc.GetCurrentItem()
#        Je to vubec pivotni tabulka?
         if ( moOutputItem.GetType() == SpssClient.OutputItemType.PIVOT ):
#           Objekt reprezentujici pivotni tabulku
            self.moPivotTable = moOutputItem.GetSpecificType()
            self.moPivotTable.SetUpdateScreen(False)
            moDataTab.moDataCells = self.moPivotTable.DataCellArray()
            moDataTab.mnNumRows = moDataTab.moDataCells.GetNumRows()
            moDataTab.mnNumCols = moDataTab.moDataCells.GetNumColumns()
            self.miValidVals = 0    # Pocet platnych hodnot
            moDataTab.miNumCells = moDataTab.mnNumRows*moDataTab.mnNumCols
            moDataTab.mnValMinPrazdnaPole= -1   # Pomocn hodnota, nepouv se, ale pokud jsou przdn pole, nate se do n potom nula
            for i in range(moDataTab.mnNumRows):
               for j in range(moDataTab.mnNumCols):
                  self.mxVal = moDataTab.moDataCells.GetUnformattedValueAt(i,j)
                  if ( self.mxVal == "" ):
                     moDataTab.mlRow.append(0)
                     moDataTab.mbRow.append(False)
                     moDataTab.mnValMinPrazdnaPole=0
                  else:
                     self.mxVal = fncU2F(self.mxVal,i,j)
                     if ( self.mxVal[1] ):
                        moDataTab.mlRow.append(self.mxVal[0])
                        moDataTab.mlTabSort.append(self.mxVal[0])
                        moDataTab.mbRow.append(True)
                        self.miValidVals += 1
                     else:
                        moDataTab.mlRow.append(-9999)
                        moDataTab.mbRow.append(False)
                  self.miIterator += 1
                  self.mtdProgress(self.miIterator,moDataTab.miNumCells)
               moDataTab.mlTab.append(moDataTab.mlRow)
               moDataTab.mbTab.append(moDataTab.mbRow)
               moDataTab.mlRow = []
               moDataTab.mbRow = []
#           Platna a nekonstantni data v tabulce
            if ( self.miValidVals > 0 ):
               moDataTab.mlTabSort.sort()
               moDataTab.mnValMin = moDataTab.mlTabSort[0]
               moDataTab.mnValMax = moDataTab.mlTabSort[-1]
               if ( moDataTab.mnValMin != moDataTab.mnValMax ):
                  return ( True )
               else:
                  tkMessageBox.showerror(u"Chyba",u"V tabulce jsou konstantn data, nelze ji obarvit.")
                  return ( False )
            else:
               tkMessageBox.showerror(u"Chyba",u"Tabulka neobsahuje dnou platnou hodnotu. Skript bude ukonen.")
               return ( False )
         else:
            tkMessageBox.showerror(u"Chyba",u"Nebyla oznaena pivotn tabulka. Skript bude ukonen.")
            return ( False )

      def mtdRunDlg(self):
         """**************************************************************
         * Metoda konstrukce graficke casti dialogu a spusteni           *
         **************************************************************"""
#        Nadpis dialogu
         self.frmNadpis = Frame(self.dlgDialog,
                                bg=self.msDlgBGColor)
         self.frmNadpis.pack(fill=BOTH, expand=True)
         if ( True ):
            lblNadpis = Label(self.frmNadpis,
                              text="Obarven tabulky (linern)", font=self.msTitleFont, fg=self.msTitleFontColor,
                              bg=self.msDlgBGColor)
            lblNadpis.pack(side=LEFT)
#        Vycpavka
         self.frmNadpisVycp = Frame(self.dlgDialog,
                                    height=6, bg=self.msDlgBGColor)
         self.frmNadpisVycp.pack()
#        Ram dialogove casti
         self.frmDialog = Frame(self.dlgDialog,
                                bg=self.msDlgBGColor)
         self.frmDialog.pack(fill=BOTH, expand=True)
         if ( True ):
#           Rozsah obarvovane oblasti
            self.lbfRozsah = LabelFrame(self.frmDialog,
                                        text=u" Rozsah obarvovan oblasti ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                        font=self.msFrameFont, padx=5, pady=5)
            self.lbfRozsah.pack(fill=BOTH, expand=True)
            if ( True ):
#              Radky
               self.lbfRadky = LabelFrame(self.lbfRozsah,
                                          text=u" dky ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                          padx=5, pady=5)
               self.lbfRadky.grid(row=0, column=0)
               if ( True ):
                  self.lblRowsFrom = Label(self.lbfRadky,
                                          text=u"Od", bg=self.msDlgBGColor)
                  self.lblRowsFrom.grid(row=0, column=0)
                  self.spnRowsFrom = Spinbox(self.lbfRadky,
                                            width=3, bg=self.msDlgBGColor, readonlybackground="#ffffff", state="disable",
                                            disabledbackground=self.msDlgBGColor, command=self.mtdRowsFromCheck)
                  self.spnRowsFrom.grid(row=0, column=1)
                  self.frmRadkyVycp = Frame(self.lbfRadky,
                                            width=10, bg=self.msDlgBGColor)
                  self.frmRadkyVycp.grid(row=0, column=2)
                  self.lblRowsTo = Label(self.lbfRadky,
                                          text=u"Do", bg=self.msDlgBGColor)
                  self.lblRowsTo.grid(row=0, column=3)
                  self.spnRowsTo = Spinbox(self.lbfRadky,
                                            width=3, bg=self.msDlgBGColor, readonlybackground="#ffffff", state="disable",
                                            disabledbackground=self.msDlgBGColor, command=self.mtdRowsToCheck)
                  self.spnRowsTo.grid(row=0, column=4)
#              Vycpavka mezi radky a sloupci
               self.frmRadkySloupceVycp = Frame(self.lbfRozsah,
                                                width=4, bg=self.msDlgBGColor)
               self.frmRadkySloupceVycp.grid(row=0, column=1)
#              Sloupce
               self.lbfSloupce = LabelFrame(self.lbfRozsah,
                                            text=u" Sloupce ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                            padx=5, pady=5)
               self.lbfSloupce.grid(row=0, column=2)
               if ( True ):
                  self.lblColsFrom = Label(self.lbfSloupce,
                                            text=u"Od", bg=self.msDlgBGColor)
                  self.lblColsFrom.grid(row=0, column=0)
                  self.spnColsFrom = Spinbox(self.lbfSloupce,
                                              width=3, bg=self.msDlgBGColor, readonlybackground="#ffffff", state="disable",
                                              disabledbackground=self.msDlgBGColor, command=self.mtdColsFromCheck)
                  self.spnColsFrom.grid(row = 0,column = 1)
                  self.frmSloupceVycp = Frame(self.lbfSloupce,
                                              width=10, bg=self.msDlgBGColor)
                  self.frmSloupceVycp.grid(row=0, column=2)
                  self.lblColsTo = Label(self.lbfSloupce,
                                            text=u"Do", bg=self.msDlgBGColor)
                  self.lblColsTo.grid(row=0, column=3)
                  self.spnColsTo = Spinbox(self.lbfSloupce,
                                              width=3, bg=self.msDlgBGColor, readonlybackground="#ffffff", state="disable",
                                              disabledbackground=self.msDlgBGColor, command=self.mtdColsToCheck)
                  self.spnColsTo.grid(row=0, column=4)

#           Ram pro Kriterium obarveni, Absolutn hodnoty, Oblast tabulky a Barevnou skalu
            self.frmKritOblSkala = Frame(self.frmDialog,
                                         bg=self.msDlgBGColor)
            self.frmKritOblSkala.pack(fill=BOTH, expand=True)
            if ( True ):
               # Kriterium obarveni, Absolutni hodnoty
               self.frmKriteriumAbsHodnoty = Frame(self.frmKritOblSkala, bg=self.msDlgBGColor)
               self.frmKriteriumAbsHodnoty.pack(side=LEFT, fill=BOTH, expand=True)
               if ( True ):
#                 Kriterium obarveni
                  self.lbfKriterium = LabelFrame(self.frmKriteriumAbsHodnoty,
                                                 text=u" Kritrium obarven ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                                 padx=5, pady=5, font=self.msFrameFont)
                  self.lbfKriterium.pack(side=TOP, fill=BOTH, expand=True)
                  if ( True ):
                     self.tkiRbtKriterium.set(1)
                     self.rbtHodnoty = Radiobutton(self.lbfKriterium,
                                                   text=u"Dle hodnot v tabulce", variable=self.tkiRbtKriterium,
                                                   value=1, bg=self.msDlgBGColor, command=self.mtdHodnotyAkt)
                     self.rbtHodnoty.pack(anchor=N+W)
                     self.rbtKorelace = Radiobutton(self.lbfKriterium,
                                                    text=u"Korelace <-1,1>", variable=self.tkiRbtKriterium,
                                                    value=2, bg=self.msDlgBGColor, command=self.mtdKorelaceAkt)
                     self.rbtKorelace.pack(anchor=N+W)                 
                     self.rbtProcenta = Radiobutton(self.lbfKriterium,
                                                    text=u"Procenta <0,100>%", variable=self.tkiRbtKriterium,
                                                    value=3, bg=self.msDlgBGColor, command=self.mtdProcentaAkt)
                     self.rbtProcenta.pack(anchor=N+W)
                     self.rbtVlastniRozsah = Radiobutton(self.lbfKriterium,
                                                         text=u"Vlastn rozsah", variable=self.tkiRbtKriterium,
                                                         value=4, bg=self.msDlgBGColor, command=self.mtdVlastniRozsahAkt)
                     self.rbtVlastniRozsah.pack(anchor=N+W)
                     self.frmVlastniRozsah = Frame(self.lbfKriterium,
                                                   bg=self.msDlgBGColor)
                     self.frmVlastniRozsah.pack(anchor=N+W)
                     if ( True ):
                        self.lblVlastniRozsahVycp = Label(self.frmVlastniRozsah,
                                                          width=2, bg=self.msDlgBGColor)
                        self.lblVlastniRozsahVycp.grid(row=0, column=0)
                        self.lblVlastniRozsahMin = Label(self.frmVlastniRozsah,
                                                         text="min", bg=self.msDlgBGColor)
                        self.lblVlastniRozsahMin.grid(row=0, column=1)
                        self.frmVlastniRozsahVycpJ = Frame(self.frmVlastniRozsah,
                                                           width=2, bg=self.msDlgBGColor)
                        self.frmVlastniRozsahVycpJ.grid(row=0, column=2)
                        self.entVlastniRozsahMin = Entry(self.frmVlastniRozsah,
                                                         width=5, textvariable=self.tksVlastniRozsahMin, bg=self.msBGEntry,
                                                         state="disable", disabledbackground=self.msDlgBGColor)
                        self.entVlastniRozsahMin.grid(row=0, column=3)
                        self.lblVlastniRozsahVycp2 = Label(self.frmVlastniRozsah,
                                                           width=1, font="Arial 1", bg=self.msDlgBGColor)
                        self.lblVlastniRozsahVycp2.grid(row=0, column=4)
                        self.lblVlastniRozsahMax = Label(self.frmVlastniRozsah,
                                                         text="max", bg=self.msDlgBGColor)
                        self.lblVlastniRozsahMax.grid(row=0, column=5)
                        self.entVlastniRozsahMax = Entry(self.frmVlastniRozsah,
                                                         width=5, textvariable=self.tksVlastniRozsahMax, bg=self.msBGEntry,
                                                         state="disable", disabledbackground=self.msDlgBGColor)
                        self.entVlastniRozsahMax.grid(row=0, column=6)
                     self.frmVlastniRozsahMez = Frame(self.lbfKriterium,
                                                      bg=self.msDlgBGColor)
                     self.frmVlastniRozsahMez.pack(anchor=N+W)
                     if ( True ):
                        self.lblVlastniRozsahMezVycp = Label(self.frmVlastniRozsahMez,
                                                             width=2, bg=self.msDlgBGColor)
                        self.lblVlastniRozsahMezVycp.grid(row=0, column=0)
                        self.lblVlastniRozsahMez = Label(self.frmVlastniRozsahMez,
                                                         text="mez", bg=self.msDlgBGColor)
                        self.lblVlastniRozsahMez.grid(row=0, column=1)
                        self.entVlastniRozsahMez = Entry(self.frmVlastniRozsahMez,
                                                         width=5, textvariable=self.tksVlastniRozsahMez, bg=self.msBGEntry,
                                                         state="disable", disabledbackground=self.msDlgBGColor)
                        self.entVlastniRozsahMez.grid(row=0, column=2)
                        
#                 Ram pro absolutni hodnoty
                  self.lbfAbsHod = LabelFrame(self.frmKriteriumAbsHodnoty,
                                              text=u" Absolutn hodnoty ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                              padx=5, pady=5, font=self.msFrameFont)
                  self.lbfAbsHod.pack(side=TOP, fill=BOTH, expand=True)
                  if ( True ):
                     self.tkbChbAbsHod.set(self.mbAbsHod)
                     self.chbAbsHod = Checkbutton(self.lbfAbsHod,
                                                  text=u"Pout absolutn hodnoty", variable=self.tkbChbAbsHod,
                                                  onvalue=True, offvalue=False, bg=self.msDlgBGColor)
                     self.chbAbsHod.bind("<Button-1>", self.mtdAbsHodAkt)
                     self.chbAbsHod.pack(side=LEFT)
                     
#              Oblast tabulky, Barevna skala
               self.frmOblSkala = Frame(self.frmKritOblSkala,
                                        bg=self.msDlgBGColor)
               self.frmOblSkala.pack(side=LEFT, fill=BOTH, expand=True)
               if ( True ):
#                 Oblast tabulky
                  self.lbfOblast = LabelFrame(self.frmOblSkala,
                                              text=u" Oblast tabulky ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                              padx=5, pady=5, font=self.msFrameFont)
                  self.lbfOblast.pack(side=TOP, fill=BOTH, expand=True)
                  if ( True ):
                     self.tkiRbtOblast.set(1)
                     self.rbtCelaOblast = Radiobutton(self.lbfOblast,
                                                       text=u"Cel oblast", variable=self.tkiRbtOblast,
                                                       value=1, bg=self.msDlgBGColor)
                     self.rbtCelaOblast.pack(anchor=N+W)
                     self.rbtRadky = Radiobutton(self.lbfOblast,
                                                 text=u"dky", variable=self.tkiRbtOblast,
                                                 value=2, bg=self.msDlgBGColor)
                     self.rbtRadky.pack(anchor=N+W)
                     self.rbtSloupce = Radiobutton(self.lbfOblast,
                                                   text=u"Sloupce", variable=self.tkiRbtOblast,
                                                   value=3, bg=self.msDlgBGColor)
                     self.rbtSloupce.pack(anchor=N+W)                     
#                 Barevna skala
                  self.lbfBarvy = LabelFrame(self.frmOblSkala,
                                             text=u" Barevn kla ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                             padx=5, pady=5, font=self.msFrameFont)
                  self.lbfBarvy.pack(side=TOP, fill=BOTH, expand=True)
                  if ( True ):
                     self.tkiRbtBarvy.set(1)
                     self.rbtAutomaticky = Radiobutton(self.lbfBarvy,
                                                       text=u"Automaticky", variable=self.tkiRbtBarvy,
                                                       value=1, bg=self.msDlgBGColor,command=self.mtdAutomatickyAkt)
                     self.rbtAutomaticky.pack(anchor=N+W)
                     self.rbtVlastniSkala = Radiobutton(self.lbfBarvy,
                                                        text=u"Vlastn kla", variable=self.tkiRbtBarvy,
                                                        value=2, bg=self.msDlgBGColor,command=self.mtdVlastniSkalaAkt)
                     self.rbtVlastniSkala.pack(anchor=N+W)
                     self.frmVlastniSkala = Frame(self.lbfBarvy,
                                                  bg=self.msDlgBGColor)
                     self.frmVlastniSkala.pack(anchor=N+W)
                     if ( True ):
                        self.lblVlastniSkalaVycp = Label(self.frmVlastniSkala,
                                                         width=2, bg=self.msDlgBGColor)
                        self.lblVlastniSkalaVycp.grid(row=0, column=0)
                        self.lblVlastniSkalaMin = Label(self.frmVlastniSkala,
                                                        text="min", bg=self.msDlgBGColor)
                        self.lblVlastniSkalaMin.grid(row=0, column=1)
                        self.btnVlastniSkalaMin = Button(self.frmVlastniSkala,
                                                         width=2, bd=1, bg=self.msColorMin, font="Arial 6",
                                                         command=self.mtdBarvaMin)
                        self.btnVlastniSkalaMin.grid(row=0, column=2)
                        self.lblVlastniSkalaVycp2 = Label(self.frmVlastniSkala,
                                                          width=1, font="Arial 1", bg=self.msDlgBGColor)
                        self.lblVlastniSkalaVycp2.grid(row=0, column=3)
                        self.lblVlastniSkalaMax = Label(self.frmVlastniSkala,
                                                        text="max", bg=self.msDlgBGColor)
                        self.lblVlastniSkalaMax.grid(row=0, column=4)
                        self.btnVlastniSkalaMax = Button(self.frmVlastniSkala,
                                                         width=2, bd=1, bg=self.msColorMax, font="Arial 6",
                                                         command=self.mtdBarvaMax)
                        self.btnVlastniSkalaMax.grid(row=0, column=5)

                     self.rbtJednaBarva = Radiobutton(self.lbfBarvy,
                                                       text=u"Pouze jedna barva", variable=self.tkiRbtBarvy,
                                                       value=3, bg=self.msDlgBGColor,command=self.mtdJednaBarvaAkt)
                     self.rbtJednaBarva.pack(anchor=N+W)
                     self.frmJednaBarva = Frame(self.lbfBarvy,
                                                  bg=self.msDlgBGColor)
                     self.frmJednaBarva.pack(anchor=N+W)
                     if ( True ):                        
                        self.lblJednaBarva = Label(self.frmJednaBarva,
                                                         width=2, bg=self.msDlgBGColor)
                        self.lblJednaBarva.grid(row=0, column=0)
                        self.lblJednaBarvaMax = Label(self.frmJednaBarva,text="max", bg=self.msDlgBGColor)
                        self.lblJednaBarvaMax.grid(row=0,column=1)                   
                        self.btnJednaBarva = Button(self.frmJednaBarva,width=2, bd=1, bg="#d0d0d0", font="Arial 6",state="disable", command=self.mtdJednaBarva)
                        self.btnJednaBarva.grid(row=0,column=2)

#           Ram pro oblast tabulky vuci diagonale
            self.lbfDiagObl = LabelFrame(self.frmDialog,
                                         text=u" Diagonla ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                         padx=5, pady=5, font=self.msFrameFont)
            self.lbfDiagObl.pack(fill=BOTH, expand=True)
            if ( True ):
               self.tkbChbSuperDiag.set(self.mbSuperDiag)
               self.chbSuperDiag = Checkbutton(self.lbfDiagObl,
                                             text=u"Nebarvit nad diagonlou", variable=self.tkbChbSuperDiag,
                                             onvalue=True, offvalue=False, bg=self.msDlgBGColor)
               self.chbSuperDiag.bind("<Button-1>", self.mtdSuperDiagAkt)
               self.chbSuperDiag.pack(side=LEFT, fill=X, expand=True)
               self.tkbChbJumpDiag.set(self.mbJumpDiag)
               self.chbJumpDiag = Checkbutton(self.lbfDiagObl,
                                                text=u"Vynechat diagonlu", variable=self.tkbChbJumpDiag,
                                                onvalue=True, offvalue=False, bg=self.msDlgBGColor)
               self.chbJumpDiag.bind("<Button-1>", self.mtdJumpDiagAkt)
               self.chbJumpDiag.pack(side=LEFT, fill=X, expand=True)
                             
#           Przdn pole povaovat za nuly
            self.lbfPrazdnaPole = LabelFrame(self.frmDialog,
                                        text=u" Przdn pole ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                        padx=5, pady=5, font=self.msFrameFont)
            self.lbfPrazdnaPole.pack(fill=BOTH, expand=True)
            if ( True ):
               self.tkbChbPrazdnaPole.set(self.mbPrazdnaPole)
               self.chbPrazdnaPole = Checkbutton(self.lbfPrazdnaPole,
                                            text=u"Przdn pole povaovat za nuly", variable=self.tkbChbPrazdnaPole,
                                            onvalue=True, offvalue=False, bg=self.msDlgBGColor)
               self.chbPrazdnaPole.bind("<Button-1>", self.mtdPrazdnaPoleAkt)
               self.chbPrazdnaPole.pack(side=LEFT)
               
#        Nacitani dat / Obarvovani tabulky
         self.lbfNacitObarv = LabelFrame(self.dlgDialog,
                                         text=u" Natm data z tabulky ", bg=self.msDlgBGColor, fg=self.msFrmFGColor,
                                         font=self.msFrameFont, padx=5, pady=5)
         self.lbfNacitObarv.pack(fill=BOTH, expand=True)
         if ( True ):
#           Obal ProgressBaru
            self.frmPrBarKraj = Frame(self.lbfNacitObarv,
                                      bg=self.msDlgBGColor, height=10, bd=2, relief=RIDGE)
            self.frmPrBarKraj.pack(fill=X, expand=True)
            if ( True ):
#              ProgressBar
               self.frmProgressBar = Frame(self.frmPrBarKraj,
                                           bg=self.msFrmFGColor, height=6, relief=FLAT)
               self.frmProgressBar.pack(side=LEFT)
#        Ram tlacitek + copyright
         self.frmButtons = Frame(self.dlgDialog,
                                 bg=self.msDlgBGColor)
         self.frmButtons.pack(fill=BOTH, expand=True)
         if ( True ):
            self.btnOK = Button(self.frmButtons,
                                text=u"OK", width=8, command=self.mtdOK, padx=0, pady=0)
            self.btnOK.pack(side=LEFT, padx=5, pady=5)
            self.btnStorno = Button(self.frmButtons,
                                    text=u"Storno", width=8, command=self.mtdStorno, padx=0, pady=0)
            self.btnStorno.pack(side=LEFT, padx=5, pady=5)
            self.lblCopyright = Label(self.frmButtons,
                                      text=u'Copyright ACREA CR', bg=self.msDlgBGColor, font="Arial 8 italic",
                                      fg='#000000')
            self.lblCopyright.pack(side=RIGHT)
#        Spusteni dialogu
         self.dlgDialog.mainloop()

      def mtdParameters(self):
         """**************************************************************
         * Promenne a parametry bezpecne nactene z dialogu.              *
         **************************************************************"""
#        Rozsah barvenych bunek tabulky
         moDataTab.mnRowsFrom = int(self.spnRowsFrom.get())
         moDataTab.mnRowsTo = int(self.spnRowsTo.get())
         moDataTab.mnColsFrom = int(self.spnColsFrom.get())
         moDataTab.mnColsTo = int(self.spnColsTo.get())
#        Identifikatory vsech radiobuttonu
         self.mnKrit = self.tkiRbtKriterium.get()
         self.mnObl = self.tkiRbtOblast.get()
         self.mnBarvy = self.tkiRbtBarvy.get()
#        Uzivatelske svetlosti (Lightness) barvy min a max hodnoty
         if (self.mnBarvy==3) :
            moDataTab.mlHLSColorMin = fncRGB2HLS(self.msOneColor)
            moDataTab.mlHLSColorMax = fncRGB2HLS(self.msOneColor)
         else:
            if ( self.mnBarvy == 1 ):
               moDataTab.mlHLSColorMin = fncRGB2HLS("#5a5aff")
               moDataTab.mlHLSColorMax = fncRGB2HLS("#ff5a5a")
            else:
               moDataTab.mlHLSColorMin = fncRGB2HLS(self.msColorMin)
               moDataTab.mlHLSColorMax = fncRGB2HLS(self.msColorMax)
         moDataTab.mnLigMin = 240*moDataTab.mlHLSColorMin[1]
         moDataTab.mnLigMax = 240*moDataTab.mlHLSColorMax[1]

      def mtdIsDlgOK(self):
         """**************************************************************
         * Kontrola pripustnosti hodnot v dialogu.                       *
         **************************************************************"""
#        Pocet obarvovanych bunek
         if ( self.mnKrit == 1 ):
            if ( self.mbRowsEq and self.mbColsEq ):
               tkMessageBox.showerror(u"Chyba",u"Nelze obarvovat oblast o rozsahu jednin buky.")
               return ( False )
#        Hodnoty vlastniho rozsahu
         if ( self.mnKrit == 4 ):
            try:
               self.mnVlastniRozsahMin = float(self.tksVlastniRozsahMin.get().replace(",","."))
            except:
               tkMessageBox.showerror(u"Chyba",u"V poli pro minimum vlastnho rozsahu mus bt slo.")
               return ( False )
            try:
               self.mnVlastniRozsahMax = float(self.tksVlastniRozsahMax.get().replace(",","."))
            except:
               tkMessageBox.showerror(u"Chyba",u"V poli pro maximum vlastnho rozsahu mus bt slo.")
               return ( False )
            try:
               self.mnVlastniRozsahMez = float(self.tksVlastniRozsahMez.get().replace(",","."))
            except:
               tkMessageBox.showerror(u"Chyba",u"V poli pro mez vlastnho rozsahu mus bt slo.")
               return ( False )
            if ( (self.mnVlastniRozsahMez <= self.mnVlastniRozsahMin) or
                 (self.mnVlastniRozsahMax <= self.mnVlastniRozsahMin) or
                 (self.mnVlastniRozsahMin >= self.mnVlastniRozsahMax) or
                 (self.mnVlastniRozsahMez >= self.mnVlastniRozsahMax) ):
               tkMessageBox.showerror(u"Chyba",u"Hodnoty v polch Min, Mez a Max mus splovat Min < Mez < Max.")
               return ( False )
         return ( True )

      def mtdTabColour(self):
         """**************************************************************
         * Metoda obarveni tabulky.                                      *
         **************************************************************"""
#        Uprava popisku ProgressBaru
         self.lbfNacitObarv.config(text=u" Obarvuji tabulku ")
         self.lbfNacitObarv.update()
#        Vynulovani iteratoru
         self.miIterator = 0
#        Zviditelneni ProgressBaru
         self.frmProgressBar.config(bg=self.msFrmFGColor)
         # Pokud je oznaen "Przdn pole povaovat za nuly"
         if (self.mbPrazdnaPole):
            for i in range(moDataTab.mnNumRows):
               for j in range(moDataTab.mnNumCols):
                  if ((moDataTab.mlTab[i][j]==0) and (moDataTab.mbTab[i][j])==False):
                     (moDataTab.mbTab[i][j])=True
                     
         if ( self.mnKrit == 1 ):
#           Dle hodnot v tabulce
            if ( self.mnObl == 1 ):
#              Cela tabulka
#              Pripadna oprava mlTabSort a pocet platnych hodnot
               if ( (moDataTab.mnRowsFrom!=1) or (moDataTab.mnColsFrom!=1) or
                    (moDataTab.mnRowsTo!=moDataTab.mnNumRows) or (moDataTab.mnColsTo!=moDataTab.mnNumCols) or
                    self.mbJumpDiag or self.mbSuperDiag or self.mbPrazdnaPole):
                  moDataTab.mlTabSort = []
                  self.miValidVals = 0
                  for i in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
                     for j in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
                        if ( moDataTab.mbTab[i][j] ):
                           if ( not(self.mbJumpDiag and i-moDataTab.mnRowsFrom+1==j-moDataTab.mnColsFrom+1) ):
                              if ( not(self.mbSuperDiag and i-moDataTab.mnRowsFrom+1<j-moDataTab.mnColsFrom+1) ):
                                 moDataTab.mlTabSort.append(moDataTab.mlTab[i][j])
                                 self.miValidVals += 1                  
                  moDataTab.mlTabSort.sort()
#              Pomocne promenne
               m = self.mnLightnessMax
               b = moDataTab.mnLigMin 
               q = moDataTab.mnLigMax
#              Pokud jsou oznaen absolutn hodnoty (pvodn hodnoty nahrad absolutnmi hodnotami a sead podle nich)
               if ( self.mbAbsHod ):
                  for i in range(len(moDataTab.mlTabSort)):
                     moDataTab.mlTabSort[i] = abs(moDataTab.mlTabSort[i])
                  moDataTab.mlTabSort.sort()
#              Vpoet parametr z dan oblasti tabulky (minimum, maximum a sted mezi nimi)
               alfa,omega,Ex = fncParComp(moDataTab.mlTabSort)
#              Vypocet parametru transformace "hodnota->svetlost"
               if (not(self.mnBarvy == 3)):                       # Pokud nen oznaen pouze jedna barva
                  K = []; R = []; S = []
                  K.append((b-m)/(alfa-Ex)) 
                  R.append(b-K[0]*alfa)     
                  S.append(-9999)           
                  K.append((m-q)/(Ex-omega))
                  R.append(m-K[1]*Ex)       
                  S.append(-9999)
               if ( self.mnBarvy == 3 ):                       # Pokud je oznaen pouze jedna barva
                  K = []; R = []; S = []
                  K.append(0)                               # Zbyten, nepouije se 
                  R.append(0)                               # Zbyten, nepouije se
                  S.append(0)                               # Zbyten, nepouije se
                  K.append((m-q)/(alfa-omega))
                  R.append(m-K[1]*alfa)       
                  S.append(-9999)                 
#              Obarveni bunky (i,j)    
               for i in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
                  for j in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
                     if ( moDataTab.mbTab[i][j] ):
                        if ( not(self.mbJumpDiag and i-moDataTab.mnRowsFrom+1==j-moDataTab.mnColsFrom+1) ):
                           if ( not(self.mbSuperDiag and i-moDataTab.mnRowsFrom+1<j-moDataTab.mnColsFrom+1) ):
                              mnVal = moDataTab.mlTab[i][j]
                              if ( self.mbAbsHod ):
                                 mnVal = abs(mnVal)
                              if ( self.mnBarvy == 3 ):
                                 Ex=alfa
                              fncSetBgColor(mnVal,i,j,Ex,K,R,S)                             
                              self.miIterator += 1
                              self.mtdProgress(self.miIterator,self.miValidVals)

            elif ( self.mnObl == 2 ):
#              Radky
#              Pocet platnych hodnot
               self.mtdNumValidVals()
               for i in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
#                 Parametry obarvovaciho modelu
                  moDataTab.mlTabSort = []
                  for j in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
                     if ( moDataTab.mbTab[i][j] ):
                        if ( self.mbAbsHod ):
                           moDataTab.mlTabSort.append(abs(moDataTab.mlTab[i][j]))
                        else:   
                           moDataTab.mlTabSort.append(moDataTab.mlTab[i][j])
                  moDataTab.mlTabSort.sort()                  
                  moDataTab.mnValMin = moDataTab.mlTabSort[0] 
                  moDataTab.mnValMax = moDataTab.mlTabSort[-1]
#                 Detekce konstantnich hodnot v radku
                  if ( moDataTab.mnValMin != moDataTab.mnValMax ):
#                    Pomocne promenne
                     m = self.mnLightnessMax
                     b = moDataTab.mnLigMin 
                     q = moDataTab.mnLigMax
#                    Vpoet parametr z dan oblasti tabulky (minimum, maximum a sted mezi nimi)
                     alfa,omega,Ex = fncParComp(moDataTab.mlTabSort)
#                    Vypocet parametru transformace "hodnota->svetlost"
                     if (not(self.mnBarvy == 3 )):                       # Pokud nen oznaen pouze jedna barva
                        K = []; R = []; S = []
                        K.append((b-m)/(alfa-Ex)) 
                        R.append(b-K[0]*alfa)     
                        S.append(-9999)           
                        K.append((m-q)/(Ex-omega))
                        R.append(m-K[1]*Ex)       
                        S.append(-9999)
                     if ( self.mnBarvy == 3 ):                       # Pokud je oznaen pouze jedna barva
                        K = []; R = []; S = []
                        K.append(0)                               # Zbyten, nepouije se 
                        R.append(0)                               # Zbyten, nepouije se
                        S.append(0)                               # Zbyten, nepouije se
                        K.append((m-q)/(alfa-omega))
                        R.append(m-K[1]*alfa)       
                        S.append(-9999)                             
#                    Obarveni bunky (i,j)
                     for j in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
                        if ( moDataTab.mbTab[i][j] ):
                           mnVal = moDataTab.mlTab[i][j]
                           if ( self.mbAbsHod ):
                              mnVal = abs(mnVal)
                           if ( self.mnBarvy == 3 ):   
                              Ex=alfa
                           fncSetBgColor(mnVal,i,j,Ex,K,R,S)
                           self.miIterator += 1
                           self.mtdProgress(self.miIterator,self.miValidVals)
                  else:
                     tkMessageBox.showinfo(u"",unicode(i+1)+u". dek obsahuje konstantn data, nelze ho obarvit.")
                     self.dlgDialog.update()
                     
            elif ( self.mnObl == 3 ):
#              Sloupce
#              Pocet platnych hodnot
               self.mtdNumValidVals()
               for i in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
#                 Parametry obarvovaciho modelu
                  moDataTab.mlTabSort = []
                  for j in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
                     if ( moDataTab.mbTab[j][i] ):
                        if ( self.mbAbsHod ):
                           moDataTab.mlTabSort.append(abs(moDataTab.mlTab[j][i]))
                        else:
                           moDataTab.mlTabSort.append(moDataTab.mlTab[j][i])
                  moDataTab.mlTabSort.sort()
                  moDataTab.mnValMin = moDataTab.mlTabSort[0] 
                  moDataTab.mnValMax = moDataTab.mlTabSort[-1]
#                 Detekce konstantnich hodnot ve sloupci
                  if ( moDataTab.mnValMin != moDataTab.mnValMax ):
#                    Pomocne promenne
                     m = self.mnLightnessMax
                     b = moDataTab.mnLigMin 
                     q = moDataTab.mnLigMax
#                    Vpoet parametr z dan oblasti tabulky (minimum, maximum a sted mezi nimi)
                     alfa,omega,Ex = fncParComp(moDataTab.mlTabSort)
#                    Vypocet parametru transformace "hodnota->svetlost"
                     if (not(self.mnBarvy == 3 )):                       # Pokud nen oznaen pouze jedna barva
                        K = []; R = []; S = []
                        K.append((b-m)/(alfa-Ex)) 
                        R.append(b-K[0]*alfa)     
                        S.append(-9999)           
                        K.append((m-q)/(Ex-omega))
                        R.append(m-K[1]*Ex)       
                        S.append(-9999)
                     if ( self.mnBarvy == 3 ):                       # Pokud je oznaen pouze jedna barva
                        K = []; R = []; S = []
                        K.append(0)                               # Zbyten, nepouije se 
                        R.append(0)                               # Zbyten, nepouije se
                        S.append(0)                               # Zbyten, nepouije se
                        K.append((m-q)/(alfa-omega))
                        R.append(m-K[1]*alfa)       
                        S.append(-9999)         
#                    Obarveni bunky (j,i)
                     for j in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
                        if ( moDataTab.mbTab[j][i] ):
                           mnVal = moDataTab.mlTab[j][i]
                           if ( self.mbAbsHod ):
                              mnVal = abs(mnVal)
                           if ( self.mnBarvy == 3 ):   
                              Ex=alfa
                           fncSetBgColor(mnVal,j,i,Ex,K,R,S)
                           self.miIterator += 1
                           self.mtdProgress(self.miIterator,self.miValidVals)
                  else:
                     tkMessageBox.showinfo(u"",unicode(i+1)+u". sloupec obsahuje konstantn data, nelze ho obarvit.")
                     self.dlgDialog.update()

         elif ( self.mnKrit == 2 ):          
#           Korelace
#           Pocet platnych hodnot
            self.mtdNumValidVals()
#           Pomocne promenne
            m = self.mnLightnessMax
            b = moDataTab.mnLigMin 
            q = moDataTab.mnLigMax 
            alfa = -1.0
            Ex = 0.0
            omega = 1.0
#           Vypocet parametru transformace "hodnota->svetlost"
            K = []; R = []; S = []
            K.append((b-m)/(alfa-Ex)) 
            R.append(b-K[0]*alfa)     
            S.append(-9999)           
            K.append((m-q)/(Ex-omega))
            R.append(m-K[1]*Ex)       
            S.append(-9999)           
#           Obarveni bunky (i,j)
            for i in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
               for j in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
                  if ( moDataTab.mbTab[i][j] ):
                     if ( not(self.mbJumpDiag and i-moDataTab.mnRowsFrom+1==j-moDataTab.mnColsFrom+1) ):
                        if ( not(self.mbSuperDiag and i-moDataTab.mnRowsFrom+1<j-moDataTab.mnColsFrom+1) ):
                           mnVal = moDataTab.mlTab[i][j]
                           if ( self.mbAbsHod ):
                              mnVal = abs(mnVal)
                           if ( mnVal < -1 ):
                              if ( self.mbAbsHod ):
                                 miSpssColor = fncHLS2SPSS(fncRGB2HLS(self.msOneColor))
                              else:
                                 miSpssColor = fncHLS2SPSS(fncRGB2HLS(self.msColorMin))
                              try:
                                 moDataTab.moDataCells.SetBackgroundColorAt(i,j,miSpssColor)
                              except:
                                 tkMessageBox.showerror(u"Chyba",u"Nelze obarvit pole tabulky na pozici ("+unicode(i+1)+","+unicode(j+1)+")")
                           elif ( mnVal > 1 ):
                              if ( self.mbAbsHod ):
                                 miSpssColor = fncHLS2SPSS(fncRGB2HLS(self.msOneColor))
                              else:
                                 miSpssColor = fncHLS2SPSS(fncRGB2HLS(self.msColorMax))
                              try:
                                 moDataTab.moDataCells.SetBackgroundColorAt(i,j,miSpssColor)
                              except:
                                 tkMessageBox.showerror(u"Chyba",u"Nelze obarvit pole tabulky na pozici ("+unicode(i+1)+","+unicode(j+1)+")")
                           else:
                              fncSetBgColor(mnVal,i,j,Ex,K,R,S)
                           self.miIterator += 1
                           self.mtdProgress(self.miIterator,self.miValidVals)
                           
         elif ( self.mnKrit == 3 ):            
#           Procenta
#           Pocet platnych hodnot
            self.mtdNumValidVals()
#           Pomocne promenne
            m = self.mnLightnessMax
            b = moDataTab.mnLigMin 
            q = moDataTab.mnLigMax 
            alfa = 0.0
            Ex = 50.0
            omega = 100.0
#           Vypocet parametru transformace "hodnota->svetlost"
            if (not(self.mnBarvy == 3 )):                       # Pokud nen oznaen pouze jedna barva
               K = []; R = []; S = []
               K.append((b-m)/(alfa-Ex)) 
               R.append(b-K[0]*alfa)     
               S.append(-9999)           
               K.append((m-q)/(Ex-omega))
               R.append(m-K[1]*Ex)       
               S.append(-9999)
            if ( self.mnBarvy == 3 ):                       # Pokud je oznaen pouze jedna barva
               K = []; R = []; S = []
               K.append(0)                               # Zbyten, nepouije se 
               R.append(0)                               # Zbyten, nepouije se
               S.append(0)                               # Zbyten, nepouije se
               K.append((m-q)/(alfa-omega))
               R.append(m-K[1]*alfa)       
               S.append(-9999)         
#           Obarveni bunky (i,j)
            for i in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
               for j in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
                  if ( moDataTab.mbTab[i][j] ):
                     if ( not(self.mbJumpDiag and i-moDataTab.mnRowsFrom+1==j-moDataTab.mnColsFrom+1) ):
                        if ( not(self.mbSuperDiag and i-moDataTab.mnRowsFrom+1<j-moDataTab.mnColsFrom+1) ):
                           mnVal = moDataTab.mlTab[i][j]
                           if ( mnVal < 0 ):
                              miSpssColor = fncHLS2SPSS(fncRGB2HLS(self.msColorMin))
                              try:
                                 moDataTab.moDataCells.SetBackgroundColorAt(i,j,miSpssColor)
                              except:
                                 tkMessageBox.showerror(u"Chyba",u"Nelze obarvit pole tabulky na pozici ("+unicode(i+1)+","+unicode(j+1)+")")
                           elif ( mnVal > 100 ):
                              miSpssColor = fncHLS2SPSS(fncRGB2HLS(self.msColorMax))
                              try:
                                 moDataTab.moDataCells.SetBackgroundColorAt(i,j,miSpssColor)
                              except:
                                 tkMessageBox.showerror(u"Chyba",u"Nelze obarvit pole tabulky na pozici ("+unicode(i+1)+","+unicode(j+1)+")")
                           else:
                              if ( self.mnBarvy == 3 ):
                                 Ex=alfa
                              fncSetBgColor(mnVal,i,j,Ex,K,R,S)
                           self.miIterator += 1
                           self.mtdProgress(self.miIterator,self.miValidVals)
                           
         elif ( self.mnKrit == 4 ):
#           Vlastni rozsah
#           Pocet platnych hodnot
            self.mtdNumValidVals()
#           Pomocne promenne
            m = self.mnLightnessMax
            b = moDataTab.mnLigMin 
            q = moDataTab.mnLigMax 
            alfa = self.mnVlastniRozsahMin
            Ex = self.mnVlastniRozsahMez
            omega = self.mnVlastniRozsahMax
#           Vypocet parametru transformace "hodnota->svetlost"
            if (not(self.mnBarvy == 3 )):                       # Pokud nen oznaen pouze jedna barva
               K = []; R = []; S = []
               K.append((b-m)/(alfa-Ex)) 
               R.append(b-K[0]*alfa)     
               S.append(-9999)           
               K.append((m-q)/(Ex-omega))
               R.append(m-K[1]*Ex)       
               S.append(-9999)
            if ( self.mnBarvy == 3 ):                       # Pokud je oznaen pouze jedna barva
               K = []; R = []; S = []
               K.append(0)                               # Zbyten, nepouije se 
               R.append(0)                               # Zbyten, nepouije se
               S.append(0)                               # Zbyten, nepouije se
               K.append((m-q)/(alfa-omega))
               R.append(m-K[1]*alfa)       
               S.append(-9999)         
#           Obarveni bunky (i,j)
            for i in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
               for j in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
                  if ( moDataTab.mbTab[i][j] ):
                     if ( not(self.mbJumpDiag and i-moDataTab.mnRowsFrom+1==j-moDataTab.mnColsFrom+1) ):
                        if ( not(self.mbSuperDiag and i-moDataTab.mnRowsFrom+1<j-moDataTab.mnColsFrom+1) ):
                           mnVal = moDataTab.mlTab[i][j]
                           if ( self.mbAbsHod ):
                              mnVal = abs(mnVal)
                           if ( mnVal < self.mnVlastniRozsahMin ):
                              miSpssColor = fncHLS2SPSS(fncRGB2HLS(self.msColorMin))
                              try:
                                 moDataTab.moDataCells.SetBackgroundColorAt(i,j,miSpssColor)
                              except:
                                 tkMessageBox.showerror(u"Chyba",u"Nelze obarvit pole tabulky na pozici ("+unicode(i+1)+","+unicode(j+1)+")")
                           elif ( mnVal > self.mnVlastniRozsahMax ):
                              miSpssColor = fncHLS2SPSS(fncRGB2HLS(self.msColorMax))
                              try:
                                 moDataTab.moDataCells.SetBackgroundColorAt(i,j,miSpssColor)
                              except:
                                 tkMessageBox.showerror(u"Chyba",u"Nelze obarvit pole tabulky na pozici ("+unicode(i+1)+","+unicode(j+1)+")")
                           else:
                              if ( self.mnBarvy == 3 ):
                                 Ex=alfa
                              fncSetBgColor(mnVal,i,j,Ex,K,R,S)
                           self.miIterator += 1
                           self.mtdProgress(self.miIterator,self.miValidVals)

      def mtdStorno(self):
         """**************************************************************
         * Metoda tlacitka Storno. Ukonceni dialogu.                     *
         **************************************************************"""
         self.mtdDlgTermination()

      def mtdProgress(self,fiIterator,fnDenom):
         """**************************************************************
         * Metoda ridici delku ProgressBaru.                             *
         **************************************************************"""
         self.frmProgressBar.config(width=int(round(self.miPrBarWidthMax*fiIterator/fnDenom)))
         self.frmProgressBar.update()

      def mtdOK(self):
         """**************************************************************
         * Metoda tlacitka OK.                                           *
         **************************************************************"""
         self.mtdParameters()
         if ( self.mtdIsDlgOK() ):
            self.mtdFreezeDlg()
            self.mtdTabColour()
            self.mtdDlgTermination()

      def mtdFreezeDlg(self):
         """**************************************************************
         * Metoda znepristupni ovladaci prvky dialogu.                   *
         **************************************************************"""
         self.spnRowsFrom.config(state="disable")
         self.spnRowsTo.config(state="disable")
         self.spnColsFrom.config(state="disable")
         self.spnColsTo.config(state="disable")
         self.rbtHodnoty.config(state="disable")
         self.rbtKorelace.config(state="disable")
         self.rbtProcenta.config(state="disable")
         self.rbtVlastniRozsah.config(state="disable")
         self.entVlastniRozsahMin.config(state="disable")
         self.lblVlastniRozsahMin.config(state="disabled")
         self.entVlastniRozsahMax.config(state="disable")
         self.lblVlastniRozsahMax.config(state="disabled")
         self.entVlastniRozsahMez.config(state="disable")
         self.lblVlastniRozsahMez.config(state="disabled")
         self.rbtCelaOblast.config(state="disable")
         self.rbtRadky.config(state="disable")
         self.rbtSloupce.config(state="disable")
         self.rbtAutomaticky.config(state="disable")
         self.rbtVlastniSkala.config(state="disable")
         self.btnVlastniSkalaMin.config(state="disable")
         self.lblVlastniSkalaMin.config(state="disable")
         self.btnVlastniSkalaMax.config(state="disable")
         self.lblVlastniSkalaMax.config(state="disable")
         self.chbSuperDiag.config(state="disable")
         self.chbJumpDiag.config(state="disable")
         self.chbAbsHod.config(state="disable")
         self.btnJednaBarva.config(state="disable")
         self.lblJednaBarvaMax.config(state="disable")
         self.btnOK.config(state="disable")
         self.btnStorno.config(state="disable")

      def mtdDefreezeDlg(self):
         """**************************************************************
         * Metoda zpristupni urcite ovladaci prvky dialogu.              *
         **************************************************************"""
         self.spnRowsFrom.config(state="readonly")
         self.spnRowsTo.config(state="readonly")
         self.spnColsFrom.config(state="readonly")
         self.spnColsTo.config(state="readonly")
         self.rbtHodnoty.config(state="normal")
         self.rbtKorelace.config(state="normal")
         self.rbtProcenta.config(state="normal")
         self.rbtVlastniRozsah.config(state="normal")
         self.lblVlastniRozsahMin.config(state="normal")
         self.lblVlastniRozsahMax.config(state="normal")
         self.lblVlastniRozsahMez.config(state="normal")
         self.rbtCelaOblast.config(state="normal")
         if (moDataTab.mnNumCols==1 ):
            self.mbColsEq = True
            self.rbtRadky.config(state="disable")
         else:
            self.rbtRadky.config(state="normal")
         if (moDataTab.mnNumRows==1 ):
            self.mbRowsEq = True
            self.rbtSloupce.config(state="disable")
         else:
            self.rbtSloupce.config(state="normal")
         self.rbtAutomaticky.config(state="normal")
         self.rbtVlastniSkala.config(state="normal")
         self.btnVlastniSkalaMin.config(state="normal")
         self.lblVlastniSkalaMin.config(state="normal")
         self.btnVlastniSkalaMax.config(state="normal")
         self.lblVlastniSkalaMax.config(state="normal")
         self.chbSuperDiag.config(state="normal")
         self.chbJumpDiag.config(state="normal")
         self.chbAbsHod.config(state="normal")
         self.btnJednaBarva.config(state="normal")
         self.lblJednaBarvaMax.config(state="normal")
         self.btnOK.config(state="normal")
         self.btnStorno.config(state="normal")

      def mtdDlgTermination(self):
         """**************************************************************
         * Metoda ukonci dialog.                                         *
         **************************************************************"""
         try:
            self.moPivotTable.SetUpdateScreen(True)
         except:
            pass
         SpssClient.StopClient()
##         self.dlgDialog.quit()
         self.dlgDialog.destroy()

      def mtdNumValidVals(self):
         """**************************************************************
         * Metoda zjisti pocet platnych hodnot oblasti bunek.            *
         **************************************************************"""
         if ( (moDataTab.mnRowsFrom!=1) or (moDataTab.mnColsFrom!=1) or
              (moDataTab.mnRowsTo!=moDataTab.mnNumRows) or (moDataTab.mnColsTo!=moDataTab.mnNumCols) or
              self.mbJumpDiag or self.mbSuperDiag ):
            self.miValidVals = 0
            for i in range(moDataTab.mnRowsFrom-1,moDataTab.mnRowsTo):
               for j in range(moDataTab.mnColsFrom-1,moDataTab.mnColsTo):
                  if ( moDataTab.mbTab[i][j] ):
                     if ( not(self.mbJumpDiag and i-moDataTab.mnRowsFrom+1==j-moDataTab.mnColsFrom+1) ):
                        if ( not(self.mbSuperDiag and i-moDataTab.mnRowsFrom+1<j-moDataTab.mnColsFrom+1) ):
                           self.miValidVals += 1

      def mtdBarvaMax(self):
         """**************************************************************
         * Metoda barvy maxima.                                          *
         **************************************************************"""
         mtTkMaxColor,self.msColorMaxHelp = tkColorChooser.askcolor(initialcolor=self.msColorMax)
         if ( self.msColorMaxHelp ):
            self.msColorMax = self.msColorMaxHelp
            self.btnVlastniSkalaMax.config(bg=self.msColorMax)
            self.tkiRbtBarvy.set(2)

      def mtdJednaBarva(self):
         """**************************************************************
         * Metoda barvy pri pouziti pouze jedne barvy.                  *
         **************************************************************"""
         mtTkOneColor,self.msOneColorHelp = tkColorChooser.askcolor(initialcolor=self.msOneColor)
         if ( self.msOneColorHelp ):
            self.msOneColor = self.msOneColorHelp
            self.btnJednaBarva.config(bg=self.msOneColor)
            self.tkiRbtBarvy.set(3)
            self.rbtAutomaticky.config(state="normal")
            self.rbtVlastniSkala.config(state="normal")
            self.rbtJednaBarva.config(state="normal")
            self.btnJednaBarva.config(state="normal", bg=self.msOneColor) 
            self.btnVlastniSkalaMin.config(state="disable", bg="#d0d0d0")
            self.btnVlastniSkalaMax.config(state="disable", bg="#d0d0d0")
            self.lblVlastniSkalaMin.config(state="disable")
            self.lblVlastniSkalaMax.config(state="disable")


      def mtdBarvaMin(self):
         """**************************************************************
         * Metoda barvy minima.                                          *
         **************************************************************"""
         mtTkMinColor,self.msColorMinHelp = tkColorChooser.askcolor(initialcolor=self.msColorMin)
         if ( self.msColorMinHelp ):
            self.msColorMin = self.msColorMinHelp
            self.btnVlastniSkalaMin.config(bg=self.msColorMin)
            self.tkiRbtBarvy.set(2)

      def mtdHodnotyAkt(self):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu.               *
         **************************************************************"""
         self.mbKriterium = 1
         self.rbtCelaOblast.config(state="normal")
         if ( not(self.mbSuperDiag or self.mbJumpDiag or self.mbRowsEq) ):
            self.rbtSloupce.config(state="normal")
         if ( not(self.mbSuperDiag or self.mbJumpDiag or self.mbColsEq) ):
            self.rbtRadky.config(state="normal")
         self.tkiRbtBarvy.set(1)
         self.rbtAutomaticky.config(state="normal")
         self.rbtVlastniSkala.config(state="normal")
         self.rbtJednaBarva.config(state="normal")
         self.entVlastniRozsahMin.config(state="disable")
         self.entVlastniRozsahMax.config(state="disable")
         self.entVlastniRozsahMez.config(state="disable")
         self.chbAbsHod.config(state="normal")
         self.chbPrazdnaPole.config(state="normal")
         self.tkiRbtBarvy.set(1)
         self.btnJednaBarva.config(state="normal", bg="#d0d0d0")
         self.btnVlastniSkalaMin.config(state="normal", bg=self.msColorMin)
         self.btnVlastniSkalaMax.config(state="normal", bg=self.msColorMax)
         self.lblVlastniSkalaMin.config(state="normal")
         self.lblVlastniSkalaMax.config(state="normal")
         self.lblJednaBarvaMax.config(state="normal")

      def mtdKorelaceAkt(self):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu.               *
         **************************************************************"""
         self.mbKriterium = 2
         self.rbtCelaOblast.config(state="normal")
         self.rbtRadky.config(state="disable")
         self.rbtSloupce.config(state="disable")
         self.entVlastniRozsahMin.config(state="disable")
         self.entVlastniRozsahMax.config(state="disable")
         self.entVlastniRozsahMez.config(state="disable")
         self.tkiRbtOblast.set(1)
         self.chbAbsHod.config(state="normal")
         self.chbPrazdnaPole.config(state="disable")
         if (self.mbAbsHod):
            self.tkiRbtBarvy.set(3)
            self.rbtAutomaticky.config(state="disable")
            self.rbtVlastniSkala.config(state="disable")
            self.btnJednaBarva.config(state="normal", bg=self.msOneColor)
            self.btnVlastniSkalaMin.config(state="disable", bg="#d0d0d0")
            self.btnVlastniSkalaMin.config(state="disable", bg="#d0d0d0")
            self.btnVlastniSkalaMax.config(state="disable", bg="#d0d0d0")
            self.lblVlastniSkalaMin.config(state="disable")
            self.lblVlastniSkalaMax.config(state="disable")
         else:
            self.tkiRbtBarvy.set(1)
            self.rbtAutomaticky.config(state="normal")
            self.rbtVlastniSkala.config(state="normal")
            self.rbtJednaBarva.config(state="normal")
            self.btnJednaBarva.config(state="normal", bg="#d0d0d0")
            self.btnVlastniSkalaMin.config(state="normal", bg=self.msColorMin)
            self.btnVlastniSkalaMax.config(state="normal", bg=self.msColorMax)
            self.lblVlastniSkalaMin.config(state="normal")
            self.lblVlastniSkalaMax.config(state="normal")
            self.lblJednaBarvaMax.config(state="normal")
            
      def mtdProcentaAkt(self):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu.               *
         **************************************************************"""
         self.mbKriterium = 4
         self.rbtCelaOblast.config(state="normal")
         self.rbtRadky.config(state="disable")
         self.rbtSloupce.config(state="disable")
         self.entVlastniRozsahMin.config(state="disable")
         self.entVlastniRozsahMax.config(state="disable")
         self.entVlastniRozsahMez.config(state="disable")
         self.tkiRbtOblast.set(1)
         self.chbAbsHod.config(state="disable")
         self.tkiRbtBarvy.set(1)
         self.rbtAutomaticky.config(state="normal")
         self.rbtVlastniSkala.config(state="normal")
         self.rbtJednaBarva.config(state="normal")
         self.entVlastniRozsahMin.config(state="disable")
         self.entVlastniRozsahMax.config(state="disable")
         self.entVlastniRozsahMez.config(state="disable")
         self.chbAbsHod.config(state="disable")
         self.chbPrazdnaPole.config(state="normal")
         self.tkiRbtBarvy.set(1)
         self.btnJednaBarva.config(state="normal", bg="#d0d0d0")
         self.btnVlastniSkalaMin.config(state="normal", bg=self.msColorMin)
         self.btnVlastniSkalaMax.config(state="normal", bg=self.msColorMax)
         self.lblVlastniSkalaMin.config(state="normal")
         self.lblVlastniSkalaMax.config(state="normal")
         self.lblJednaBarvaMax.config(state="normal")

      def mtdVlastniRozsahAkt(self):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu.               *
         **************************************************************"""
         self.mbKriterium = 5
         self.rbtCelaOblast.config(state="normal")
         self.rbtRadky.config(state="disable")
         self.rbtSloupce.config(state="disable")
         self.entVlastniRozsahMin.config(state="normal")
         self.entVlastniRozsahMax.config(state="normal")
         self.entVlastniRozsahMez.config(state="normal")
         self.tkiRbtOblast.set(1)
         self.chbAbsHod.config(state="normal")
         self.tkiRbtBarvy.set(1)
         self.rbtAutomaticky.config(state="normal")
         self.rbtVlastniSkala.config(state="normal")
         self.rbtJednaBarva.config(state="normal")
         self.entVlastniRozsahMin.config(state="normal")
         self.entVlastniRozsahMax.config(state="normal")
         self.entVlastniRozsahMez.config(state="normal")
         self.chbAbsHod.config(state="normal")
         self.chbPrazdnaPole.config(state="normal")
         self.tkiRbtBarvy.set(1)
         self.btnJednaBarva.config(state="normal", bg="#d0d0d0")
         self.btnVlastniSkalaMin.config(state="normal", bg=self.msColorMin)
         self.btnVlastniSkalaMax.config(state="normal", bg=self.msColorMax)
         self.lblVlastniSkalaMin.config(state="normal")
         self.lblVlastniSkalaMax.config(state="normal")
         self.lblJednaBarvaMax.config(state="normal")

      def mtdAbsHodAkt(self,udalost):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu pomoci         *
         * udalosti <Button-1>.                                          *
         **************************************************************"""
         self.mbAbsHod = not(self.mbAbsHod)
         if (self.mbAbsHod):
            if (self.mbKriterium ==2):
               self.tkiRbtBarvy.set(3)
               self.rbtAutomaticky.config(state="disable")
               self.rbtVlastniSkala.config(state="disable")
               self.btnJednaBarva.config(state="normal", bg=self.msOneColor)
               self.btnVlastniSkalaMin.config(state="disable", bg="#d0d0d0")
               self.btnVlastniSkalaMin.config(state="disable", bg="#d0d0d0")
               self.btnVlastniSkalaMax.config(state="disable", bg="#d0d0d0")
               self.lblVlastniSkalaMin.config(state="disable")
               self.lblVlastniSkalaMax.config(state="disable")
         else:
            self.rbtAutomaticky.config(state="normal")
            self.rbtVlastniSkala.config(state="normal")
            self.btnJednaBarva.config(state="normal")
            if (self.mbKriterium ==2):
               self.tkiRbtBarvy.set(1)
               self.btnJednaBarva.config(state="normal", bg="#d0d0d0")
               self.btnVlastniSkalaMin.config(state="normal", bg=self.msColorMin)
               self.btnVlastniSkalaMax.config(state="normal", bg=self.msColorMax)
               self.lblVlastniSkalaMin.config(state="normal")
               self.lblVlastniSkalaMax.config(state="normal")
               self.lblJednaBarvaMax.config(state="normal")

      def mtdPrazdnaPoleAkt(self,udalost):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu pomoci         *
         * udalosti <Button-1>.                                          *
         **************************************************************"""
         self.mbPrazdnaPole = not(self.mbPrazdnaPole)
         if ((self.mbPrazdnaPole) and (moDataTab.mnValMinPrazdnaPole==0)):
            # Pro vlastn rozsah se uprav hodnota minima a meze (pokud tam jsou przdn pole 
            self.tksVlastniRozsahMin.set(str(moDataTab.mnValMinPrazdnaPole))
            self.tksVlastniRozsahMez.set(str((moDataTab.mnValMinPrazdnaPole+moDataTab.mnValMax)/2))
         else:
            self.tksVlastniRozsahMin.set(str(moDataTab.mnValMin))
            self.tksVlastniRozsahMez.set(str((moDataTab.mnValMin+moDataTab.mnValMax)/2))                   

      def mtdAutomatickyAkt(self):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu pomoci         *
         **************************************************************"""  
         self.btnJednaBarva.config(state="normal", bg="#d0d0d0")
         self.btnVlastniSkalaMin.config(state="normal", bg=self.msColorMin)
         self.btnVlastniSkalaMax.config(state="normal", bg=self.msColorMax)
         self.lblVlastniSkalaMin.config(state="normal")
         self.lblVlastniSkalaMax.config(state="normal")
         self.lblJednaBarvaMax.config(state="normal")
         if ((self.mbKriterium == 2) and (self.mbAbsHod)):
            self.chbAbsHod.deselect()
            self.mbAbsHod = not(self.mbAbsHod)
         if (self.mbKriterium == 5):
            self.entVlastniRozsahMez.config(state="normal")

      def mtdVlastniSkalaAkt(self):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu pomoci         *
         **************************************************************"""  
         self.btnVlastniSkalaMin.config(state="normal", bg=self.msColorMin)
         self.btnVlastniSkalaMax.config(state="normal", bg=self.msColorMax)
         self.btnJednaBarva.config(state="disable", bg="#d0d0d0")
         self.lblJednaBarvaMax.config(state="disable")      
         self.lblVlastniSkalaMin.config(state="normal")
         self.lblVlastniSkalaMax.config(state="normal")
         if ((self.mbKriterium == 2) and (self.mbAbsHod)):
            self.chbAbsHod.deselect()
            self.mbAbsHod = not(self.mbAbsHod)
         if (self.mbKriterium == 5):
            self.entVlastniRozsahMez.config(state="normal")
          
      def mtdJednaBarvaAkt(self):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu pomoci         *
         **************************************************************"""       
         self.btnJednaBarva.config(state="normal", bg=self.msOneColor)
         self.btnVlastniSkalaMin.config(state="disable", bg="#d0d0d0")
         self.btnVlastniSkalaMax.config(state="disable", bg="#d0d0d0")
         self.lblVlastniSkalaMin.config(state="disable")
         self.lblVlastniSkalaMax.config(state="disable")
         if (self.mbKriterium == 2):
            self.chbAbsHod.select()
            self.mbAbsHod = not(self.mbAbsHod)
         if (self.mbKriterium == 5):
            self.entVlastniRozsahMez.config(state="disable")
            
      def mtdJumpDiagAkt(self,udalost):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu pomoci         *
         * udalosti <Button-1>.                                          *
         **************************************************************"""
         self.mbJumpDiag = not(self.mbJumpDiag)
         if ( self.mbJumpDiag or self.mbSuperDiag ):
            self.rbtRadky.config(state="disable")
            self.rbtSloupce.config(state="disable")
            self.tkiRbtOblast.set(1)
         else:
            if ( self.tkiRbtKriterium.get() == 1 ):
               if ( not(self.mbRowsEq) ):
                  self.rbtSloupce.config(state="normal")
               if ( not(self.mbColsEq) ):
                  self.rbtRadky.config(state="normal")
            else:
               self.rbtRadky.config(state="disable")
               self.rbtSloupce.config(state="disable")
               self.tkiRbtOblast.set(1)

      def mtdSuperDiagAkt(self,udalost):
         """**************************************************************
         * Zaktivni/zneaktivni prislusne moznosti dialogu pomoci         *
         * udalosti <Button-1>.                                          *
         **************************************************************"""
         self.mbSuperDiag = not(self.mbSuperDiag)
         if ( self.mbSuperDiag or self.mbJumpDiag ):
            self.rbtRadky.config(state="disable")
            self.rbtSloupce.config(state="disable")
            self.tkiRbtOblast.set(1)
         else:
            if ( self.tkiRbtKriterium.get() == 1 ):
               if ( not(self.mbRowsEq) ):
                  self.rbtSloupce.config(state="normal")
               if ( not(self.mbColsEq) ):
                  self.rbtRadky.config(state="normal")
            else:
               self.rbtRadky.config(state="disable")
               self.rbtSloupce.config(state="disable")
               self.tkiRbtOblast.set(1)

      def mtdRowsFromCheck(self):
         """**************************************************************
         * Kontrola pripustnych/nelogickych hodnot.                      *
         **************************************************************"""
         if ( int(self.spnRowsFrom.get()) > int(self.spnRowsTo.get()) ):
            self.spnRowsFrom.config(state="normal")
            self.spnRowsFrom.delete(first=0, last=1)
            self.spnRowsFrom.insert(0,str(int(self.spnRowsTo.get())))
            self.spnRowsFrom.config(state="readonly")
         if ( int(self.spnRowsFrom.get()) == int(self.spnRowsTo.get()) ):
            self.mbRowsEq = True
            self.rbtSloupce.config(state="disable")
            if ( self.tkiRbtOblast.get() == 3 ):
               self.tkiRbtOblast.set(1)
         else:
            self.mbRowsEq = False
            if ( self.tkiRbtKriterium.get() == 1 ):
               if ( not(self.mbJumpDiag or self.mbSuperDiag) ):
                  self.rbtSloupce.config(state="normal")

      def mtdRowsToCheck(self):
         """**************************************************************
         * Kontrola pripustnych/nelogickych hodnot.                      *
         **************************************************************"""
         if ( int(self.spnRowsTo.get()) < int(self.spnRowsFrom.get()) ):
            self.spnRowsTo.config(state="normal")
            self.spnRowsTo.delete(first=0, last=1)
            self.spnRowsTo.insert(0,str(int(self.spnRowsFrom.get())))
            self.spnRowsTo.config(state="readonly")
         if ( int(self.spnRowsTo.get()) == int(self.spnRowsFrom.get()) ):
            self.mbRowsEq = True
            self.rbtSloupce.config(state="disable")
            if ( self.tkiRbtOblast.get() == 3 ):
               self.tkiRbtOblast.set(1)
         else:
            self.mbRowsEq = False
            if ( self.tkiRbtKriterium.get() == 1 ):
               if ( not(self.mbJumpDiag or self.mbSuperDiag) ):
                  self.rbtSloupce.config(state="normal")

      def mtdColsFromCheck(self):
         """**************************************************************
         * Kontrola pripustnych/nelogickych hodnot.                      *
         **************************************************************"""
         if ( int(self.spnColsFrom.get()) > int(self.spnColsTo.get()) ):
            self.spnColsFrom.config(state="normal")
            self.spnColsFrom.delete(first=0, last=1)
            self.spnColsFrom.insert(0,str(int(self.spnColsTo.get())))
            self.spnColsFrom.config(state="readonly")
         if ( int(self.spnColsFrom.get()) == int(self.spnColsTo.get()) ):
            self.mbColsEq = True
            self.rbtRadky.config(state="disable")
            if ( self.tkiRbtOblast.get() == 2 ):
               self.tkiRbtOblast.set(1)
         else:
            self.mbColsEq = False
            if ( self.tkiRbtKriterium.get() == 1 ):
               if ( not(self.mbJumpDiag or self.mbSuperDiag) ):
                  self.rbtRadky.config(state="normal")


      def mtdColsToCheck(self):
         """**************************************************************
         * Kontrola pripustnych/nelogickych hodnot.                      *
         **************************************************************"""
         if ( int(self.spnColsTo.get()) < int(self.spnColsFrom.get()) ):
            self.spnColsTo.config(state="normal")
            self.spnColsTo.delete(first=0, last=1)
            self.spnColsTo.insert(0,str(int(self.spnColsFrom.get())))
            self.spnColsTo.config(state="readonly")
         if ( int(self.spnColsTo.get()) == int(self.spnColsFrom.get()) ):
            self.mbColsEq = True
            self.rbtRadky.config(state="disable")
            if ( self.tkiRbtOblast.get() == 2 ):
               self.tkiRbtOblast.set(1)
         else:
            self.mbColsEq = False
            if ( self.tkiRbtKriterium.get() == 1 ):
               if ( not(self.mbJumpDiag or self.mbSuperDiag) ):
                  self.rbtRadky.config(state="normal")
###############################################################################
   moDataTab = clsDataTab()
   moDialog = clsDialog()
###############################################################################
