# -*- coding: iso8859-2 -*-

"""
Mry variability pro kategorizovan promnn

Skript dopot mry variability pro kategorizovanou promnnou. Vstupem je
tabulka etnost z procedury Frequencies. Vstupem je tabulka obsahujc
poadovan mry variability.

Skriptem lze zpracovat jednu nebo vce oznaench tabulek, vechny tabulky
s OMS Subtype = Frequencies nebo jej lze pout jako autoskript. P runm
spoutn se d vodnm dialogem.

Nov vytvoen tabulka obsahujc mry variability pro uritou kategorizovanou
promnnou se pesune za pslunou tabulku etnost.

Verze skriptu pro IBM SPSS Statistics 22.
"""

__author__  = 'Eliska Kalinova  ekalinova@acrea.cz'
__version__ = '1.3'
__date__ = '17.9.2009'

from tkinter import *
import SpssClient
import copy
import sys
 
class Dialog:
   """ Trida pro zobrazeni uvodniho dialogu. """
   def start(self):
      ### Parametry okna
      windowWidth=310
      windowHeight=385
      bgColor='#f0f0f0'     
      ### Parametry objekt
      ###### Ohranien
      masterRelief=GROOVE
      framewidth=200     
      ###### Fonty
      titleFont = "Arial 14 bold"
      titleFontColor='#23238E'
      frameFont = "Arial 10 bold"
      frameFontColor='#cc0000' 
      objectFont = "Arial 8"
      objectFontColor='#000000'
      ###### Odsazen
      outerPadX=10
      outerPadY=10
      innerPadX=10
      innerPadY=10
      ###### Barvy
      masterColor='#f0f0f0'
      subColor='#f0f0f0'        
      
      ### Okno vodnho dialogu
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( windowWidth, windowHeight, (w-windowWidth)/2, (h-windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit ) #funkce pi zaven kkem     
      ### Rm titulku
      fTitle = LabelFrame(self.okno)
      fTitle.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      info= Label(fTitle , text=u'Mry variability\n pro kategorizovan promnn', bg=subColor, font = titleFont ,fg=titleFontColor)
      info.pack(side=LEFT)
      fTitle.pack(anchor=NW, expand=1, fill=X, padx=outerPadX, pady=0)
      ### Rm OptionButton
      self.vsechny = IntVar()
      self.vsechny.set(0)
      fOptionButton = LabelFrame(self.okno,text=u'Zpracovat')
      fOptionButton.config(relief=masterRelief,padx=innerPadX,pady=innerPadY,bg=subColor,font=frameFont,fg=frameFontColor,width=framewidth)
      OptionButton1=Radiobutton(fOptionButton, text=u'oznaen tabulky', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.vsechny, value=0)
      OptionButton1.select()
      OptionButton1.pack(anchor=W)
      OptionButton2=Radiobutton(fOptionButton, text=u'vechny tabulky etnost', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.vsechny, value=1)
      OptionButton2.pack(anchor=W)      
      fOptionButton.pack(anchor=W, padx=outerPadX, pady=outerPadY)
      ### Rm CheckButton
      self.v = IntVar()
      self.v.set(1)
      self.nomvar = IntVar()
      self.nomvar.set(1)
      self.norm_nomvar = IntVar()
      self.norm_nomvar.set(1)
      self.dorvar = IntVar()
      self.dorvar.set(1)
      self.norm_dorvar = IntVar()
      self.norm_dorvar.set(1)      
      fCheckButton = LabelFrame(self.okno,text=u'Spotat')
      fCheckButton.config(relief=masterRelief,padx=innerPadX,pady=innerPadY,bg=subColor,font=frameFont,fg=frameFontColor,width=framewidth)
      CheckButton1=Checkbutton(fCheckButton, text=u'varian pomr', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.v)
      CheckButton1.pack(anchor=W)
      CheckButton2=Checkbutton(fCheckButton, text=u'nominln variance', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.nomvar)
      CheckButton2.pack(anchor=W)
      CheckButton3=Checkbutton(fCheckButton, text=u'normovan nominln variance', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.norm_nomvar)
      CheckButton3.pack(anchor=W)
      CheckButton4=Checkbutton(fCheckButton, text=u'ordinln variance', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.dorvar)
      CheckButton4.pack(anchor=W)         
      CheckButton5=Checkbutton(fCheckButton, text=u'normovan ordinln variance', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.norm_dorvar)
      CheckButton5.pack(anchor=W)       
      fCheckButton.pack(anchor=W, padx=outerPadX, pady=outerPadY)      
      ### Rm NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      fNavButton.pack(anchor = SW, fill=X, expand=1, pady=0, padx=0)   
      ### Tlatka   
      Button(fNavButton, text="OK", command=self.callOkButton, width = 8).pack(side=LEFT, padx=5, pady=5)
      Button(fNavButton, text="Storno", command=self.callCancelButton, width = 8).pack(side=LEFT, padx=5, pady=5)
      ### Copyright
      cop = Label(fNavButton , text= u'Copyright ACREA CR', bg=subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)
      
      self.okno.mainloop()

   ### Funkce tlatka OK vetn naten slovnku
   def callOkButton(self): 
      """ Povoleni pokracovani skriptu. """          
      self.okno.quit()
      self.okno.destroy() 

   ### Funkce tlatka Cancel          
   def callCancelButton(self):
      """ Zruseni pokracovani skriptu. """
      self.okno.quit()
      exit()

class Warning:
   """ Trida pro zobrazeni chybovho hlaseni. """   
   # Parametry okna
   windowWidth=270
   windowHeight=95
   bgColor='#f0f0f0'
   # Parametry objekt
   ### fonty
   objectFont = "Arial 8"
   objectFontColor='#000000'
   ### odsazen
   outerPadX=10
   outerPadY=10
   ### barvy
   masterColor='#f0f0f0'
   subColor='#f0f0f0'
   # Text chybovho hlen
   hlaska = u"Nevhodn tabulka."

   def start(self): 
      """ Zobrazeni dialogu s popisem chyby. """
      # Okno s popisem chyby pi natn slovnku
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( self.windowWidth, self.windowHeight, (w-self.windowWidth)/2, (h-self.windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=self.bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit) #funkce pri zavreni krzkem 
      # Text chyboveho hlaseni
      hlaseni = Label(self.okno, font=self.objectFont, text=self.hlaska) 
      hlaseni.pack(padx=self.outerPadX, pady=self.outerPadY)
      # Ram NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=self.subColor)
      fNavButton.pack(anchor=SW, fill=X, expand=1, pady=0, padx=0)
      # Tlacitko OK
      Button(fNavButton, text="OK", command=self.callOkButton, width=8).pack(side=LEFT, padx=5, pady=5)             
      # Copyright
      cop= Label(fNavButton , text= u'Copyright ACREA CR', bg=self.subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)  
                  
      self.okno.mainloop()
      
   # Funkce tlacitka OK 
   def callOkButton(self):
      """ Potvrzeni dialogu. """          
      self.okno.quit() 
      
def create_table(objPivotTable,results,title,mira_v,mira_nomvar,mira_norm_nomvar,mira_dorvar,mira_norm_dorvar,caption):
   """ Uprava nove tabulku s vysledky. """ 
   bunky = [] #Seznam hodnot
   popisy = [] #Seznam radkovych popisu
   if mira_v == 1:
      bunky.append(results[0])
      popisy.append(u"Varian pomr")
   if mira_nomvar == 1:
      bunky.append(results[1])
      popisy.append(u"Nominln variance")
   if mira_norm_nomvar == 1:
      bunky.append(results[2])
      popisy.append(u"Norm. nominln variance")
   if mira_dorvar == 1:
      bunky.append(results[3])
      popisy.append(u"Ordinln variance")
   if mira_norm_dorvar == 1:
      bunky.append(results[4])
      popisy.append(u"Norm. ordinln variance")

   objRowLabels = objPivotTable.RowLabelArray()
   objColumnLabels = objPivotTable.ColumnLabelArray()
   objDataCells = objPivotTable.DataCellArray()

   #Pridani radku, v pripade potreby
   N = copy.deepcopy(objRowLabels.GetNumRows())
   for i in range(len(popisy)-N):
      objRowLabels.InsertNewAfter(N-1,1)

   #Zmena nazvu dimenze kvuli zobrazeni v okne Pivoting Trays
   objPivotManager = objPivotTable.PivotManager()
   for i in range(objPivotManager.GetNumColumnDimensions()):
      objColumnDim = objPivotManager.GetColumnDimension(i)
      if objColumnDim.GetDimensionName() == "Statistics":
         objColumnDim.SetDimensionName(u"Hodnota")
   objRowDim = objPivotManager.GetRowDimension(0)
   objRowDim.SetDimensionName(u"Mry variability")

   objPivotTable.SetCaptionText(caption)
     
   #Uprava struktury tabulky - odstraneni nepotrebnych radku a sloupcu
   #Maze ze zacatku tabulky kvuli korektnimu exportu tabulky a jejich car
   objPivotTable.ClearSelection()
   objRowLabels.SelectLabelAt(0,1)
   objPivotTable.Ungroup()
   if objRowLabels.GetValueAt(objRowLabels.GetNumRows()-2,1) == "Missing":
      objPivotTable.ClearSelection()
      objRowLabels.SelectLabelAt(objRowLabels.GetNumRows()-2,1)
      objPivotTable.Ungroup()
   if objRowLabels.GetNumColumns() > 2:
      #V pripade, ze tabulka je ve formatu legacy table a nema vynechane hodnoty 
      raise
   for j in range(objColumnLabels.GetNumColumns()):
      objColumnLabels.SetValueAt(1,j,"")
   for j in range(objColumnLabels.GetNumColumns()-1):
      objColumnLabels.HideLabelsWithDataAt(1,j)
   for i in range(objRowLabels.GetNumRows()):   
      objRowLabels.SetValueAt(i,1,"")
   for i in range(objRowLabels.GetNumRows()-len(popisy)):
      objRowLabels.HideLabelsWithDataAt(i,1)
   for i in range(objRowLabels.GetNumRows()-len(popisy)):   
      objDataCells.SetValueAt(i,objColumnLabels.GetNumColumns()-1,"")
   for i in range(objRowLabels.GetNumRows()):
      for j in range(objColumnLabels.GetNumColumns()-1):
         objDataCells.SetValueAt(i,j,"")

   #Vlozen novych hodnot
#   objPivotTable.SetCaptionText(caption)
   objPivotTable.SetTitleText(u"Mry variability - " + objPivotTable.GetTitleText())
   objColumnLabels.SetValueAt(1,objColumnLabels.GetNumColumns()-1,"Hodnota")
   for i in range(len(popisy)):
      objRowLabels.SetValueAt(objRowLabels.GetNumRows()-len(popisy)+i,1,popisy[i])
      if objDataCells.GetValueAt(objRowLabels.GetNumRows()-len(popisy)+i,objColumnLabels.GetNumColumns()-1) == "":
         objDataCells.SetValueAt(objRowLabels.GetNumRows()-len(popisy)+i,objColumnLabels.GetNumColumns()-1,str(0))
      objDataCells.SetValueAt(objRowLabels.GetNumRows()-len(popisy)+i,objColumnLabels.GetNumColumns()-1,str(bunky[i]))         
      objDataCells.SetHDecDigitsAt(objRowLabels.GetNumRows()-len(popisy)+i,objColumnLabels.GetNumColumns()-1,3)
   objRowLabels.SetRowLabelWidthAt(0,1,123)

def compute_measures(objPivotTable,hodnoty,title,mira_v,mira_nomvar,mira_norm_nomvar,mira_dorvar,mira_norm_dorvar):
   """ Vypocet mer variability."""
   #Pro nominalni promenne
   cetnosti = hodnoty[0][:len(hodnoty[2])]
   K = len(cetnosti[:-1]) #Pocet kategorii
   n = cetnosti[-1]  #Pocet platnych pripadu
   n_mod = max(cetnosti[:-1]) #Cetnost modalni kategorie
   v = 1 - n_mod / n #Variancni pomer
   f = [] #Relativni cetnosti
   F = [] #Kumulativni relativni cetnosti
   kum_sum_f2 = 0
   kum_sum_f = 0
   kum_sum_FJednaMinusF = 0
   for i in range(K):
      f.append(cetnosti[i]/n)
      kum_sum_f2 = kum_sum_f2 + f[i]*f[i]
      kum_sum_f = kum_sum_f + f[i]
      F.append(kum_sum_f)
      kum_sum_FJednaMinusF = kum_sum_FJednaMinusF + F[i]*(1 - F[i])
   nomvar = 1 - kum_sum_f2
   norm_nomvar = K * nomvar / (K - 1) 
   #Pro ordinalni promenne
   dorvar = 2 * kum_sum_FJednaMinusF
   norm_dorvar = 2 * dorvar / (K - 1)

   results = []
   results.append(v)
   results.append(nomvar)
   results.append(norm_nomvar)
   results.append(dorvar)
   results.append(norm_dorvar)
   #Debug
   for i in range(len(cetnosti[:-1])):
      cetnosti[i] = str(cetnosti[i]).replace(".",",")
   caption = u"etnosti vstupujc do vpotu: %s \\nPoet platnch ppad: %s" % (" ".join(cetnosti[:-1]),str(n).replace(".",","))
   #Uprava nove tabulky s vysledky
   create_table(objPivotTable,results,title,mira_v,mira_nomvar,mira_norm_nomvar,mira_dorvar,mira_norm_dorvar,caption)

def read_values(objPivotTable,mira_v,mira_nomvar,mira_norm_nomvar,mira_dorvar,mira_norm_dorvar):
   """ Nacteni hodnot z puvodni tabulky cetnosti. """
   title = objPivotTable.GetTitleText()
   objRowLabels = objPivotTable.RowLabelArray()
   objColumnLabels = objPivotTable.ColumnLabelArray()
   objDataCells = objPivotTable.DataCellArray()
   hodnoty = []
   sloupec = []
   for j in range(objDataCells.GetNumColumns()):
      for i in range(objDataCells.GetNumRows()):
         try:            
            sloupec.append(float(objDataCells.GetUnformattedValueAt(i,j)))
         except:
            pass
      hodnoty.append(sloupec)
      sloupec = [] 
   compute_measures(objPivotTable,hodnoty,title,mira_v,mira_nomvar,mira_norm_nomvar,mira_dorvar,mira_norm_dorvar)

def main():
   """ Hlavni ridici procedura volajici dalsi procedury. """   
   objScriptContext = SpssClient.GetScriptContext()
   if objScriptContext == None:
      uvod = Dialog()
      uvod.start()
      vsechny = uvod.vsechny.get()
      mira_v = uvod.v.get()
      mira_nomvar = uvod.nomvar.get()
      mira_norm_nomvar = uvod.norm_nomvar.get()
      mira_dorvar = uvod.dorvar.get()
      mira_norm_dorvar = uvod.norm_dorvar.get()
      if (mira_v==1 or mira_nomvar==1 or mira_norm_nomvar==1 or mira_dorvar==1 or mira_norm_dorvar==1):
         objOutputDoc = SpssClient.GetDesignatedOutputDoc()
         objOutputItems = objOutputDoc.GetOutputItems()
         pocet = 0
         if vsechny == 1:
            index = 0
            pocet_chybnych = 0
            pocet_objektu = objOutputItems.Size()
            while index < pocet_objektu:
               objOutputItem = objOutputItems.GetItemAt(index)
               if objOutputItem.GetType() == SpssClient.OutputItemType.PIVOT \
                  and objOutputItem.GetSubType() == "Frequencies":
                     objOutputItem = objOutputItems.GetItemAt(index)           
                     objOutputDoc.ClearSelection()                     
                     objOutputItem.SetSelected(True)
                     objOutputItem.SetCurrentItem()
                     objOutputDoc.Copy()
                     objOutputDoc.PasteBefore()
                     objOutputItem.SetSubType("Measures of variability")
                     objOutputItem.SetVisible(False)
                     objPivotTable = objOutputItem.GetSpecificType()
                     objPivotTable.SetUpdateScreen(False)
                     try:
                        read_values(objPivotTable,mira_v,mira_nomvar,mira_norm_nomvar,mira_dorvar,mira_norm_dorvar)
                        objPivotTable.SetUpdateScreen(True)
                        objOutputItem.SetVisible(True)
                        pocet_objektu = pocet_objektu + 1                     
                        pocet = pocet + 1
                     except:
                        objOutputDoc.ClearSelection()
                        objOutputItem.SetSelected(True)
                        objOutputDoc.Delete()
                        pocet_chybnych += 1                       
                     index += 1
               index = index + 1         
            if pocet_chybnych > 0:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 220
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Ve skriptu dolo k chyb. Tabulka nejsp\nnebyla v novjm formtu." 
               chyba_tabulka.start() 
            elif pocet == 0:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 220
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Nebyla nalezena dn tabulka etnost \nvytvoen procedurou Frequencies." 
               chyba_tabulka.start()               
         else:
            citac = 0
            pocet_chybnych = 0
            selected = [] #Seznam znacenych tabulek
            for index in range(objOutputItems.Size()):
               objOutputItem = objOutputItems.GetItemAt(index)
               if objOutputItem.GetType() == SpssClient.OutputItemType.PIVOT \
                  and objOutputItem.GetSubType() == "Frequencies" \
                     and objOutputItem.IsSelected():
                        selected.append(index)
            for index in selected:            
               objOutputItem = objOutputItems.GetItemAt(index+citac)           
               objOutputDoc.ClearSelection()
               objOutputItem.SetSelected(True)
               objOutputItem.SetCurrentItem()
               objOutputDoc.Copy()
               objOutputDoc.PasteBefore()
               citac = citac + 1
               pocet = pocet + 1 
               objOutputItem.SetSubType("Measures of variability")
               objOutputItem.SetVisible(False)
               objPivotTable = objOutputItem.GetSpecificType()
               objPivotTable.SetUpdateScreen(False)
               try:
                  read_values(objPivotTable,mira_v,mira_nomvar,mira_norm_nomvar,mira_dorvar,mira_norm_dorvar)
                  objPivotTable.SetUpdateScreen(True)
                  objOutputItem.SetVisible(True)                  
               except:
                  objOutputDoc.ClearSelection()
                  objOutputItem.SetSelected(True)
                  objOutputDoc.Delete()
                  citac = citac - 1
                  pocet = pocet - 1
                  pocet_chybnych += 1                  
            if pocet_chybnych > 0:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 220
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Ve skriptu dolo k chyb. Tabulka nejsp\nnebyla v novjm formtu." 
               chyba_tabulka.start()
            elif pocet == 0:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 310
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Nebyla vybrna pivotn tabulka nebo nejde o tabulku etnost \nvytvoenou procedurou Frequencies." 
               chyba_tabulka.start()                            
      else:
         chyba_tabulka = Warning()
         chyba_tabulka.windowWidth = 250
         chyba_tabulka.windowHeight = 80
         chyba_tabulka.hlaska = u"Nebyl zvolen vpoet dn mry variability." 
         chyba_tabulka.start()          
   else:
      mira_v = 1
      mira_nomvar = 1
      mira_norm_nomvar = 1
      mira_dorvar = 1
      mira_norm_dorvar = 1
      objOutputDoc = objScriptContext.GetOutputDoc()
      objOutputItem = objScriptContext.GetOutputItem()
      if objOutputItem.GetType() == SpssClient.OutputItemType.PIVOT \
         and objOutputItem.GetSubType() == "Frequencies":
            objOutputDoc.ClearSelection()
            objOutputItem.SetSelected(True)
            objOutputItem.SetCurrentItem()
            objOutputDoc.Copy()
            objOutputDoc.PasteBefore()
            objOutputItem.SetSubType("Measures of variability")
            objOutputItem.SetVisible(False)         
            objPivotTable = objOutputItem.GetSpecificType()
            objPivotTable.SetUpdateScreen(False)
            try:
               read_values(objPivotTable,mira_v,mira_nomvar,mira_norm_nomvar,mira_dorvar,mira_norm_dorvar)
            except:
               objOutputDoc.ClearSelection()
               objOutputItem.SetSelected(True)
               objOutputDoc.Delete()
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 220
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Ve skriptu dolo k chyb. Tabulka nejsp\nnebyla v novjm formtu." 
               chyba_tabulka.start()
            objPivotTable.Autofit()   
            objPivotTable.SetUpdateScreen(True)
            objOutputItem.SetVisible(True)            
  
try:
   SpssClient.StartClient()
   main()
except:
   pass
finally:
   SpssClient.StopClient()
   

