# -*- coding: iso8859-2 -*-

"""
POPIS SKRIPTU
Ped sputnm je teba oznait ve vstupu tabulku,
kter je vstupem procedury Descriptives.
Skript dopln sloupce s 95%-nmi intervaly spolehlivosti
pro prmr zkladnho souboru (Mean),
pedpokladem je normln rozdlen promnnch.

Verze pro Statistics 22 a tabulky v novjm formtu.

Verze:
   1.0 Skript od Radky varcov
   1.1 Oprava pro standardn chybu prmru v tabulce

"""

__author__  = 'Radka varcov rsvarcova@acrea.cz'
__version__ = '1.1'
__date__ = '5.5.2014'


from tkinter import *
import SpssClient
import sys

class Warning:
   """ Trida pro zobrazeni chybovho hlaseni. """   
   # Parametry okna
   windowWidth=270 
   windowHeight=95
   bgColor='#f0f0f0'
   # Parametry objekt
   ### fonty
   objectFont = "Arial 8"
   objectFontColor='#000000'
   ### odsazen
   outerPadX=10
   outerPadY=10
   ### barvy
   masterColor='#f0f0f0'
   subColor='#f0f0f0'
   # Text chybovho hlen
   hlaska = u"Nevhodn tabulka."

   def start(self): 
      """ Zobrazeni dialogu s popisem chyby. """
      # Okno s popisem chyby pi natn slovnku
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( self.windowWidth, self.windowHeight, (w-self.windowWidth)/2, (h-self.windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=self.bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit) #funkce pri zavreni krzkem 
      # Text chyboveho hlaseni
      hlaseni = Label(self.okno, font=self.objectFont, text=self.hlaska) 
      hlaseni.pack(padx=self.outerPadX, pady=self.outerPadY)
      # Ram NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=self.subColor)
      fNavButton.pack(anchor=SW, fill=X, expand=1, pady=0, padx=0)
      # Tlacitko OK
      Button(fNavButton, text="OK", command=self.callOkButton, width=8).pack(side=LEFT, padx=5, pady=5)             
      # Copyright
      cop= Label(fNavButton , text= u'Copyright ACREA CR', bg=self.subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)  
                  
      self.okno.mainloop()
      
   # Funkce tlacitka OK 
   def callOkButton(self):
      """ Potvrzeni dialogu. """          
      self.okno.quit()

class Dialog:
   """ Trida pro zobrazeni uvodniho dialogu. """
   def start(self):
      ### Parametry okna
      windowWidth=333
      windowHeight=180
      bgColor='#f0f0f0'     
      ### Parametry objekt
      ###### Ohranien
      masterRelief=GROOVE
      framewidth=200     
      ###### Fonty
      titleFont = "Arial 14 bold"
      titleFontColor='#23238E'
      frameFont = "Arial 10 bold"
      frameFontColor='#cc0000' 
      objectFont = "Arial 8"
      objectFontColor='#000000'
      ###### Odsazen
      outerPadX=10
      outerPadY=10
      innerPadX=10
      innerPadY=10
      ###### Barvy
      masterColor='#f0f0f0'
      subColor='#f0f0f0'        

      ### Okno vodnho dialogu
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( windowWidth, windowHeight, (w-windowWidth)/2, (h-windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit) #funkce pi zaven kkem
      ### Rm titulku
      fTitle = LabelFrame(self.okno)
      fTitle.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      info= Label(fTitle , text=u'Interval spolehlivosti pro prmr', bg=subColor, font = titleFont ,fg=titleFontColor)
      info.pack(side=LEFT)
      fTitle.pack(anchor=NW, expand=1, fill=X, padx=outerPadX, pady=0)
      ### Rm OptionButton
      self.Alpha = IntVar()
      self.Alpha.set(0)
      fOptionButton = LabelFrame(self.okno,text=u'Spolehlivost (pravdpodobnostn hladina)')
      fOptionButton.config(relief=masterRelief,padx=innerPadX,pady=innerPadY,bg=subColor,font=frameFont,fg=frameFontColor,width=framewidth)
      OptionButton1=Radiobutton(fOptionButton, text=u'95% (0.05)', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.Alpha, value=1)
      OptionButton1.select()
      OptionButton1.pack(anchor=W)
      OptionButton2=Radiobutton(fOptionButton, text=u'99% (0.01)', bg=subColor, font=objectFont, fg=objectFontColor, variable=self.Alpha, value=0)
      OptionButton2.pack(anchor=W)      
      fOptionButton.pack(anchor=W, padx=outerPadX, pady=outerPadY)    
      ### Rm NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      fNavButton.pack(anchor = SW, fill=X, expand=1, pady=0, padx=0)   
      ### Tlatka   
      Button(fNavButton, text="OK", command=self.callOkButton, width = 8).pack(side=LEFT, padx=5, pady=5)
      Button(fNavButton, text="Storno", command=self.callCancelButton, width = 8).pack(side=LEFT, padx=5, pady=5)
      ### Copyright
      cop = Label(fNavButton , text= u'Copyright ACREA CR', bg=subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)
      
      self.okno.mainloop()

   ### Funkce tlatka OK vetn naten slovnku
   def callOkButton(self): 
      """ Povoleni pokracovani skriptu. """          
      self.okno.quit()
      self.okno.destroy() 

   ### Funkce tlatka Cancel          
   def callCancelButton(self):
      """ Zruseni pokracovani skriptu. """
      self.okno.quit()
      exit()

# funkce pro vpoet interval spolehlivosti
# doln mez intervalu spolehlivosti
def Lower (N,XAVG,SD,Z):      
   SE = SD/(N**(0.5))
   L = XAVG-SE*Z
   return L

# horn mez intervalu spolehlivosti
def Upper (N,XAVG,SD,Z):      
   SE = SD/(N**(0.5))
   L = XAVG+SE*Z
   return L

# hlavn vpoet
def main():
   uvod = Dialog()
   uvod.start()
   Alpha = uvod.Alpha.get()
   if Alpha == 1:
      alfa=0.05
      Z=1.95996
   if Alpha == 0:
      alfa=0.01
      Z=2.57583

   # piazen aktivnho vstupovho okna a jeho obsahu
   objOutputDoc = SpssClient.GetDesignatedOutputDoc()

   # indiktor, zda byla vybrna vstupn tabulka z procedury Descriptives 
   TableCorrect = 0

   # piazen oznaen vstupn tabulky
   objOutputItem = objOutputDoc.GetCurrentItem()
   if objOutputItem.GetType() == SpssClient.OutputItemType.PIVOT \
      and objOutputItem.GetSubType() == "Descriptive Statistics":
         objPivotTable = objOutputItem.GetSpecificType()
         TableCorrect = 1

   # pokud je tabulka vybrna korektn
   if TableCorrect == 1:
   
      # vypnut okamitho provdn zmn
      objOutputItem.SetVisible(False)  
      objPivotTable.SetUpdateScreen(False)

      # piazen objekt pivotn tabulky
      objDataCells = objPivotTable.DataCellArray()
      objColLabels = objPivotTable.ColumnLabelArray()
      objRowLabels = objPivotTable.RowLabelArray()
      RowNum = objDataCells.GetNumRows()
      ColumnNum = objDataCells.GetNumColumns()

      # piazen a oven existence dleitch sloupc
      ColumnsCorrect = 0
      Columns = [] 
      for C in range (ColumnNum):
            try:		
               Columns.append(objColLabels.GetValueAt(1,C))
            except:
               Columns.append("")
      ColumnN = -1 # poradi sloupce s N
      ColumnMean = -1 # poradi sloupce s Mean
      ColumnStdDev = -1 # poradi sloupce s Std Deviation
      for C in range (ColumnNum):
         if Columns [C] == "Mean" and ColumnMean == -1:
           ColumnMean = C  
         if Columns [C] == "N":
            ColumnN = C   
         if Columns [C] == "Std. Deviation":
           ColumnStdDev = C
      if ((ColumnN > -1) and  (ColumnMean > -1) and (ColumnStdDev > -1)):
        ColumnsCorrect = 1

      if ColumnsCorrect == 1:
         
         # natn hodnot z tabulky
         Value = []   # jednorozmrn pole
         for C in range (ColumnNum):
            for R in range (RowNum):
               try:		
                  Value.append(float(objDataCells.GetUnformattedValueAt(R,C)))
               except:
                  Value.append("")         

         # vpoet doln a horn meze interval spolehlivosti
         Sloupec_L = []
         Sloupec_U = []
         RowCalc = RowNum-1	# poet dk pro vpoet
         for i in range (RowCalc):
           N=Value[ColumnN*RowNum+i]
           XAVG=Value[ColumnMean*RowNum+i]
           SD=(Value[ColumnStdDev*RowNum+i])
           Low=Lower(N,XAVG,SD,Z)
           Upp=Upper(N,XAVG,SD,Z)		     
           Sloupec_L.append(Low)
           Sloupec_U.append(Upp)
      
         # vloen hodnot do tabulky
         ColumnLabelsNum = objColLabels.GetNumRows()
         if ColumnLabelsNum == 4:
            korekce = 1    # dvojit sloupce
         else:
            korekce = 0   
         objColLabels.InsertNewAfter(1,ColumnNum-1)
         objColLabels.InsertNewAfter(1,ColumnNum-1)
         objColLabels.SetValueAt(1,ColumnNum,"Lower Bound")
         objColLabels.SetValueAt(1,ColumnNum+1+korekce,"Upper Bound")
   
         for i in range (RowCalc):
##           if objDataCells.GetValueAt(i,ColumnNum) == "":
##              objDataCells.SetValueAt(i,ColumnNum,str(0))
##           if objDataCells.GetValueAt(i,ColumnNum+1+korekce) == "":
##              objDataCells.SetValueAt(i,ColumnNum+1+korekce,str(0))
           objDataCells.SetValueAt(i,ColumnNum,str(Sloupec_L[i]))
           objDataCells.SetValueAt(i,ColumnNum+1+korekce,str(Sloupec_U[i]))
           objDataCells.SetNumericFormatAtWithDecimal(i,ColumnNum,"#.#",2)
           objDataCells.SetNumericFormatAtWithDecimal(i,ColumnNum+1+korekce,"#.#",2)

         #vbr sloupc s limity intervalu
         objPivotTable.ClearSelection()
         objColLabels.SelectLabelAt(1,ColumnNum)
         objColLabels.SelectLabelAt(1,ColumnNum+1+korekce)
         #jejich slouen nadzenm nadpisem
         objPivotTable.Group()
         objPivotTable.SetUpdateScreen(True)         
         objColLabels.SetValueAt(1,ColumnNum,str((1-alfa)*100).replace(".",",").replace(",0","")+"% Confid. Interval for Mean")
         if korekce == 1:
            for i in range (0,RowNum-1):
               objDataCells.SetValueAt(i,ColumnNum+1,"")
               objDataCells.SetValueAt(i,ColumnNum+3,"")
         # zapnut okamitho provdn zmn
         objPivotTable.Autofit()       
         objOutputItem.SetVisible(True)
      
      else:
         objOutputItem.SetVisible(True)
         chyba_tabulka = Warning()
         chyba_tabulka.windowWidth = 220
         chyba_tabulka.windowHeight = 110
         chyba_tabulka.hlaska = u"Nen oznaena vhodn pivotn tabulka.\nVyberte vstupn tabulku procedury \nDescriptives s N, Mean a Std.Deviation." 
         chyba_tabulka.start()   
   else:
      chyba_tabulka = Warning()
      chyba_tabulka.windowWidth = 220
      chyba_tabulka.windowHeight = 110
      chyba_tabulka.hlaska = u"Nen oznaena vhodn pivotn tabulka.\nVyberte vstupn tabulku procedury \nDescriptives a spuste skript znovu." 
      chyba_tabulka.start()

try:
   SpssClient.StartClient()
   main()
except:
   pass
finally:
   SpssClient.StopClient()   


    

