# -*- coding: iso8859-2 -*-

"""
POPIS SKRIPTU:
Ped sputnm je teba oznait ve vstupu tabulku etnost,
kter je vstupem procedury Frequencies.
Skript tabulku okopruje a dopln
95%'intervaly spolehlivosti pro procentuln etnosti.

Pro vpoet interval spolehlivosti je uita asymptotick metoda,
kter pedpokld, e poet pozorovn je vt ne 30
a v kad kategorii se vyskytuje alespo 5 ppad.

Verze pro Statistics 21 a tabulky v novjm formtu.
"""
__author__  = 'Lubomira Cervova  lcervova@acrea.cz'
__version__ = '1.0'
__date__ = '30.7.2008'

import string
import SpssClient
import sys

# chybov hlen
from tkinter import *
class Warning:
   # Parametry objekt
   # fonty
   objectFont = "Arial 8"
   objectFontColor='#000000'

   # odsazen
   outerPadX=10
   outerPadY=10

   # barvy
   masterColor='#f0f0f0'
   subColor='#f0f0f0'
   bgColor='#f0f0f0'

   textHlaseni = u"Nebyla oznaena vhodn pivotn tabulka.\nVyberte tabulku, kter je vstupem procedury Frequencies, \nobsahuje etnosti a m alespo dva platn dky."

   def start(self):
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d" % ( self.windowWidth, self.windowHeight, (w-self.windowWidth)/2, (h-self.windowHeight)/2 ) ) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=self.bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit) #funkce pi zaven kkem 

      hlaseni = Label(self.okno, font=self.objectFont, text=self.textHlaseni)     
      hlaseni.pack(padx=self.outerPadX, pady=self.outerPadY)

      # rm NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=self.subColor)
      fNavButton.pack(anchor = SW, fill=X, expand=1, pady=0, padx=0)

      # tlatko OK
      Button(fNavButton, text="OK", command=self.callOkButton, width=8).pack(side=LEFT, padx=5, pady=5)
      # copyright
      cop= Label(fNavButton, text= u'Copyright ACREA CR', bg=self.subColor, font = "Arial 8 italic" ,fg='#000000')
      cop.pack(side=RIGHT)

      self.okno.mainloop()

   def callOkButton(self):
       SpssClient.StopClient()
       self.okno.quit()

# vpoet interval spolehlivosti
def Lower (N,F):      # doln mez intervalu spolehlivosti
   Z = 1.96 
   S=(F*(1-F)/N)**(0.5)

   if (F-Z*S)>0:
      L = float(str((F-Z*S)*100).replace(",","."))
   else:
      L = 0.0
   return L

def Upper (N,F):      # horn mez intervalu spolehlivosti
   Z = 1.96 
   S=(F*(1-F)/N)**(0.5)

   if (F+Z*S)<1:
      U = float(str((F+Z*S)*100).replace(",","."))
   else:
      U = 100.0
   return U

def main():
   # piazen aktivnho vstupovho okna a jeho obsahu
   objOutputDoc = SpssClient.GetDesignatedOutputDoc()

   # pomocn promnn - indiktor zda byla vybrna vhodn pivotn tabulka
   selected = 0

   # nalezen oznaen pivotn tabulky
   objOutputItem = objOutputDoc.GetCurrentItem()
   if objOutputItem.GetType() == SpssClient.OutputItemType.PIVOT \
      and objOutputItem.GetSubType() == "Frequencies":
         objPivotTable = objOutputItem.GetSpecificType()
         selected = 1

   intRow = 0
   intCol = 0
   # pokud je nalezena oznaen pivotn tabulka z procedury Frequencies 
   if selected == 1:     

      # piazen objekt star pivotn tabulky
      objDataCells = objPivotTable.DataCellArray()
      objColLabels = objPivotTable.ColumnLabelArray()
      objRowLabels = objPivotTable.RowLabelArray()

      # poet dk a sloupc tabulky
      intRow = objDataCells.GetNumRows()
      intCol = objDataCells.GetNumColumns()

   # pokud je nalezena oznaen pivotn tabulka z procedury Frequencies, m alespo dva dky a tyi sloupce 
   if (selected == 1 and intRow > 1 and intCol == 4):

      # kopie pvodn tabulky
      objOutputDoc.ClearSelection()
      objOutputItem.SetSelected(True)
      objOutputDoc.Copy()
      objOutputDoc.PasteBefore()
      objOutputItem.SetVisible(False)

      # vypnut okamitho provdn zmn
      objPivotTable.SetUpdateScreen(False)

      # nadpis tabulky
      if objPivotTable.GetTitleText()== "":
         nadpis = "Tabulka etnost s 95% intervaly spolehlivosti"
      else:
         nadpis = u"Tabulka etnost s 95% intervaly spolehlivosti pro promnnou " + objPivotTable.GetTitleText()
          
      # natn hodnot ze star tabulky
      Value = []		         # naten hodnota z tabulky (buka o danch souadnicch)  
       
      for intC in range (0,4):
         for intR in range (0,intRow):
            try:		
               Value.append(float(objDataCells.GetUnformattedValueAt(intR,intC)))
            except:
               Value.append("")         

      # vpoet intGroupSize a intTotalPos   (rozliuj, zda jsou v tabulce chybjc hodnoty nebo ne...)
      for i in range (0,intRow):
         if (objRowLabels.GetValueAt(i,1) != u"Valid") or (i==intRow-1):
            intGroupSize = i
            break
      if intGroupSize < (intRow - 1):
         intTotalPos = intGroupSize - 1
      else:
         intTotalPos = intGroupSize
                  
      # vpoet doln a horn meze intervalu spolehlivosti pro Relativn etnost
      Sloupec_2 = []
      Sloupec_3 = []
      N = Value[intRow-1]	# nate celkov poet ppad
      for intR in range (0,intRow-1):
         F=Value[intR+intRow]/100		# nate hodnotu z buky jako desetinn msto
         Low=Lower(N,F)    	        # vol Lower s danmi paramtetry
         Upp=Upper(N,F)		        # vol Upper s danmi paramtetry
         Sloupec_2.append(Low)
         Sloupec_3.append(Upp)
               
      Sloupec_2.append("")		# przdn buky
      Sloupec_3.append("")		# przdn buky
      
      # vpoet doln a horn meze intervalu spolehlivosti pro Relativn etnost platnch hodnot
      N = Value[intTotalPos]	  # nate celkov poet platnch ppad
      Sloupec_5 = []
      Sloupec_6 = []
      for intR in range (0,intTotalPos):
         F=Value[intR+2*intRow]/100             # nate hodnotu z buky jako desetinn msto
         Low=Lower(N,F)    	             # vol Lower s danmi paramtetry
         Upp=Upper(N,F)                         # vol Upper s danmi paramtetry
         Sloupec_5.append(Low)
         Sloupec_6.append(Upp)
                     
      for intR in range (intTotalPos,intRow):
         Sloupec_5.append("")
         Sloupec_6.append("")
      
      # vpoet doln a horn meze intervalu spolehlivosti pro Relativn kumulativn etnost
      Sloupec_8 = []
      Sloupec_9 = []
      for intR in range (0,intTotalPos-1):
         F=Value[intR+3*intRow]/100
         Low=Lower(N,F)    	             # vol Lower s danmi parametry
         Upp=Upper(N,F)                         # vol Upper s danmi parametry	
         Sloupec_8.append(Low)
         Sloupec_9.append(Upp)
         
      for intR in range (intTotalPos-1,intRow):
         Sloupec_8.append("")
         Sloupec_9.append("")
       
      # poet dk a sloupc nov tabulky
      R=intRow
      C=10

      # nadpis tabulky
      objPivotTable.SetTitleText(nadpis)
      poznamka = u"K vpotu 95% interval spolehlivosti byla uita asymptotick metoda, kter pedpokld, e poet pozorovn je vt ne 30 a v kad kategorii se vyskytuje alespo 5 ppad."
      objPivotTable.SetCaptionText(poznamka)

      # dkov popisy - peklad
      for i in range(objRowLabels.GetNumRows()):
         for j in range(objRowLabels.GetNumColumns()):
            if objRowLabels.GetValueAt(i,j) == "Valid":
               objRowLabels.SetValueAt(i,j,u"Platn")
            elif objRowLabels.GetValueAt(i,j) == "Total":   
               objRowLabels.SetValueAt(i,j,u"Celkem")
            elif objRowLabels.GetValueAt(i,j) == "Missing":   
               objRowLabels.SetValueAt(i,j,u"Chybjc") 

      # vloen pomocnho novho dku - een problmu se znamnky + a nslednou chybou pi zmn formtu   
      objRowLabels.InsertNewBefore(0,1)
      # vloen novch sloupc - zprava doleva
      objColLabels.InsertNewAfter(1,3)
      objColLabels.InsertNewAfter(1,3)
      objColLabels.InsertNewAfter(1,2)
      objColLabels.InsertNewAfter(1,2)
      objColLabels.InsertNewAfter(1,1)
      objColLabels.InsertNewAfter(1,1)  
      
      # sloupcov popisy
      columnlabels = [u"etnost",u"Relativn etnost",u"Doln mez",u"Horn mez",u"Relativn etnost platnch hodnot",u"Doln mez",u"Horn mez",u"Relativn kumulativn etnost",u"Doln mez",u"Horn mez"]
      for j in range(C):
         objColLabels.SetValueAt(1,j,columnlabels[j])

      data = []                  # seznam dat po dcch
      for j in range(C):
         data.append(u"")
      for i in range(0,intRow):
         data.append(Value[0+i])
         data.append(Value[intRow+i])
         data.append(Sloupec_2[i])
         data.append(Sloupec_3[i])
         data.append(Value[intRow*2+i])
         data.append(Sloupec_5[i])
         data.append(Sloupec_6[i])
         data.append(Value[intRow*3+i])
         data.append(Sloupec_8[i])
         data.append(Sloupec_9[i])

      # vymazn hodnot pomocnho prvnho dku a nsledn skryt tohoto dku, pokud sele, znamen to, e tabulka je ve starm formtu
      try:
         for j in range(C):
            objDataCells.SetValueAt(0,j,"")
         objRowLabels.HideLabelsWithDataAt(0,2)
      except:
         objOutputDoc.ClearSelection()
         objOutputItem.SetSelected(True)
         objOutputDoc.Delete()
         chyba_tabulka = Warning()
         chyba_tabulka.windowWidth = 250
         chyba_tabulka.windowHeight = 110
         chyba_tabulka.textHlaseni = u"Tabulka nen ve sprvnm formtu. \nZmte nastaven SPSS Statistics na novj \nformt tabulek a vytvote tabulku znovu."
         chyba_tabulka.start()
         sys.exit()

      # vloen hodnot a nastaven formt
      k = 0
      for i in range(R+1):
         for j in range(C):
            objDataCells.SetValueAt(i,j,str(0))
            objDataCells.SetValueAt(i,j,str(data[k]))
            k += 1
            if j == 0:
               objDataCells.SetHDecDigitsAt(i,j,0)
            else:   
               objDataCells.SetNumericFormatAtWithDecimal(i,j,"##.#%",1)

      # formtovn dk s celkovmi hodnotami
      if intTotalPos != intGroupSize:  # dek celkem pro platn hodnoty
         objRowLabels.SetTextStyleAt(intTotalPos+1,2,SpssClient.SpssTextStyleTypes.SpssTSBoldItalic)
         for j in range (intCol+1):
            try:
              objDataCells.SetTextStyleAt(intTotalPos+1,j,SpssClient.SpssTextStyleTypes.SpssTSBoldItalic)
            except:
              pass
      objRowLabels.SetTextStyleAt(intRow,2,SpssClient.SpssTextStyleTypes.SpssTSBoldItalic) # dek celkem pro vechny hodnoty
      for j in range (10):
         try:
           objDataCells.SetTextStyleAt(intRow,j,SpssClient.SpssTextStyleTypes.SpssTSBoldItalic)
         except:
           pass      

      # zapnut okamitho provdn zmn       
      objPivotTable.SetUpdateScreen(True)

      # vypnut okamitho provdn zmn
      objPivotTable.SetUpdateScreen(False)

      # barven sloupc
      objColLabels.SetBackgroundColorAt(1,0,204 + 255*256 + 204*256**2)
      for intC in range(1,4):
         objColLabels.SetBackgroundColorAt(1,intC,255 + 204*256 + 204*256**2)   
      for intC in range(4,7):
         objColLabels.SetBackgroundColorAt(1,intC,250 + 255*256 + 175*256**2)      
      for intC in range(7,10):
         objColLabels.SetBackgroundColorAt(1,intC,204 + 204*256 + 255*256**2) 

      # zapnut okamitho provdn zmn
      objPivotTable.Autofit()
      objColLabels.SetColumnLabelWidthAt(1,4,82) # nastaven ky sloupcu pro popisy
      objColLabels.SetColumnLabelWidthAt(1,7,93) # nastaven ky sloupcu pro popisy
      objPivotTable.SetUpdateScreen(True)
      objOutputItem.SetVisible(True)
   else:
      chyba_tabulka = Warning()
      chyba_tabulka.windowWidth = 310
      chyba_tabulka.windowHeight = 110
      chyba_tabulka.textHlaseni = u"Nebyla oznaena vhodn pivotn tabulka.\nVyberte tabulku, kter je vstupem procedury Frequencies, \nobsahuje etnosti a m alespo dva platn dky."
      chyba_tabulka.start() 
       
try:
   SpssClient.StartClient()
   main()
except:
   pass
finally:
   SpssClient.StopClient()
