# -*- coding: iso8859-2 -*-

"""
Skript zjednodu a uprav tabulku vytvoenou procedurou Independent-Samples T Test.
Je zen vodnm dialogem.

Ped sputnm skriptu je nutn vybrat v zamenm vstupnm okn tabulku
Independent Samples Test.

Skriptem je mon zpracovat i vce vybranch tabulek. Nelze vak zpracovat
tabulku, pokud je zapnut funkce Split File - Compare Groups.
"""
__author__  = 'Ondej Brom  obrom@acrea.cz'
__version__ = '2.0'
__date__ = '15.7.2011'

from tkinter import*
import SpssClient
import sys

# Parametry skriptu
Fsign=0.05
Tsign1=0.05
Tsign2=0.01
Tsign3=0.001
sign=0
sort=0
howtosort=0
color=0
scientific=0
trans=0

# Tda pro chybov hlen
class Warning:
   """Trida pro zobrazeni chyboveho hlaseni."""      
   # Parametry okna
   windowWidth=270
   windowHeight=90
   bgColor='#f0f0f0'
   # Parametry objekt
   ### fonty
   objectFont = "Arial 8"
   objectFontColor='#000000'
   ### odsazen
   outerPadX=10
   outerPadY=10
   ### barvy
   masterColor='#f0f0f0'
   subColor='#f0f0f0'
   # Text chybovho hlen
   hlaska = u"Nevhodn tabulka."

   def start(self): 
      """ Zobrazeni dialogu s popisem chyby. """
      # Okno s popisem chyby pi natn slovnku
      self.okno = Tk()
      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      self.okno.geometry("%dx%d+%d+%d"%(self.windowWidth,self.windowHeight,(w-self.windowWidth)/2,(h-self.windowHeight)/2)) #okno uprosted obrazovky
      self.okno.title('ACREA CR')
      self.okno.config(bg=self.bgColor)
      self.okno.resizable(0,0)
      self.okno.protocol('WM_DELETE_WINDOW',sys.exit) #funkce pi zaven kkem 
      # Text chybovho hlen
      hlaseni=Label(self.okno,font=self.objectFont,text=self.hlaska) 
      hlaseni.pack(padx=self.outerPadX, pady=self.outerPadY)
      # Rm NavButton
      fNavButton = LabelFrame(self.okno)
      fNavButton.config(relief=FLAT,padx=0,pady=0,bg=self.subColor)
      fNavButton.pack(anchor=SW,fill=X, expand=1, pady=0, padx=0)
      # Tlatko OK
      Button(fNavButton, text="OK", command=self.callOkButton,width=8).pack(side=LEFT,padx=5,pady=5)             
      # Copyright
      cop=Label(fNavButton,text=u'Copyright ACREA CR',bg=self.subColor, font="Arial 8 italic",fg='#000000')
      cop.pack(side=RIGHT)  
                  
      self.okno.mainloop()
      
   # Funkce tlatka OK 
   def callOkButton(self):
      """ Potvrzeni dialogu. """          
      self.okno.destroy()

# Uivatelsk dialog pro t-test
class Dialog:
   """
   Fsign je je hladina vznamnosti pro F-test o shod rozptyl.
   sort tdt podle signifikance t-testu 0 = ne 1 = ano
   sign zobrazit znamnka podle signifikance t-testu znamnka rozdlu (+ kladn rozdl a sig <0.05, - zporn rozdl a sign <0.05, 0 sign >=0.05) 0 = ne 1 = ano
   """   
   def start(self):      
      # Definice dialogu
      self.okno = Tk()
      self.okno.protocol('WM_DELETE_WINDOW', sys.exit)  #funkce pi zaven kkem

      w=self.okno.winfo_screenwidth()
      h=self.okno.winfo_screenheight()
      sirka=270
      vyska=450
      self.okno.geometry("%dx%d+%d+%d" % ( sirka, vyska, (w-sirka)/2, (h-vyska)/2 ) )
      self.okno.title('ACREA CR')

      bgColor='#f0f0f0'
      self.okno.config(bg=bgColor)

      # Parametry objekt
      ### Ohranien
      masterRelief=GROOVE
      framewidth=200

      ### Fonty
      titleFont = "Arial 14 bold"
      titleFontColor='#23238E'

      frameFont = "Arial 10 bold"
      frameFontColor='#cc0000'

      subframeFont = "Arial 9 bold"
      subframeFontColor='#cc0000'

      objectFont = "Arial 8"
      objectFontColor='#000000'

      ### Odsazen
      outerPadX=10
      outerPadY=10

      innerPadX=10
      innerPadY=10

      ### Barvy
      masterColor='#f0f0f0'
      subColor='#f0f0f0'

      f0 = LabelFrame(self.okno)
      f0.config(relief=masterRelief,padx=innerPadX,pady=innerPadY,bg=masterColor,width=framewidth)
      f0.pack()

      # Rm titulku
      fTitle = LabelFrame(self.okno)
      fTitle.config(relief=FLAT,padx=0,pady=0,bg=subColor)
      info = Label(fTitle,text=u'Zjednoduen tabulky \n t-testu',bg=subColor,font=titleFont,fg=titleFontColor)
      info.pack(side=LEFT)
      fTitle.pack(anchor=NW,expand=1,fill=X,padx=outerPadX,pady=0)

      f1 = LabelFrame(self.okno,text=u'Hladina vznamnosti F-testu')
      f1.config(relief=masterRelief,font=frameFont,padx=innerPadX,pady=innerPadY,bg=subColor,fg=frameFontColor,width=framewidth)
      self.Fsign = IntVar() 
      self.signifikance = Entry(f1,text=u'')
      self.signifikance.insert(1,"0.05")
      self.signifikance.pack()
      self.signifikance.focus_set()
      f1.pack(anchor=W,padx=outerPadX,pady=outerPadY)

      f2 = LabelFrame(self.okno,text=u'Volby')
      f2.config(relief=masterRelief,font=frameFont,padx=innerPadX,pady=innerPadY,bg=subColor,fg=frameFontColor,width=framewidth)

      self.trans = IntVar()
      preloz = Checkbutton(f2,text=u"Peloit tabulku",bg=subColor,fg=objectFontColor,variable=self.trans,onvalue=1,offvalue=0)
      preloz.select()
      preloz.pack(anchor=W)

      self.sign = IntVar()
      oznacit = Checkbutton(f2,text=u"Oznait signifikance znamnkem",bg=subColor,fg=objectFontColor,variable=self.sign,onvalue=1,offvalue=0)
      oznacit.select()
      oznacit.pack(anchor=W)

      self.color = IntVar()
      barva = Checkbutton(f2,text=u"Podbarvit signifikantn rozdly",bg=subColor,fg=objectFontColor,variable=self.color,onvalue=1,offvalue=0)
      barva.select()
      barva.pack(anchor=W)

      self.sort = IntVar()
      tridit = Checkbutton(f2,text=u"Tdit podle rozdlu prmr",bg=subColor,fg=objectFontColor,variable=self.sort,onvalue=1,offvalue=0,command=self.show)
      tridit.select()
      tridit.pack(anchor=W)

      f3 = LabelFrame(f2,text=u'Jak tdit?')
      f3.config(relief=masterRelief,font=subframeFont,padx=innerPadX,pady=innerPadY,bg=subColor,fg=subframeFontColor,width=framewidth)
      self.howtosort = IntVar() 
      self.vzestupne=Radiobutton(f3,text=u"Vzestupn",bg=subColor,fg=objectFontColor,variable=self.howtosort,value=0)
      self.vzestupne.select()
      self.vzestupne.pack(anchor=W) 
      self.sestupne=Radiobutton(f3,text=u"Sestupn",bg=subColor,fg=objectFontColor,variable=self.howtosort,value=1)
      self.sestupne.pack(anchor=W)
      f3.pack(anchor=W,padx=25)

      self.scientific = IntVar()
      vedecka = Checkbutton(f2,text=u"Vypnout vdeckou notaci sel",bg=subColor,fg=objectFontColor,variable=self.scientific,onvalue=1,offvalue=0)
      vedecka.select()
      vedecka.pack(anchor=W)

      f2.pack(anchor=W,padx=outerPadX,pady=outerPadY)

      f4 = LabelFrame(self.okno)
      f4.config(relief=FLAT,padx=0,pady=0,bg=subColor)

      Button(f4,text="OK",command=self.callOkButton,width=8).pack(side=LEFT,padx=5,pady=5)
      Button(f4,text="Storno",command=self.callCancelButton,width=8).pack(side=LEFT,padx=5,pady=5)
      cop=Label(f4,text=u'Copyright ACREA CR',bg=subColor,font="Arial 8 italic",fg='#000000')

      cop.pack(side=RIGHT)
      f4.pack(anchor=SW,fill=X,expand=1,pady=0,padx=0)

      self.okno.update() #aktualizace velikosti okna
      self.okno.minsize(self.okno.winfo_width(),self.okno.winfo_height()) #minimln velikost okna
      self.okno.mainloop()

   def show(self):
      if self.sort.get() == 1:
         self.vzestupne.config(state=NORMAL)
         self.sestupne.config(state=NORMAL)
      else:
         self.vzestupne.config(state=DISABLED)
         self.sestupne.config(state=DISABLED)        

   def callOkButton(self):      
      global Fsign
      try:
         Fsign = float(self.signifikance.get())
      except:
         chyba_tabulka = Warning()
         chyba_tabulka.windowWidth = 220
         chyba_tabulka.windowHeight = 95
         chyba_tabulka.hlaska = u"Signifikance byla zadan nesprvn.\nZvolte signifikanci znovu." 
         chyba_tabulka.start()
         
      if Fsign < 0 or Fsign > 1:
         chyba_tabulka = Warning()
         chyba_tabulka.windowWidth = 230
         chyba_tabulka.windowHeight = 95
         chyba_tabulka.hlaska = u"Signifikance nen slo v intervalu 0 a 1.\nZvolte signifikanci znovu." 
         chyba_tabulka.start()
      if Fsign <= 1 and Fsign >= 0:
         self.okno.destroy()
            
   def callCancelButton(self):
      SpssClient.StopClient()
      self.okno.destroy()

# Funkce prepoctu barvy z HLS do SPSS
def fncHLS2SPSS(mlHLS):
   import colorsys
   try:
      mlRGB = list(colorsys.hls_to_rgb(mlHLS[0],mlHLS[1],mlHLS[2]))
      mnSPSSColor = int(round(mlRGB[0]*255) + round(mlRGB[1]*255)*256 + round(mlRGB[2]*255)*256*256)
      return ( mnSPSSColor )
   except:
      pass

# Funkce podbarven
def urci_barvu(hodnota,barva):
   if barva == 0:
      L = 1 - 0.4*((Tsign1 - hodnota)/Tsign1)      
      return(fncHLS2SPSS([0,L,1]))
   else:
      L = 1 - 0.4*((Tsign1 - hodnota)/Tsign1)            
      return(fncHLS2SPSS([0.67,L,1]))

def uprava_nove_tabulky(objPivotTable):
   # Naten dat z nov pivotn tabulky 
   objRowLabels = objPivotTable.RowLabelArray()
   objColLabels = objPivotTable.ColumnLabelArray()
   objDataCells = objPivotTable.DataCellArray()

   # Zkoprovn dat 
   for i in range(0,objDataCells.GetNumRows(),2):
      if float(objDataCells.GetUnformattedValueAt(i,1)) < Fsign:
         for j in range(objDataCells.GetNumColumns()):
            hodnota = objDataCells.GetUnformattedValueAt(i+1,j)
            objDataCells.SetValueAt(i,j,hodnota)
            if objDataCells.GetNumericFormatAt(i+1,j) == "#.##E+##" and scientific == 1:
               objDataCells.SetNumericFormatAtWithDecimal(i,j,"#.#",objDataCells.GetHDecDigitsAt(i+1,j))
            else:
               objDataCells.SetNumericFormatAtWithDecimal(i,j,objDataCells.GetNumericFormatAt(i+1,j),objDataCells.GetHDecDigitsAt(i+1,j))               
      else:
         for j in range(objDataCells.GetNumColumns()):
            hodnota = objDataCells.GetUnformattedValueAt(i,j)
            objDataCells.SetValueAt(i+1,j,hodnota)
            if objDataCells.GetNumericFormatAt(i,j) == "#.##E+##" and scientific == 1:
               objDataCells.SetNumericFormatAtWithDecimal(i+1,j,"#.#",objDataCells.GetHDecDigitsAt(i,j))
            else:
               objDataCells.SetNumericFormatAtWithDecimal(i+1,j,objDataCells.GetNumericFormatAt(i,j),objDataCells.GetHDecDigitsAt(i,j))

   # Pivotace tabulky - assumptions do nejvy rovn v dcch
   objPivotManager = objPivotTable.PivotManager()
   for i in range(objPivotManager.GetNumRowDimensions()):
      objRowDim = objPivotManager.GetRowDimension(i)
      if objRowDim.GetDimensionName() == u"Assumptions":
         objRowDim.MoveToRow(objPivotManager.GetNumRowDimensions())
         objRowDim.HideLabel()
         break        

   # Vloen novho sloupce pro znamnko
   if sign == 1:
      objColLabels.InsertNewAfter(2,9,u"Sign Scheme")
   
   # prava symbol signifikance
   if sign == 1:      
      for i in range(objDataCells.GetNumRows()):
         hodnotaSig = float(objDataCells.GetUnformattedValueAt(i,5))
         hodnotaRozdil = float(objDataCells.GetUnformattedValueAt(i,6))
         if hodnotaSig < Tsign3:
            if hodnotaRozdil < 0:
               objDataCells.SetValueAt(i,10,"---")
            else:
               objDataCells.SetValueAt(i,10,"+++")
         elif hodnotaSig < Tsign2:      
            if hodnotaRozdil < 0:
               objDataCells.SetValueAt(i,10,"--")
            else:
               objDataCells.SetValueAt(i,10,"++")
         elif hodnotaSig < Tsign1:      
            if hodnotaRozdil < 0:
               objDataCells.SetValueAt(i,10,"-")
            else:
               objDataCells.SetValueAt(i,10,"+")
         else:
            objDataCells.SetValueAt(i,10,"o")
         if hodnotaSig < Tsign1:
            if hodnotaRozdil < 0:
               objDataCells.SetTextColorAt(i,10,65280)
            else:
               objDataCells.SetTextColorAt(i,10,255)
         objDataCells.SetTextSizeAt(i,10,11)      
         objDataCells.SetHAlignAt(i,10,SpssClient.SpssHAlignTypes.SpssHAlCenter)
         objDataCells.SetTextStyleAt(i,10,SpssClient.SpssTextStyleTypes.SpssTSBold)

   # Podbarven
   if color == 1:
      for i in range(objDataCells.GetNumRows()):
         if float(objDataCells.GetUnformattedValueAt(i,5)) < Tsign1:
            if float(objDataCells.GetUnformattedValueAt(i,6)) > 0:
               objDataCells.SetBackgroundColorAt(i,5,urci_barvu(float(objDataCells.GetUnformattedValueAt(i,5)),0))
            else:
               objDataCells.SetBackgroundColorAt(i,5,urci_barvu(float(objDataCells.GetUnformattedValueAt(i,5)),1))    

   # azen dk dle rozdlu prmr
   if sort== 1:
      # Setdn dk pesunem dk tabulky 
      if howtosort == 0:
         # Vzestupn
         for i in range(int(objRowLabels.GetNumRows()/2)):
            minimum = [float(objDataCells.GetUnformattedValueAt(i,6)),i]
            for j in range(i+1,int(objRowLabels.GetNumRows()/2)):
               if float(objDataCells.GetUnformattedValueAt(j,6)) < minimum[0]:
                  minimum = [float(objDataCells.GetUnformattedValueAt(j,6)),j]
            if minimum[1] > i:
               objPivotTable.ClearSelection()
               objRowLabels.SelectLabelAt(minimum[1],3)
               objRowLabels.InsertBefore(i,3)
      else:
         # Sestupn
         for i in range(int(objRowLabels.GetNumRows()/2)):
            maximum = [float(objDataCells.GetUnformattedValueAt(i,6)),i]
            for j in range(i+1,int(objRowLabels.GetNumRows()/2)):   
               if float(objDataCells.GetUnformattedValueAt(j,6)) > maximum[0]:
                  maximum = [float(objDataCells.GetUnformattedValueAt(j,6)),j]
            if maximum[1] > i:
               objPivotTable.ClearSelection()
               objRowLabels.SelectLabelAt(maximum[1],3)
               objRowLabels.InsertBefore(i,3)

   # Zruen sloupcovho popisu "t-test for Equality of Means"
   objPivotTable.ClearSelection()
   objColLabels.SelectLabelAt(1,2)  
   objPivotTable.Ungroup()

   # Peklad popis
   spolehlivost = objColLabels.GetValueAt(1,8)[0:2]
   if trans == 1:
      objPivotTable.SetTitleText(u"Dvouvbrov T-test")
      collabels = [u"Signifikance",u"% interval spolehlivosti pro rozdl",u"t",u"df",u"jednostrann",u"oboustrann",u"Rozdl prmr",u"Standardn chyba rozdlu",u"Doln mez",u"Horn mez",u"Znamnkov schma"]      
      for j in range(3,objColLabels.GetNumColumns()):
         objColLabels.SetValueAt(2,j,collabels[j])

##   # Zruen sloupcovho popisu "Significance"   
##   objPivotTable.ClearSelection()
##   print("ide49")
##   objColLabels.SelectLabelAt(1,4)
##   print("ide50")
##   objPivotTable.Ungroup()
##
##   # Zruen sloupcovho popisu "95% Confidence Interval of the Difference"   
##   objPivotTable.ClearSelection()
##   print("ide49")
##   objColLabels.SelectLabelAt(1,8)
##   print("ide50")
##   objPivotTable.Ungroup()
##
##   # Zruen sloupcovho popisu "Levene's Test for Equality of Variances"
##   print("ide60")
##   objPivotTable.ClearSelection()
##   objColLabels.SelectLabelAt(1,0)
##   objPivotTable.Ungroup()

   # Skryt prvnch dvou sloupc odpovdajcch popisu "Levene's Test for Equality of Variances"
   objColLabels.HideLabelsWithDataAt(2,0)
   objColLabels.HideLabelsWithDataAt(2,1)

   # Nov sloupcov popis "95% interval spolehlivosti pro rozdl"
   objPivotTable.ClearSelection()
##   for j in range(8,10):
##      objColLabels.SelectLabelAt(1,j)  
##   objPivotTable.Group()
   if trans == 1:
      objColLabels.SetValueAt(1,8,spolehlivost + collabels[1])
##   else:
##      objColLabels.SetValueAt(1,8,spolehlivost + u"% Confidence Interval of the Difference")

   # Nov sloupcov popis "Signifikance"
   objPivotTable.ClearSelection()
##   for j in range(4,6):
##      objColLabels.SelectLabelAt(1,j)  
##   objPivotTable.Group()
   if trans == 1:
      objColLabels.SetValueAt(1,4,collabels[0])
##   else:
##      objColLabels.SetValueAt(1,4,u"Significance")

##   # Obejit problmu se kou sloupcovho popisu "95% interval spolehlivosti pro rozdl"
##   objPivotTable.ClearSelection()
##   for j in range(7,9):
##      objColLabels.SelectLabelAt(1,j)  
##   objPivotTable.Group()
##   objPivotTable.ClearSelection()
##   objColLabels.SelectLabelAt(1,7)
##   objPivotTable.Ungroup()

   # Obejit problmu se kou sloupcovho popisu "95% interval spolehlivosti pro rozdl"
   objColLabels.SetColumnLabelWidthAt(2,8,80)
   objColLabels.SetColumnLabelWidthAt(2,9,80)

   # Obejit problmu se kou sloupcovho popisu "Signifikance"
   objColLabels.SetColumnLabelWidthAt(2,4,70)
   objColLabels.SetColumnLabelWidthAt(2,5,70)
   
   # Skryt nadbytench dk
   objRowLabels.HideLabelsWithDataAt(int(objRowLabels.GetNumRows()/2),1)   
   objRowLabels.SetValueAt(0,1,"")
   objRowLabels.SetRowLabelWidthAt(0,1,0)

def main():
   indexy = [] # loit index tabulek, kter se maj zpracovat.
   
   # Naten vstupovho okna a jeho obsahu
   objOutputDoc = SpssClient.GetDesignatedOutputDoc()
   objOutputItems = objOutputDoc.GetOutputItems()
   # Nalezen oznaen pivotn tabulky
   for index in range(objOutputItems.Size()):
      objOutputItem = objOutputItems.GetItemAt(index)
      if objOutputItem.IsSelected() and objOutputItem.GetSubType() == 'Independent Samples Test':
         indexy.append(index)
         if len(indexy) == 1:
            # Zobrazen vodnho dialogu  
            uvod = Dialog()
            uvod.start()
            global sign, sort, color, trans, scientific, howtosort
            sign=uvod.sign.get()
            sort=uvod.sort.get()
            color=uvod.color.get()
            trans=uvod.trans.get()
            scientific=uvod.scientific.get()
            howtosort=uvod.howtosort.get()

   if len(indexy) == 0:
      chyba_tabulka = Warning()
      chyba_tabulka.windowWidth = 280
      chyba_tabulka.windowHeight = 110
      chyba_tabulka.hlaska = u"Nebyla oznaen pslun tabulka. \nVyberte tabulku Independent Samples Test \nvytvoenou procedurou Independent-Samples T Test." 
      chyba_tabulka.start()
      SpssClient.StopClient()
   else:
      for i in range(len(indexy)):
         objOutputItem = objOutputItems.GetItemAt(indexy[-1*(i+1)])
         # Test, zda nen zapnut Split file
         objPivotTable = objOutputItem.GetSpecificType()
         objRowLabels = objPivotTable.RowLabelArray()
         
         if objRowLabels.GetNumColumns()<=4:
            # Pouze pokud nen pouit Split file, jinak m pole dkovch popis vt poet sloupc
            try: 
               # Kopie pvodn tabulky
               objOutputDoc.ClearSelection()
               objOutputItem.SetSelected(True)
               objOutputItem.SetCurrentItem()
               objOutputDoc.Copy()
               objOutputDoc.PasteBefore()
               objOutputItem.SetVisible(False)
               objPivotTable = objOutputItem.GetSpecificType()
               objPivotTable.SetUpdateScreen(False)
               uprava_nove_tabulky(objPivotTable)
               objPivotTable.SetUpdateScreen(True)
               objOutputItem.SetVisible(True)
            except:
               chyba_tabulka = Warning()
               chyba_tabulka.windowWidth = 320
               chyba_tabulka.windowHeight = 95
               chyba_tabulka.hlaska = u"Ve skriptu dolo k chyb. Vytvote tabulku \nIndependent Samples Test jet jednou a spuste skript znovu." 
               chyba_tabulka.start()
         else:
            chyba_tabulka = Warning()
            chyba_tabulka.windowWidth = 250
            chyba_tabulka.windowHeight = 95
            chyba_tabulka.hlaska = u"Tabulku nelze tmto skriptem zpracovat. \nPravdpodobn byla pouita funkce Split file." 
            chyba_tabulka.start()
         
try:
   SpssClient.StartClient() 
   main()
except:
   pass
finally:
   SpssClient.StopClient()
