#pracovni adresar
setwd()

install.packages("nortest") #testy normality
install.packages("car") #leveneho test
install.packages("summarytools") #tabulka s popisnou statistikou na urovni skupin
install.packages("effsize") #cohenovo d 
install.packages("psych") #popisna statistika (describeBy)

library(nortest)
library(car)
library(summarytools)
library(effsize)
library(psych)

#Import dat 
data <- read.spss("zamestnanci.sav", to.data.frame = TRUE)

#Interval spolehlivosti pro prumer
#Promenna spokojenost celkova
spokojenost <- data$spokojenost_celkova
summary(spokojenost)
sd(spokojenost)
#V prumeru je spokojenost zamestnancu na urovni cca 70% a jeji smerodatna odchylka
#je rovna 11%.

#vypocet intervalu spolehlivosti pomoci funkce 
#funkce t.test
?t.test
ls(t.test(spokojenost)) #zobrazeni struktury vystupu
#95% interval spolehlivosti
t.test(spokojenost)$"conf.int"
#Se spolehlivosti 95% se bude populacni hodnota prumeru pohybovat v intervalu
#0,689 az 0,700
#99% interval spolehlivosti 
t.test(spokojenost, conf.level = 0.99)$"conf.int"
#Se spolehlivosti 99% se bude populacni hodnota prumeru pohybovat v intervalu
#0,687 az 0,702
# Pri zvysovani hladiny spolehlivosti se bude interval rozsirovat!!

#1S T-test
# Da se rici, ze spokojenost je v prumeru rovna 70%?
#H0: prumer = 0.7
#H1: prumer neni roven 0.7
t.test(spokojenost, mu=0.7)
t.test(spokojenost, mu=0.7)$p.value
format(t.test(spokojenost, mu=0.7)$p.value, scientific = FALSE)
#signifikance - 0,066 , alpha - 0.05
#signifikance>alpha ----> nezamitame H0

#jednostranna alternativa 
#H0: spokojenost >= 0.7
#H1: zpozdeni<0.7
t.test(spokojenost,alternative ="less", mu=0.7)
#signifikance (0,03)<alpha(0,05) -----> zamitame H0

#H0:spokojenost <= 0.7
#H1: spokojenost > 0.7
t.test(spokojenost,alternative ="greater", mu=0.7)
#signifikance (0.9669) > alpha (0.05) -----> nezamitame h0

#Kontrola rozdeleni 
hist(spokojenost)

#Neparametricky test - Wilcoxonuv znamenkovy test
#H0: median spokojenosti = 0.7
#H1: median spokojenosti neni roven 0.7
?wilcox.test
wilcox.test(spokojenost,mu=0.7)
#signifikance (0.0001975)< alpha (0.05) ----> zamitame H0


#Dvouvyberov t-test
#Lisi se spokojenost v zavislosti na pohlavi?  
#V pripade, ze se lisi, jak se lisi a jak silny je efekt promenne pohlavi? 
pohlavi <- data$pohlavi

hist(spokojenost)
hist(spokojenost, breaks = "Scott")
freq(pohlavi)

boxplot(spokojenost~pohlavi)
describeBy(spokojenost,pohlavi)
#prumery jsou temer stejne 

#Predpoklady
#Normalita - normalne rozdeleni v obou skupinach
#Posuzovani na zaklade histogramu
ggplot(data,aes(spokojenost,fill = as.factor(pohlavi)))+
  geom_histogram(alpha=0.5,bins = 20)
#vytvoreni podmnozin pro jednotlive skupiny a pak vykresleni histogramu pomoci funkce hist
zeny <- subset(data,pohlavi == "zena")
muzi <- subset(data,pohlavi == "muz")
hist(zeny$spokojenost_celkova,breaks = "Scott")
hist(muzi$spokojenost_celkova,breaks = "Scott")


#Testy normality
#H0: normalita - splneni predpokladu
#H1: "nenormalita" - poruseni predpokladu ---> neparametricky test
ad.test(zeny$spokojenost_celkova)
ad.test(muzi$spokojenost_celkova)
#pro obe skupiny se zamita nulova hypoteza o normalite

shapiro.test(zeny$spokojenost_celkova)
shapiro.test(muzi$spokojenost_celkova)
#pro obe skupiny se zamita nulova hypoteza o normalite

ks.test(zeny$spokojenost_celkova,"pnorm")
ks.test(muzi$spokojenost_celkova,"pnorm")
#pro obe skupiny se zamita nulova hypoteza o normalite

#Test shody rozptylu
#H0: rozptyly v skupinach jsou stejne - splneni predpokladu
#H1: rozptyly v skupinach nejsou stejne - poruseni predpokladu -->Welschuv test
leveneTest(spokojenost,as.factor(pohlavi),center="mean")
#kategorizovana promenna (napr.pohlavi) definovana jako faktor!
#signifikance (0.6215) > alpha(0.05) ---> nezamitame h0, splneni predpokladu

#Dvouvyberovy t-test
#H0: spokojenost je stejna pro muze i pro zeny
#H1: spokojenost je v zavislosti na pohalvi odlisna 
t.test(spokojenost~as.factor(pohlavi),var.equal = TRUE)
#signifikance(0.2073)>alpha(0.05) ---> nezamitame H0
#SPokojenost neni statisticky vyznamne odlisna pro muze a pro zeny 

#Welschuv test 
#Pouzijeme v situaci, kdy jsou rozptyly odlisne
t.test(spokojenost~as.factor(pohlavi),var.equal = FALSE)
 
#Cohenovo D - vyjadreni sily efektu 
#V intervalu (0,1)
cohen.d(spokojenost,as.factor(pohlavi))
#d= 0.06 ---> nezavislot 

#Wilcoxon Sum rank - neparametricka alternativa 
#H0: stejne rozdeleni pro obe skupiny
#H1: rozdilne rozdeleni - lisi se z hladiska rozptylu,nebo prumeru, nebo oboji
wilcox.test(zeny$spokojenost_celkova,muzi$spokojenost_celkova, paired = FALSE)
#signifikance(0.1346)>alpha(0.05) ---> nezamitame H0

#spokojenost vs- odchod
#H0: spokojenost je stejna pro stavajici zamestnance i pro zamestnance, kteri odeli 
#H1: spokojenost se lisi 

#test shody rozptylu 
leveneTest(spokojenost,data$odchod,center = "mean")
#signifikance(0.3526)>alpha(0.05) ---> nezamitame H0

t.test(spokojenost~data$odchod,var.equal=TRUE)
#signifikance(0.000003)<alpha(0.05) ---> zamitame H0 o shode spokojenosti

cohen.d(spokojenost,data$odchod)
#0.32 - slabsi efekt 

#Parovy t-test
#stejna nulova hypoteza ako u 2S T-testu
#H0: spokojenost se v case nezmenila
#H1: spokojenost se zmenila
spokojenost_predchozi <- data$spokojenost_celkova_predchozi
summary(spokojenost)
summary(spokojenost_predchozi)

#normalitu overujeme pro rozdil testovanych promennych
data$rozdil <- spokojenost - spokojenost_predchozi
hist(data$rozdil)

t.test(spokojenost,spokojenost_predchozi,paired = TRUE)
#signifikance (0.000) < alpha (0.05) ---> zamitame H0, spokojenost se v case zmenila 
# v minulosti byla vyssi 

#Wilcoxon - neparametricka alternativa paroveho t-testu 
#H0: rozdeleni spokojenosti je stejne v obou skupinach
#H1: rozdelenis pokojenosti je odlisne
wilcox.test(spokojenost,spokojenost_predchozi,paired = TRUE)



