install.packages("foreign")
install.packages("ggplot2")
library(foreign)
library(ggplot2)

#Import dat
data <- read.spss("zamestnanci.sav", to.data.frame = TRUE)
View(data)

#Bodovy graf 
ggplot(data, aes(mzda_zvyseni, spokojenost_celkova)) +
  geom_point()

#Dokresleni linearni primky + transparentnost bodu 
ggplot(data, aes(mzda_zvyseni, spokojenost_celkova)) +
  geom_point(alpha = 0.5) +
  geom_smooth(method = "lm", se = FALSE)

#Model jednoduche linearni regrese
# tilda - pravy alt + 1 (horni cast klvesnice)
# funkce lm pro linearni regresi
# model 1 - jak zavisi spokojenost na zvyseni mzdy?
model1 <- lm(spokojenost_celkova ~ mzda_zvyseni, data)
model1

# B0 - urovnova konstanta
# Hodnota spokojenosti pro zamestnance se zvysenim mzdy o 0% bude v prumeru 0.64
# B1 - sklon primky 
# Pokud zvysime promennou mzda_zvyseni o 1% , v prumeru sa spokojenost zvysi o 0,03%

#je mozny se odkazovat na jednotlive casti vystupu 
summary(model1)$r.squared #modelem 1 jsme vysvetlili 1,2% variability zavisle promenne
summary(model1)$fstatistic # zamita se nulova hypoteza o nevyznamnosti modelu jako celku
summary(model1)$coefficients

#diagnostika rezidui
data$predict_y <- predict(model1) #ulozeni predikovanych hodnot do samostatne promenne predict_y
data$residuals <- residuals(model1) #ulozeni rezidui do promenne residuals 

#rezidua - diagnostika
#rezidua pro jenotlive body 
ggplot(data, aes(mzda_zvyseni,spokojenost_celkova))+
  geom_smooth(method = "lm", se = FALSE)+
  geom_segment(aes(xend = mzda_zvyseni, yend = predict_y), alpha= 0.2)+
  geom_point(aes(color = abs(residuals), size = abs(residuals)))+
  scale_color_continuous(low = "green", high ="red")+
  guides(color=FALSE, size=FALSE)+
  geom_point(aes(y=predict_y), shape = 1)+
  theme_bw()

#standardizovana rezidua 
data$standardizovana_rezidua <- rstandard(model1)

#rezidua vs predikovane hodnoty - testovani homoskedasticity
ggplot(data, aes(predict_y,standardizovana_rezidua)) +
  geom_point()+
  geom_hline(yintercept=0,color="red")

# rezidua - normalni rozdeleni
hist(data$residuals)
#odchylky od normality ---> poruseni predpokladu lin, regrese

#test normality
ks.test(data$residuals,"pnorm")
#zamita se nulova hypoteza o nomalite

#predikovane hodnoty vs y
ggplot(data, aes(predict_y, spokojenost_celkova)) +
  geom_point()+
  geom_abline(slope=1, color="blue")

#vicenasobna linearni regrese - vplyv pohlavi 
model2 <- lm(spokojenost_celkova ~ mzda_zvyseni+odchod, data)
summary(model2)

#tvorba indikatoru
data$bakalarske_vzdelani <- ifelse(data$vzdelani == "bakalarske",1,0)
data$magisterske_vzdelani <- ifelse(data$vzdelani == "magisterske",1,0)
data$PHD <- ifelse(data$vzdelani == "Ph.D.",1,0)

#TVORBA INDIKATORU pomoci balicku fastDummies
#vytvori automaticky indikator pro vsechny kategorie zvolene promenne
#najednou i vice promennych
#vhodnejsi ulozit do noveho data framu
install.packages("fastDummies")
library(fastDummies)
data2 <- dummy_cols(data, select_columns = c("vzdelani"))

#model 3
# celkova spokojenost = b0 + b1*zvyseni mzdy+b2* odchod + b3*bakalarske vzdelani
#+b4*magisterske vzdelani+b5*Phd
model3 <- lm(spokojenost_celkova ~ mzda_zvyseni+odchod+bakalarske_vzdelani+magisterske_vzdelani+PHD, data)
summary(model3)

#automaticky vyber prediktoru
#nekolik balicku
install.packages("MASS") #stepwise, AIC
library(MASS)

#stepwise pomoci baiku MASS
#uprava promennej id tak aby bylo id od 1 dpo1470
data$ID <- c(1:1470)

full_model <- lm(spokojenost_celkova ~ .,data[,2:31])
step.model <- stepAIC(full_model,trace = FALSE)
summary(step.model)

#ulozeni rezidui z modelu
rezidua <- step.model$residuals
#ulozeni predikovanych hodnot z modelu
predikce <- predict(step.model)
#ulozeni indexu pro pozorovani, ktere nebyly zarazeny do vypoctu modelu
na <- step.model$na.action 
#vytvoreni pomocne promenne ID pro urceni validnich pozorovani
ID <- ifelse(data$ID %in% na,0,data$ID)
ID <- ID[ID!=0]
#vytvoreni data framu s hodnotou rezidui, predikovanych hodnot a ID pozorovani
data_doplnek <- data.frame(ID,rezidua,predikce)

#pripojeni rezidui a predikovanych hodnot k datove matici data na zaklade ID  
library(dplyr)
data <- data %>% left_join(data_doplnek, by="ID")

hist(data$rezidua)
ks.test(data$rezidua,"pnorm")
#nadale porusena normalita rezidui 

#stepwise pomoci baliku caret
install.packages("caret")
library(caret)
step.model2 <- train(spokojenost_celkova ~ ., data = data, method = "leapSeq", na.action = na.omit)
summary(step.model2)
step.model2$results
step.model2$bestTune #ktery model byl nejlepsi
summary(step.model2$finalModel) #ktere promenne jsou ve finalnim modelu
coef(step.model2$finalModel,4) #koeficienty nejlepsiho modelu

