# nastaveni pracovniho adresare

getwd()
setwd("D:/Kurzy/Zaklady_statistiky_v_jazyce_R/Data")

# budeme pracovat s datovym souborem zamestnanci.sav
# nacitani dat z spss

library(foreign)
data <- read.spss("zamestnanci.sav", to.data.frame = TRUE)
head(data)
str(data)

# popis a vizualizace kategorizovane promenne - vzdelani

unique(data$vzdelani)
data$vzdelani <- factor(data$vzdelani, levels = c("stredoskolske","bakalarske","magisterske", "Ph.D."),
                        labels = c("SŠ", "VŠ-Bc", "VŠ-Mgr", "VŠ-Ph.D")) 
unique(data$vzdelani)

# tabulka cetnosti 

library(summarytools)
freq(data$vzdelani) 

# sloupcovy graf

TC <- transform(table(data$vzdelani)) # absolutni cetnost
colnames(TC) <- c("Vzdelani", "Cetnost")
View(TC)

barplot(height = TC$Cetnost, 
        names.arg = TC$Vzdelani,
        main = "Vzdělání zamestnanců", 
        ylab = "Absolutní četnost", 
        col = c("seagreen2", "dodgerblue2", "red", "yellow"))

# export obrazku

# kolacovy graf

pie(TC$Cetnost)

pie(TC$Cetnost,
    clockwise = TRUE,
    labels = TC$Cetnost,
    main = "Vzdělání",
    col = c("seagreen2", "dodgerblue2", "red", "yellow"))

legend(x = "bottomleft", legend = TC$Vzdelani, fill = c("seagreen2", "dodgerblue2", "red", "yellow"))

# popis a vizualizace kvantitativni promenne

str(data$mzda)

# histogram

hist(data$mzda)

hist(data$mzda, 
     xlab = "Mzda",
     ylab = "Absolutní četnost",
     main = "Mzda zamestnanců",
     col = "lightblue")

# popisna statistika

stats <- descr(data$mzda)
stats <- as.data.frame(stats)
stats <- round(stats, 4)

# export tabulky stats
library(writexl)

statistika <- rownames(stats)
stats$statistika <- statistika

write_xlsx(stats, "stats.xlsx")

# pridani prumeru do histogramu

abline(v = mean(data$mzda), col = "red", lw = 2)

# pridani medianu do grafu

abline(v = quantile(data$mzda, 0.5), col = "blue", lw = 2) 
# median < prumer, co nam to rika o charakteru dat? -> zesikmeni

# pridani kvantilu do grafu

abline(v = quantile(data$mzda, 0.25), col = "orange", lw = 3) 
abline(v = quantile(data$mzda, 0.75), col = "orange", lw = 3) 

# dalsi vizualizace ciselne promenne

# boxplot

boxplot(data$mzda)

boxplot(data$mzda,
        col = "lightgreen",
        main = "Boxplot",
        horizontal = TRUE)

# odlehle pozorovani

odlehle <- boxplot(data$mzda)$out
sort(odlehle)
data[data$mzda < 16595, ] # odfiltrovani odlehych pozorovani

# mzda je ciselna promenna ze spojiteho rozdeleni, 
# vzdelani je faktor, podle ktereho tridim

boxplot(formula = data$mzda ~ data$vzdelani, 
        col = rainbow(4),
        main = "Mzda ~ vzdělání",
        xlab = "",
        ylab = "Mzda")

# popisne statistiky pro kazdou kategorii vybrane promenne

library(psych)
psych::describeBy(data$mzda,
                  data$vzdelani) # kategorie promenne vzdelani


