# DATA ####

# import dat
library(foreign)
data <- read.spss("zamestnanci.sav", to.data.frame = TRUE)
str(data)

library(summarytools) 

# tabulky cetnosti
freq(data$spokojenost_prace)
freq(data$odchod)

# kontingencni tabulka
?ctable
ctable(x = data$spokojenost_prace, y = data$odchod)
ctable(x = data$spokojenost_prace, y = data$odchod, prop = "t")
ctable(x = data$spokojenost_prace, y = data$odchod, totals = FALSE)

# priprava pro export
KT <- ctable(x = data$spokojenost_prace, y = data$odchod)
library(plyr)
KT <- KT[1]
KT <- ldply(KT, data.frame)

# nebo
KT <- xtabs(~ spokojenost_prace + odchod, data)
KT <- ftable(KT)
result <- stats:::format.ftable(KT, quote = FALSE)

# CHI-KVADRAT TEST NEZAVISLOSTI ####
?chisq.test
chi <- chisq.test(x = data$spokojenost_prace, y = data$odchod)
chi$expected # ocekavane ocekavane
# jak se pocitaji ocekavane cetnosti
1233*289/1470 # expected (nizka, neodesel) 242.4061
chi$expected # ocekavane ocekavane
chi$observed # pozorovane cetnosti

# overeni predpokladu
chi$expected > 1 # vsechny bunky maji ocekavanou cetnost > 1
chi$expected > 5 # vsechny bunky maji ocekavanou cetnost > 5
paste(sum((chi$expected > 5) == TRUE)/8 *100, "% bunek ma ocekavanou cetnost > 5") # 100 % bunek ma ocekavanu cetnost > 5 
# length(unique(data$odchod))*length(unique(data$spokojenost_prace))

# FISHERUV EXAKTNI TEST ####
# v pripade nesplneni podminek
fisher.test(x = data$spokojenost_prace, y = data$odchod)

# Fisheruv exaktni test je vypocetne narocne pro vetsi tabulky
# v takovem pripade se doporucuje metoda monte carlo
fisher.test(x = data$spokojenost_prace, y = data$vzdelani) # vraci error - narocni na pamat
# MONTE CARLO ####
fisher.test(x = data$spokojenost_prace, y = data$vzdelani, simulate.p.value = TRUE) # metoda Monte Carlo
?fisher.test # upozorneni - objekt musi byt fo forme matice nebo ako faktor

# MIRY ASOCIACE ####
library(greybox) # pro funkci assoc()
?assoc

greybox::assoc(x = data$spokojenost_prace, y = data$odchod) # Cramerovo V pre dve kategorialni promenne
?cor() # kendall, spearman

# CTYRPOLNI TABULKY ####

ctable(data$pohlavi, data$odchod, prop = "n", OR = TRUE)

sance1 = 501/87 # u zen je sance zustat v zamestnani 501/87
sance2 = 732/150 # u muzu je sance zustat v zamestani 732/150
pomer_sanci = sance1/sance2 # 1.18

# sance zustat v zamestnani je u zen vyssi nez u muzu 
# sance odchodu ze zamestnani je u zen nizsi nez u muzu 
# pomer sanci je ale blizky 1 - hovori o nezavislosti velicin
# interval obsahuje 1

fisher.test(data$pohlavi, data$odchod) # stejny vysledek ako rucnym vypoctem 1.18
ctable(x = data$pohlavi, y = data$odchod, OR = TRUE)

# VIZUALIZACE ####

# 100% skladany sloupcovy graf
library(ggplot2)
ggplot(data = data, mapping = aes(x = spokojenost_prace, fill = odchod)) +
  geom_bar(position = "fill") +
  coord_flip()

# mozaikovy graf
library(vcd) # pro funkci mosaic()
KT <- table(x = data$spokojenost_prace, y = data$odchod) # tabulka - abs. cetnost
mosaic(KT, shade = TRUE)  
