# DATA ####

# import dat
library(foreign)
data <- read.spss("zamestnanci.sav", to.data.frame = TRUE)

# Lisi se spokojenost v zavislosti na pracovne pozici?

# tabulka cestnosti - pozice
library(summarytools)
freq(data$pozice)

# boxplot - spokojenost podle pozice
boxplot(data$spokojenost_celkova ~ data$pozice, col = rainbow(9))

# error bars - spokojenost podle pozice
library(ggpubr)
ggline(data, x = "pozice", y = "spokojenost_celkova", add = c("mean_se"))

# popisne statistiky - spokojenost podle pozice
library(psych)
describeBy(data$spokojenost_celkova, data$pozice)

# uprava pro export popisnych statistik
popis <- describeBy(data$spokojenost_celkova, data$pozice)
library(plyr)
popis <- ldply(popis, data.frame)

# ANOVA ####

# H0: spokojenost je stejna bez ohledu na pracovni pozici, stredne hodnoty jsou stejne
# H1: alespon jedna pozice se z hladiska spokojenosti odlisuje, alespon jedna stredni hodnota se lisi

# overovani normality
# H0: data jsou normalne rozdelena
# H1: data nejsou normalne rozdelena
# graficky

library(lattice)
histogram(~ spokojenost_celkova | pozice, data = data,
          layout = c(3, 3),  # rozlozeni grafu
          col = "lightblue", 
          main = "Histogramy podle pracovni pozice",
          xlab = "Spokojenost")

# testem
by(data$spokojenost_celkova, data$pozice, shapiro.test)

# overovani zhody rozptylu
# Levene test
# H0: zhoda rozptylu ve skupinach
# H1: nezhoda

library(car)
leveneTest(data$spokojenost_celkova, data$pozice, center = "mean") 

# ANOVA
?aov
aov(data$spokojenost_celkova ~ data$pozice)
summary(aov(data$spokojenost_celkova ~ data$pozice))
oneway.test(data$spokojenost_celkova ~ data$pozice, var.equal = TRUE)

# sila efektu - eta2
format(((0.056/(0.056+17.99))^2), scientific = FALSE) # alt + 94

# Lisi se spokojenost v zavislosti na vzdelani?

# H0: spokojenost je stejna bez ohledu na vzdelani
# H1: alespon jedna skupina vzdelani se z hladiska spokojenosti odlisuje

library(summarytools)
freq(data$vzdelani)

# error bars - spokojenost podle vzdelani
ggline(data, x = "vzdelani", y = "spokojenost_celkova", add = c("mean_se"))

# overovani normality
# H0: data jsou normalne rozdelena
# H1: data nejsou normalne rozdelena

# graficky
histogram(~ spokojenost_celkova | vzdelani, data = data,
          layout = c(2, 2),  # rozlozeni grafu
          col = "lightblue", 
          main = "Histogramy podle vzdelani",
          xlab = "Spokojenost")

# testem
by(data$spokojenost_celkova, data$vzdelani, shapiro.test)

# overovani zhody rozptylu
# Levene test
# H0: zhoda rozptylu
# H1: nezhoda

leveneTest(data$spokojenost_celkova, data$vzdelani, center = "mean") 

# WELCHUV TEST ####
oneway.test(spokojenost_celkova ~ vzdelani, data, var.equal = FALSE)

# BROWN-FORSYTHUV TEST ####

library(oneway.tests)
bf.test(spokojenost_celkova ~ vzdelani, data)

# POST-HOC ANALYZA ####

library(rstatix)
# Games-Howel test
games_howell_test(data, spokojenost_celkova ~ vzdelani, conf.level = 0.95, detailed = FALSE)

# Tukey HSD test
model <- aov(data$spokojenost_celkova ~ data$vzdelani)
TukeyHSD(model)

# KRUSKAL-WALISUV TEST ####
# neparametricky
kruskal.test(data$spokojenost_celkova ~ data$vzdelani)
pairwise.wilcox.test(data$spokojenost_celkova, data$vzdelani, p.adjust.method = "bonf")


